package de.z0rdak.yawp.data.region;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.GlobalRegion;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_2960;

public class GlobalRegionData extends class_18 {

    public static final String GLOBAL_REGION_FILE_NAME = "global";

    public static final Codec<GlobalRegionData> CODEC = RecordCodecBuilder.create(
            instance -> instance.group(
                    class_2960.field_25139.fieldOf("id")
                            .forGetter(r -> GlobalRegion.GLOBAL),
                    GlobalRegion.CODEC.optionalFieldOf("global", new GlobalRegion())
                            .forGetter(GlobalRegionData::getGlobal))
                    .apply(instance, GlobalRegionData::new));

    public final static class_10741<GlobalRegionData> TYPE = new class_10741<GlobalRegionData>(
            Constants.MOD_ID + "/" + GLOBAL_REGION_FILE_NAME,
            (ctx) -> new GlobalRegionData(),
            (ctx) -> CODEC,
            null);

    private final class_2960 id;
    private GlobalRegion globalRegion;

    public GlobalRegionData(){
       this.id = GlobalRegion.GLOBAL;
       this.globalRegion = new GlobalRegion();
    }

    public GlobalRegionData(class_2960 id, GlobalRegion globalRegion) {
        this.globalRegion = globalRegion;
        this.id = id;
    }

    public GlobalRegion getGlobal() {
        return globalRegion;
    }

    public class_2960 getId() {
        return id;
    }

    public void reset() {
        this.globalRegion = new GlobalRegion();
    }
}

