package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.ChatLinkBuilder.buildFlagMuteToggleLink;
import static de.z0rdak.yawp.util.ChatLinkBuilder.buildFlagOverrideToggleLink;

public class FlagDetailMessage implements MultiLineMessage<IFlag> {

    private final IProtectedRegion region;
    private final IFlag flag;
    private final List<class_2561> regionInfoLines;

    public FlagDetailMessage(IProtectedRegion region, IFlag flag) {
        this.region = region;
        this.flag = flag;
        this.regionInfoLines = new ArrayList<>();
    }

    @Override
    public IFlag getContent() {
        return this.flag;
    }

    /**
     * Builds the flag info component for the given flag and region. <br>
     * == Flag info for [flagname] of [region] == <br>
     * State: state [set state] <br>
     * Alert: [active] <br>
     * Override: [false] <br>
     * Message: [set] [x]: 'msg' <br>
     */
    @Override
    public List<class_2561> getLines() {
        regionInfoLines.clear();
        class_5250 header = buildFlagInfoHeader(region, flag);
        regionInfoLines.add(header);
        class_5250 state = buildInfoComponent("cli.flag.state", "State", buildFlagStateComponent(region, flag));
        class_5250 override = buildInfoComponent("cli.flag.override", "Override", buildFlagOverrideToggleLink(region, flag, false));
        regionInfoLines.add(state);
        regionInfoLines.add(override);
        if (RegionFlag.hasPlayerCategory(flag)) {
            class_5250 alert = buildInfoComponent("cli.flag.msg.mute", "Alert", buildFlagMuteToggleLink(region, flag, false));
            class_5250 message = buildInfoComponent("cli.flag.msg.text", "Message", buildFlagMessageComponent(region, flag));
            regionInfoLines.add(alert);
            regionInfoLines.add(message);
        }
        return regionInfoLines;
    }

}
