package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.util.text.Messages;
import net.minecraft.class_2561;
import net.minecraft.class_5250;


public class PaginationControl {

    private final String command;
    private final int numberOfPages;
    private final PaginationLinks links;
    private final int pageNumber;
    private final int pageSize;

    public PaginationControl(String cmd, int pageNumber, int pageSize, int numberOfPages) {
        this.command = cmd;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.numberOfPages = numberOfPages;
        this.links = new PaginationLinks(cmd, pageNumber, pageSize, numberOfPages);
    }

    public int pageNumber() {
        return pageNumber;
    }

    public int pageSize() {
        return pageSize;
    }

    public int numberOfPages() {
        return numberOfPages;
    }

    public class_5250 build() {
        boolean hasMultiplePages = this.numberOfPages > 1;
        class_5250 first = this.links.buildFirstLinkArrow(this.command, this.pageNumber, hasMultiplePages);
        class_5250 prev = this.links.buildPrevLinkArrow(this.command, this.pageNumber, hasMultiplePages);
        class_5250 next = this.links.buildNextLinkArrow(this.command, this.pageNumber, numberOfPages, hasMultiplePages);
        class_5250 last = this.links.buildLastLinkArrow(this.command, this.pageNumber, numberOfPages, hasMultiplePages);
        return this.buildControl(first, prev, next, last);
    }
    
    public class_5250 buildControl(class_5250 front, class_5250 back, class_5250 forward, class_5250 last) {
        // [<<]  [<]  x/n  [>]  [>>]
        class_5250 pageIndicator = class_2561.method_43470((this.pageNumber + 1) + "/" + (this.numberOfPages));
        return Messages.substitutable(" %s  %s  %s  %s  %s", front, back, pageIndicator, forward, last);
    }

}
