/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import de.z0rdak.yawp.core.area.MarkedAreaTypes;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3341;
import org.apache.commons.lang3.NotImplementedException;

public class CuboidArea
extends MarkedArea {
    public static MapCodec<CuboidArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2338.field_25064.fieldOf("p1").forGetter(CuboidArea::getAreaP1), (App)class_2338.field_25064.fieldOf("p2").forGetter(CuboidArea::getAreaP2), (App)Codec.STRING.fieldOf("areaType").forGetter(r -> MarkedAreaTypes.areaIdentifier(r.getAreaType()).toString()), (App)BlockDisplayProperties.CODEC.fieldOf("display").orElse((Object)BlockDisplayProperties.createRndDefault()).forGetter(MarkedArea::getDisplay)).apply((Applicative)instance, (p1, p2, area, display) -> {
        CuboidArea cuboid = new CuboidArea((class_2338)p1, (class_2338)p2);
        cuboid.updateDisplay((BlockDisplayProperties)display);
        return cuboid;
    }));
    private class_3341 area;
    private class_2338 p1;
    private class_2338 p2;

    @Override
    public MarkedAreaType<?> getType() {
        return MarkedAreaTypes.CUBOID_AREA;
    }

    public CuboidArea(class_3341 area) {
        super(AreaType.CUBOID);
        this.area = area;
    }

    public CuboidArea(class_2338 p1, class_2338 p2) {
        this(class_3341.method_34390((class_2382)p1, (class_2382)p2));
        this.p1 = AreaUtil.getLowerPos(p1, p2);
        this.p2 = AreaUtil.getHigherPos(p1, p2);
    }

    public static CuboidArea expand(CuboidArea area, int min, int max) {
        class_2338 p1 = area.getAreaP1();
        class_2338 p2 = area.getAreaP2();
        CuboidArea expanded = new CuboidArea(new class_2338(p1.method_10263(), min, p1.method_10260()), new class_2338(p2.method_10263(), max, p2.method_10260()));
        expanded.updateDisplay(area.getDisplay());
        return expanded;
    }

    private static boolean isInFacePlane(class_2338 point, class_2338 corner1, class_2338 corner2, class_2338 corner3, class_2338 corner4) {
        return point.method_10263() >= corner1.method_10263() && point.method_10263() <= corner2.method_10263() && point.method_10264() >= corner1.method_10264() && point.method_10264() <= corner3.method_10264() && point.method_10260() >= corner1.method_10260() && point.method_10260() <= corner4.method_10260();
    }

    private static List<class_2338> getBlocksInFace(class_2338 corner1, class_2338 corner2, class_2338 corner3, class_2338 corner4) {
        ArrayList<class_2338> blocksInFace = new ArrayList<class_2338>();
        int minX = Math.min(Math.min(corner1.method_10263(), corner2.method_10263()), Math.min(corner3.method_10263(), corner4.method_10263()));
        int minY = Math.min(Math.min(corner1.method_10264(), corner2.method_10264()), Math.min(corner3.method_10264(), corner4.method_10264()));
        int minZ = Math.min(Math.min(corner1.method_10260(), corner2.method_10260()), Math.min(corner3.method_10260(), corner4.method_10260()));
        int maxX = Math.max(Math.max(corner1.method_10263(), corner2.method_10263()), Math.max(corner3.method_10263(), corner4.method_10263()));
        int maxY = Math.max(Math.max(corner1.method_10264(), corner2.method_10264()), Math.max(corner3.method_10264(), corner4.method_10264()));
        int maxZ = Math.max(Math.max(corner1.method_10260(), corner2.method_10260()), Math.max(corner3.method_10260(), corner4.method_10260()));
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 currentPos = new class_2338(x, y, z);
                    if (!CuboidArea.isInFacePlane(currentPos, corner1, corner2, corner3, corner4)) continue;
                    blocksInFace.add(currentPos);
                }
            }
        }
        return blocksInFace;
    }

    @Override
    public boolean contains(class_2338 pos) {
        return pos.method_10263() >= this.area.method_35415() && pos.method_10263() <= this.area.method_35418() && pos.method_10264() >= this.area.method_35416() && pos.method_10264() <= this.area.method_35419() && pos.method_10260() >= this.area.method_35417() && pos.method_10260() <= this.area.method_35420();
    }

    public boolean contains(CuboidArea inner) {
        return this.area.method_35415() <= inner.area.method_35415() && this.area.method_35418() >= inner.area.method_35418() && this.area.method_35416() <= inner.area.method_35416() && this.area.method_35419() >= inner.area.method_35419() && this.area.method_35417() <= inner.area.method_35417() && this.area.method_35420() >= inner.area.method_35420();
    }

    public boolean contains(SphereArea inner) {
        int sphereRadius = inner.getRadius();
        class_2338 center = inner.center;
        if (!this.intersects(inner)) {
            return false;
        }
        int maxDistanceToCorner = this.maxDistanceToCorners(center);
        if (maxDistanceToCorner > sphereRadius) {
            return false;
        }
        for (int x = center.method_10263() - sphereRadius; x <= center.method_10263() + sphereRadius; ++x) {
            for (int y = center.method_10264() - sphereRadius; y <= center.method_10264() + sphereRadius; ++y) {
                for (int z = center.method_10260() - sphereRadius; z <= center.method_10260() + sphereRadius; ++z) {
                    class_2338 currentPos = new class_2338(x, y, z);
                    int distance = AreaUtil.distanceManhattan(center, currentPos);
                    if (distance > sphereRadius || this.contains(currentPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int maxDistanceToCorners(class_2338 center) {
        List<class_2338> corners = this.getVertices();
        int maxDistance = Integer.MIN_VALUE;
        for (class_2338 corner : corners) {
            int distance = AreaUtil.distanceManhattan(center, corner);
            if (distance <= maxDistance) continue;
            maxDistance = distance;
        }
        return maxDistance;
    }

    public List<class_2338> getVertices() {
        class_2338 p1 = new class_2338(this.area.method_35415(), this.area.method_35416(), this.area.method_35417());
        class_2338 p2 = new class_2338(this.area.method_35418(), this.area.method_35416(), this.area.method_35417());
        class_2338 p3 = new class_2338(this.area.method_35415(), this.area.method_35416(), this.area.method_35420());
        class_2338 p4 = new class_2338(this.area.method_35418(), this.area.method_35416(), this.area.method_35420());
        class_2338 p5 = new class_2338(this.area.method_35415(), this.area.method_35419(), this.area.method_35417());
        class_2338 p6 = new class_2338(this.area.method_35418(), this.area.method_35419(), this.area.method_35417());
        class_2338 p7 = new class_2338(this.area.method_35415(), this.area.method_35419(), this.area.method_35420());
        class_2338 p8 = new class_2338(this.area.method_35418(), this.area.method_35419(), this.area.method_35420());
        return Arrays.asList(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    public Set<class_2338> getHull() {
        List<class_2338> vertices = this.getVertices();
        List<class_2338> face1 = CuboidArea.getBlocksInFace(vertices.get(0), vertices.get(1), vertices.get(2), vertices.get(3));
        List<class_2338> face2 = CuboidArea.getBlocksInFace(vertices.get(4), vertices.get(5), vertices.get(6), vertices.get(7));
        List<class_2338> face3 = CuboidArea.getBlocksInFace(vertices.get(0), vertices.get(2), vertices.get(4), vertices.get(6));
        List<class_2338> face4 = CuboidArea.getBlocksInFace(vertices.get(1), vertices.get(3), vertices.get(5), vertices.get(7));
        List<class_2338> face5 = CuboidArea.getBlocksInFace(vertices.get(0), vertices.get(1), vertices.get(4), vertices.get(5));
        List<class_2338> face6 = CuboidArea.getBlocksInFace(vertices.get(2), vertices.get(3), vertices.get(6), vertices.get(7));
        return Stream.of(face1, face2, face3, face4, face5, face6).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean intersects(CuboidArea other) {
        return this.area.method_14657(other.area);
    }

    public boolean intersects(SphereArea other) {
        return other.intersects(this);
    }

    public class_3341 getArea() {
        return this.area;
    }

    public int getXsize() {
        return Math.max(this.area.method_35414(), 1);
    }

    public int getZsize() {
        return Math.max(this.area.method_14663(), 1);
    }

    public int getYsize() {
        return Math.max(this.area.method_14660(), 1);
    }

    public class_2338 getAreaP1() {
        return this.p1;
    }

    public class_2338 getAreaP2() {
        return this.p2;
    }

    public String toString() {
        return this.getAreaType().areaType + " " + AreaUtil.blockPosStr(this.p1) + " <-> " + AreaUtil.blockPosStr(this.p2) + "\nSize: X=" + this.getXsize() + ", Y=" + this.getYsize() + ", Z=" + this.getZsize() + "\nBlocks: " + AreaUtil.blockPosStr(this.p1) + ", " + AreaUtil.blockPosStr(this.p2);
    }

    @Override
    public Set<class_2338> markedBlocks() {
        HashSet<class_2338> set = new HashSet<class_2338>();
        set.add(this.p1);
        set.add(this.p2);
        return set;
    }

    @Override
    public Set<class_2338> getFrame() {
        List<class_2338> vertices = this.getVertices();
        Set<class_2338> p12 = AreaUtil.blocksBetweenOnAxis(vertices.get(0), vertices.get(1), class_2350.class_2351.field_11048);
        Set<class_2338> p34 = AreaUtil.blocksBetweenOnAxis(vertices.get(2), vertices.get(3), class_2350.class_2351.field_11048);
        Set<class_2338> p56 = AreaUtil.blocksBetweenOnAxis(vertices.get(4), vertices.get(5), class_2350.class_2351.field_11048);
        Set<class_2338> p78 = AreaUtil.blocksBetweenOnAxis(vertices.get(6), vertices.get(7), class_2350.class_2351.field_11048);
        Set<class_2338> p15 = AreaUtil.blocksBetweenOnAxis(vertices.get(0), vertices.get(4), class_2350.class_2351.field_11052);
        Set<class_2338> p26 = AreaUtil.blocksBetweenOnAxis(vertices.get(1), vertices.get(5), class_2350.class_2351.field_11052);
        Set<class_2338> p37 = AreaUtil.blocksBetweenOnAxis(vertices.get(2), vertices.get(6), class_2350.class_2351.field_11052);
        Set<class_2338> p48 = AreaUtil.blocksBetweenOnAxis(vertices.get(3), vertices.get(7), class_2350.class_2351.field_11052);
        Set<class_2338> p13 = AreaUtil.blocksBetweenOnAxis(vertices.get(0), vertices.get(2), class_2350.class_2351.field_11051);
        Set<class_2338> p24 = AreaUtil.blocksBetweenOnAxis(vertices.get(1), vertices.get(3), class_2350.class_2351.field_11051);
        Set<class_2338> p57 = AreaUtil.blocksBetweenOnAxis(vertices.get(4), vertices.get(6), class_2350.class_2351.field_11051);
        Set<class_2338> p68 = AreaUtil.blocksBetweenOnAxis(vertices.get(5), vertices.get(7), class_2350.class_2351.field_11051);
        return Stream.of(p12, p34, p56, p78, p15, p26, p37, p48, p13, p24, p57, p68).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<class_2338> getMinimalOutline() {
        HashSet<class_2338> corners = new HashSet<class_2338>();
        int minX = this.area.method_35415();
        int minY = this.area.method_35416();
        int minZ = this.area.method_35417();
        int maxX = this.area.method_35418();
        int maxY = this.area.method_35419();
        int maxZ = this.area.method_35420();
        corners.add(new class_2338(minX, minY, minZ));
        corners.add(new class_2338(minX, minY, maxZ));
        corners.add(new class_2338(minX, maxY, minZ));
        corners.add(new class_2338(minX, maxY, maxZ));
        corners.add(new class_2338(maxX, minY, minZ));
        corners.add(new class_2338(maxX, minY, maxZ));
        corners.add(new class_2338(maxX, maxY, minZ));
        corners.add(new class_2338(maxX, maxY, maxZ));
        HashSet<class_2338> result = new HashSet<class_2338>();
        for (class_2338 corner : corners) {
            result.add(corner);
            if (minX != maxX) {
                int dx = corner.method_10263() == minX ? 1 : -1;
                result.add(corner.method_10069(dx, 0, 0));
            }
            if (minY != maxY) {
                int dy = corner.method_10264() == minY ? 1 : -1;
                result.add(corner.method_10069(0, dy, 0));
            }
            if (minZ == maxZ) continue;
            int dz = corner.method_10260() == minZ ? 1 : -1;
            result.add(corner.method_10069(0, 0, dz));
        }
        return result;
    }

    @Override
    public boolean containsOther(IMarkableArea inner) {
        switch (inner.getAreaType()) {
            case CUBOID: {
                return this.contains((CuboidArea)inner);
            }
            case SPHERE: {
                return this.contains((SphereArea)inner);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        switch (other.getAreaType()) {
            case CUBOID: {
                return this.intersects((CuboidArea)other);
            }
            case SPHERE: {
                return this.intersects((SphereArea)other);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }
}

