/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.CenteredArea;
import de.z0rdak.yawp.core.area.CuboidArea;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import de.z0rdak.yawp.core.area.MarkedAreaTypes;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_3341;
import org.apache.commons.lang3.NotImplementedException;

public class SphereArea
extends CenteredArea {
    public static MapCodec<SphereArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2338.field_25064.fieldOf("center").forGetter(CenteredArea::getCenterPos), (App)Codec.INT.fieldOf("radius").forGetter(SphereArea::getRadius), (App)Codec.STRING.fieldOf("areaType").forGetter(r -> MarkedAreaTypes.areaIdentifier(r.getAreaType()).toString()), (App)BlockDisplayProperties.CODEC.fieldOf("display").orElse((Object)BlockDisplayProperties.createRndDefault()).forGetter(MarkedArea::getDisplay)).apply((Applicative)instance, (center, radius, area, display) -> {
        SphereArea sphere = new SphereArea((class_2338)center, (int)radius);
        sphere.updateDisplay((BlockDisplayProperties)display);
        return sphere;
    }));
    private final int radius;

    public SphereArea(class_2338 centerPos, class_2338 scopePos) {
        super(centerPos, AreaType.SPHERE);
        this.radius = (int)(AreaUtil.distance(centerPos, scopePos) + 0.5);
    }

    public SphereArea(class_2338 middlePos, int radius) {
        this(middlePos, new class_2338((class_2382)middlePos).method_10069(0, radius, 0));
    }

    public static SphereArea expand(SphereArea area, int expansion) {
        SphereArea expanded = new SphereArea(area.center, Math.max(area.radius + expansion, 0));
        expanded.updateDisplay(area.getDisplay());
        return expanded;
    }

    public int getRadius() {
        return this.radius;
    }

    @Override
    public boolean contains(class_2338 pos) {
        return AreaUtil.distance(this.center, pos) < (double)this.radius + 0.5;
    }

    public boolean isHullBlock(class_2338 pos) {
        double d = AreaUtil.distance(this.center, pos);
        return d > (double)this.radius - 0.5 && d < (double)this.radius + 0.5;
    }

    @Override
    public Set<class_2338> getHull() {
        class_2338 p1 = this.center.method_10069(-this.radius, -this.radius, -this.radius);
        class_2338 p2 = new class_2338((class_2382)this.center).method_10069(this.radius, this.radius, this.radius);
        class_3341 cube = class_3341.method_34390((class_2382)p1, (class_2382)p2);
        Set<class_2338> cubeBlocks = AreaUtil.blocksIn(cube);
        return cubeBlocks.stream().filter(this::isHullBlock).collect(Collectors.toSet());
    }

    @Override
    public Set<class_2338> getFrame() {
        Set<class_2338> frameBlocks = this.getMinimalOutline();
        int halfRadius = this.radius / 2;
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, halfRadius, class_2350.class_2351.field_11048, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, -halfRadius, class_2350.class_2351.field_11048, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, halfRadius, class_2350.class_2351.field_11052, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, -halfRadius, class_2350.class_2351.field_11052, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, halfRadius, class_2350.class_2351.field_11051, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, -halfRadius, class_2350.class_2351.field_11051, this::isHullBlock));
        return frameBlocks;
    }

    @Override
    public Set<class_2338> getMinimalOutline() {
        HashSet<class_2338> frameBlocks = new HashSet<class_2338>();
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, 0, class_2350.class_2351.field_11048, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, 0, class_2350.class_2351.field_11052, this::isHullBlock));
        frameBlocks.addAll(AreaUtil.getSliceBlocks(this.center, this.radius, 0, class_2350.class_2351.field_11051, this::isHullBlock));
        return frameBlocks;
    }

    public boolean contains(CuboidArea inner) {
        double maxDistance = Double.NEGATIVE_INFINITY;
        for (class_2338 vertex : inner.getVertices()) {
            double distance = AreaUtil.distanceManhattan(this.center, vertex);
            if (!(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        return maxDistance <= (double)this.getRadius();
    }

    public boolean contains(SphereArea inner) {
        return AreaUtil.distanceManhattan(this.center, inner.center) + inner.radius <= this.radius;
    }

    public boolean intersects(CuboidArea other) {
        int closestZ;
        int closestY;
        if (other.contains(this.center)) {
            return true;
        }
        int closestX = Math.max(other.getArea().method_35415(), Math.min(this.center.method_10263(), other.getArea().method_35418()));
        return AreaUtil.distanceManhattan(this.center, new class_2338(closestX, closestY = Math.max(other.getArea().method_35416(), Math.min(this.center.method_10264(), other.getArea().method_35419())), closestZ = Math.max(other.getArea().method_35417(), Math.min(this.center.method_10260(), other.getArea().method_35420())))) <= this.radius;
    }

    public boolean intersects(SphereArea other) {
        return AreaUtil.distanceManhattan(this.center, other.center) <= this.radius + other.radius;
    }

    @Override
    public boolean containsOther(IMarkableArea inner) {
        switch (inner.getAreaType()) {
            case CUBOID: {
                return this.contains((CuboidArea)inner);
            }
            case SPHERE: {
                return this.contains((SphereArea)inner);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        switch (other.getAreaType()) {
            case CUBOID: {
                return this.intersects((CuboidArea)other);
            }
            case SPHERE: {
                return this.intersects((SphereArea)other);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }

    @Override
    public MarkedAreaType<?> getType() {
        return MarkedAreaTypes.SPHERE_AREA;
    }

    public String toString() {
        return "Sphere " + AreaUtil.blockPosStr(this.center) + ", r=" + this.radius;
    }
}

