/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.MinecraftClientException;
import com.mojang.authlib.exceptions.MinecraftClientHttpException;
import com.mojang.authlib.minecraft.client.ObjectMapper;
import com.mojang.authlib.yggdrasil.response.ErrorResponse;
import com.mojang.brigadier.context.CommandContext;
import de.z0rdak.yawp.constants.Constants;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_3312;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public class MojangApiHelper {
    private static final ObjectMapper OBJECT_MAPPER = ObjectMapper.create();

    private MojangApiHelper() {
    }

    public static void getGameProfileInfo(UUID uuid, Consumer<@Nullable GameProfile> onResult) {
        try {
            String uuidWithOutDashes = uuid.toString().replace("-", "");
            String uri = "https://api.minecraftservices.com/minecraft/profile/lookup/" + uuidWithOutDashes;
            onResult.accept(MojangApiHelper.fetchGameProfileInfo(uri));
        }
        catch (Exception e) {
            onResult.accept(null);
            Constants.LOGGER.error("Error fetching game profile info for player '{}': {}", (Object)uuid.toString(), (Object)e);
        }
    }

    public static void getGameProfileInfo(String username, Consumer<@Nullable GameProfile> onResult) {
        try {
            String uri = "https://api.mojang.com/users/profiles/minecraft/" + username;
            onResult.accept(MojangApiHelper.fetchGameProfileInfo(uri));
        }
        catch (Exception e) {
            onResult.accept(null);
            Constants.LOGGER.error("Error fetching game profile info for player '{}': {}", (Object)username, (Object)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static GameProfile fetchGameProfileInfo(String uri) {
        try {
            int status;
            InputStream inputStream;
            HttpURLConnection connection;
            block10: {
                String result;
                block11: {
                    connection = MojangApiHelper.createUrlConnection(new URI(uri).toURL());
                    inputStream = null;
                    status = connection.getResponseCode();
                    if (status >= 400) break block10;
                    inputStream = connection.getInputStream();
                    result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (!result.isEmpty()) break block11;
                    GameProfile gameProfile = null;
                    IOUtils.closeQuietly((InputStream)inputStream);
                    return gameProfile;
                }
                GameProfile gameProfile = (GameProfile)OBJECT_MAPPER.readValue(result, GameProfile.class);
                IOUtils.closeQuietly((InputStream)inputStream);
                return gameProfile;
            }
            try {
                try {
                    String contentType = connection.getContentType();
                    inputStream = connection.getErrorStream();
                    if (inputStream == null) {
                        throw new MinecraftClientHttpException(status);
                    }
                    String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                    if (contentType != null && contentType.startsWith("text/html")) {
                        Constants.LOGGER.error("Got an error with a html body connecting to {}: {}", (Object)uri, (Object)result);
                        throw new MinecraftClientHttpException(status);
                    }
                    ErrorResponse errorResponse = (ErrorResponse)OBJECT_MAPPER.readValue(result, ErrorResponse.class);
                    throw new MinecraftClientHttpException(status, errorResponse);
                }
                catch (IOException e) {
                    throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed to read from " + uri + " due to " + e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            Constants.LOGGER.error("Could not create URL of {}", (Object)uri);
            return null;
        }
    }

    public static Optional<GameProfile> lookupGameProfileInCache(CommandContext<class_2168> ctx, String playerName) {
        class_3312 profileCache = ((class_2168)ctx.getSource()).method_9211().method_3793();
        return profileCache.method_14515(playerName);
    }

    public static Optional<GameProfile> lookupGameProfileInCache(CommandContext<class_2168> ctx, UUID uuid) {
        class_3312 profileCache = ((class_2168)ctx.getSource()).method_9211().method_3793();
        return profileCache.method_14512(uuid);
    }

    private static HttpURLConnection createUrlConnection(URL url) {
        try {
            Constants.LOGGER.debug("Connecting to {}", (Object)url);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setConnectTimeout(5000);
            connection.setReadTimeout(5000);
            connection.setUseCaches(false);
            return connection;
        }
        catch (IOException io) {
            throw new MinecraftClientException(MinecraftClientException.ErrorType.SERVICE_UNAVAILABLE, "Failed connecting to " + String.valueOf(url), (Throwable)io);
        }
    }
}

