/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util;

import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.stick.MarkerStick;
import de.z0rdak.yawp.util.LocalRegions;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_9279;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class StickUtil {
    private static final String MARKED_BLOCK_INDICATOR = "X";
    private static final String UNMARKED_BLOCK_INDICATOR = "#";
    private static final String TP_POS_INDICATOR = "TP";
    private static final class_124 MARKED_BLOCK_COLOR = class_124.field_1060;
    private static final class_124 UNMARKED_BLOCK_COLOR = class_124.field_1061;
    private static final class_124 UNMARKED_POS_COLOR = class_124.field_1075;

    private StickUtil() {
    }

    public static void initStickTag(class_1799 stick, class_5321<class_1937> dim, boolean reset) {
        class_2487 customDataTag;
        class_9279 customData = (class_9279)stick.method_58694(class_9334.field_49628);
        if (customData == null) {
            stick.method_57379(class_9334.field_49628, (Object)class_9279.field_49302);
        }
        if ((customData = (class_9279)stick.method_58694(class_9334.field_49628)) != null && (!(customDataTag = customData.method_57461()).method_10545("stick") || reset)) {
            class_2487 compoundNBT = new MarkerStick(dim).serializeNBT();
            customDataTag.method_10566("stick", (class_2520)compoundNBT);
            stick.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customDataTag));
        }
    }

    public static void initMarkerNbt(class_1799 stack, class_5321<class_1937> dim) {
        stack.method_7939(1);
        StickUtil.initStickTag(stack, dim, false);
        StickUtil.updateStickMetadata(stack);
    }

    public static void resetMarkerNbt(class_1799 stack, class_5321<class_1937> dim) {
        StickUtil.initStickTag(stack, dim, true);
        StickUtil.updateStickMetadata(stack);
    }

    private static void updateStickMetadata(class_1799 stack) {
        StickUtil.updateStickName(stack);
        stack.method_57379(class_9334.field_49632, (Object)StickUtil.buildToolTip());
        stack.method_57379(class_9334.field_49641, (Object)true);
    }

    public static boolean isMarker(class_1799 stack) {
        if (StickUtil.hasCustomDataTag(stack)) {
            class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
            class_2487 compoundTag = customData.method_57461();
            return compoundTag.method_10545("stick") && customData.method_57461().method_10580("stick") != null;
        }
        return false;
    }

    @Nullable
    public static class_2487 getStickNBT(class_1799 stick) {
        if (((class_9279)stick.method_58694(class_9334.field_49628)).method_57461().method_10545("stick")) {
            return (class_2487)((class_9279)stick.method_58694(class_9334.field_49628)).method_57461().method_10580("stick");
        }
        return null;
    }

    @Nullable
    public static IMarkableArea getMarkedArea(class_1799 stick) {
        class_2487 stickNBT;
        if (StickUtil.isMarker(stick) && (stickNBT = StickUtil.getStickNBT(stick)) != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            if (!marker.isValidArea()) {
                return null;
            }
            return LocalRegions.areaFrom(marker);
        }
        return null;
    }

    public static void updateStickName(class_1799 stick) {
        class_2487 stickNBT = StickUtil.getStickNBT(stick);
        if (stickNBT != null) {
            MarkerStick marker = new MarkerStick(stickNBT);
            class_5250 markerIndicators = StickUtil.buildRegionMarkerIndicators(marker);
            class_5250 markerHoverName = StickUtil.buildStickName(marker).method_27693(" ").method_10852((class_2561)markerIndicators);
            stick.method_57379(class_9334.field_49631, (Object)markerHoverName);
        }
    }

    private static class_5250 buildStickName(MarkerStick marker) {
        class_5250 stickName = class_2561.method_43470((String)marker.getStickType().stickName).method_27692(class_124.field_1065);
        class_5250 areaType = class_2561.method_43470((String)" (").method_27693(marker.getAreaType().areaType).method_27693(")");
        return stickName.method_10852((class_2561)areaType);
    }

    private static class_5250 buildMarkerIndicator(boolean isMarked) {
        String indicator = isMarked ? MARKED_BLOCK_INDICATOR : UNMARKED_BLOCK_INDICATOR;
        class_124 color = isMarked ? MARKED_BLOCK_COLOR : UNMARKED_BLOCK_COLOR;
        class_5250 indicatorComp = class_2561.method_43470((String)indicator).method_27692(color);
        class_5250 closedResetComp = class_2561.method_43470((String)"]").method_27692(class_124.field_1070);
        return class_2561.method_43470((String)"[").method_10852((class_2561)indicatorComp).method_10852((class_2561)closedResetComp);
    }

    private static class_5250 buildRegionMarkerIndicators(MarkerStick marker) {
        int i;
        class_5250 regionMarkerIndicators = class_2561.method_43470((String)"");
        int maxBlocks = marker.getAreaType().maxBlocks;
        int amountUnmarked = maxBlocks - marker.getMarkedBlocks().size();
        for (i = 0; i < marker.getMarkedBlocks().size(); ++i) {
            regionMarkerIndicators.method_10852((class_2561)StickUtil.buildMarkerIndicator(true));
        }
        for (i = 0; i < amountUnmarked; ++i) {
            regionMarkerIndicators.method_10852((class_2561)StickUtil.buildMarkerIndicator(false));
        }
        return regionMarkerIndicators;
    }

    public static boolean hasCustomDataTag(class_1799 itemStack) {
        return itemStack.method_58694(class_9334.field_49628) != null;
    }

    public static void setMarkerNbt(class_1799 itemStack, class_2487 markerTag) {
        if (StickUtil.hasCustomDataTag(itemStack)) {
            class_2487 compoundTag = ((class_9279)itemStack.method_58694(class_9334.field_49628)).method_57461();
            compoundTag.method_10566("stick", (class_2520)markerTag);
            itemStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)compoundTag));
        }
    }

    private static class_9290 buildToolTip() {
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_48321((String)"help.tooltip.stick.marker.simple.1", (String)"Used to mark a new region."));
        lore.add(class_2561.method_48321((String)"help.tooltip.stick.marker.simple.2", (String)"Keep the Region Marker in your hand while creating a region!"));
        lore.add(class_2561.method_43470((String)String.valueOf(class_124.field_1056)).method_10852((class_2561)class_2561.method_48321((String)"help.tooltip.stick.marker.simple.3", (String)"Mark a (Cuboid) region by right-clicking the diagonal opposite corner blocks.")));
        lore.add(class_2561.method_43470((String)String.valueOf(class_124.field_1056)).method_10852((class_2561)class_2561.method_48321((String)"help.tooltip.stick.marker.simple.4", (String)"Set a region teleport position by shift-right-clicking a block.")));
        return new class_9290(lore);
    }
}

