/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp;

import com.mojang.brigadier.CommandDispatcher;
import de.z0rdak.yawp.YAWPCommon;
import de.z0rdak.yawp.YAWPModInitializer;
import de.z0rdak.yawp.api.events.flag.NeoForgeFlagEvent;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.CommandRegistry;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.data.PlayerManager;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.handler.YawpEventHandler;
import de.z0rdak.yawp.platform.NeoForgeConfigHelper;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;

@Mod(value="yawp")
public class YetAnotherWorldProtector
implements YAWPModInitializer {
    private static IEventBus yawpEventBus;

    public YetAnotherWorldProtector(IEventBus modEventBus) {
        yawpEventBus = modEventBus;
        YAWPCommon.init();
        this.registerConfig();
        this.setupRegionDataLifecycleHooks();
        this.registerCommands();
        NeoForge.EVENT_BUS.register(YetAnotherWorldProtector.class);
    }

    @Override
    public void registerConfig() {
        ((NeoForgeConfigHelper)Services.CONFIG_REGISTRY).setEventBus(yawpEventBus);
        Services.CONFIG_REGISTRY.register();
    }

    @SubscribeEvent
    public static void onAddFlag(NeoForgeFlagEvent.AddFlagEvent event) {
        if (event.getFlag().getName().contains("spawning") && Services.FLAG_CONFIG.removeEntitiesEnabled()) {
            YawpEventHandler.removeInvolvedEntities(event.getSrc(), event.getRegion(), RegionFlag.fromId(event.getFlag().getName()));
        }
    }

    @Override
    public void registerCommands() {
        NeoForge.EVENT_BUS.addListener(this::registerCommandsForge);
    }

    @Override
    public void setupRegionDataLifecycleHooks() {
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, startEvent -> RegionDataManager.onServerStarting(startEvent.getServer()));
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, startEvent -> PlayerManager.onServerStart(startEvent.getServer()));
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, startEvent -> VisualizationManager.initServerInstance(startEvent.getServer()));
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, event -> {
            LevelAccessor patt0$temp = event.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                RegionDataManager.worldLoad(serverLevel.getServer(), serverLevel);
            }
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, event -> {
            Level patt0$temp = event.getEntity().getCommandSenderWorld();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                RegionDataManager.initLevelDataOnLogin((Entity)event.getEntity(), (Level)serverLevel);
            }
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, saveEvent -> {
            LevelAccessor patt0$temp = saveEvent.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                RegionDataManager.save(serverLevel.getServer(), false, false);
            }
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, event -> {
            Entity patt0$temp = event.getEntity();
            if (patt0$temp instanceof Player) {
                Player player = (Player)patt0$temp;
                if (event.getEntity().getServer() != null) {
                    ServerLevel targetLevel = event.getEntity().getServer().getLevel(event.getDimension());
                    RegionDataManager.initLevelDataOnChangeWorld(player, player.level(), (Level)targetLevel);
                }
            }
        });
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, stoppingEvent -> RegionDataManager.saveOnStop(stoppingEvent.getServer()));
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, unloadEvent -> {
            LevelAccessor patt0$temp = unloadEvent.getLevel();
            if (patt0$temp instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)patt0$temp;
                RegionDataManager.saveOnUnload(serverLevel.getServer(), serverLevel);
            }
        });
    }

    private void registerCommandsForge(RegisterCommandsEvent event) {
        CommandRegistry.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext(), event.getCommandSelection());
    }
}

