/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.api.events.region.FlagCheckResult;
import de.z0rdak.yawp.core.flag.FlagTag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class FlagMessage {
    public static final String FLAG_TEMPLATE = "{flag}";
    public static final String POS_TEMPLATE = "{pos}";
    public static final String REGION_TEMPLATE = "{region}";
    public static final String DIM_TEMPLATE = "{dim}";
    public static final String PLAYER_TEMPLATE = "{player}";
    public static final String TEAM_TEMPLATE = "{team}";
    public static final String GROUP_TEMPLATE = "{group}";
    public static final String ENTITY_TEMPLATE = "{entity}";
    public static final String BLOCK_ENTITY = "{block}";
    public static final String CONFIG_MSG = "config";
    public static final Set<String> MSG_TOKEN;
    public static FlagMessage DEFAULT_FLAG_MSG;
    private static final Map<String, Integer> TOKEN_INDEX;
    public static Codec<FlagMessage> CODEC;
    private String msg;
    private boolean muted;
    private boolean isDefault;

    public FlagMessage(String msg) {
        this.msg = msg;
        this.isDefault = msg.toLowerCase(Locale.ROOT).equals(CONFIG_MSG);
    }

    public FlagMessage(String msg, boolean muted) {
        this(msg);
        this.muted = muted;
    }

    public FlagMessage(String msg, boolean muted, boolean isDefault) {
        this(msg, muted);
        this.isDefault = isDefault;
    }

    public static Map<String, String> defaultSubstitutes(RegionFlag flag, IProtectedRegion region, BlockPos pos, @Nullable Player player) {
        HashMap<String, String> substituteMap = new HashMap<String, String>();
        substituteMap.put(FLAG_TEMPLATE, flag.name);
        substituteMap.put(POS_TEMPLATE, ChatComponentBuilder.shortBlockPosBracketed(pos));
        substituteMap.put(REGION_TEMPLATE, region.getName());
        substituteMap.put(DIM_TEMPLATE, region.getDim().location().toString());
        if (player != null && flag.categories.contains((Object)FlagTag.PLAYER)) {
            substituteMap.put(PLAYER_TEMPLATE, player.getScoreboardName());
        }
        return substituteMap;
    }

    public static Map<String, String> defaultSubstitutesFor(FlagCheckResult result) {
        HashMap<String, String> substituteMap = new HashMap<String, String>();
        substituteMap.put(FLAG_TEMPLATE, result.getFlagCheck().getRegionFlag().name);
        substituteMap.put(POS_TEMPLATE, ChatComponentBuilder.tinyBlockPos(result.getFlagCheck().getTarget()));
        substituteMap.put(REGION_TEMPLATE, result.getResponsible().getName());
        substituteMap.put(DIM_TEMPLATE, result.getResponsible().getDim().location().toString());
        if (result.getFlagCheck().getPlayer() != null && RegionFlag.hasPlayerCategory(result.getFlagCheck().getRegionFlag())) {
            substituteMap.put(PLAYER_TEMPLATE, result.getFlagCheck().getPlayer().getScoreboardName());
        }
        return substituteMap;
    }

    public static MutableComponent buildFrom(FlagCheckResult result, Map<String, String> substitutes) {
        String key = "flag.msg.deny." + result.getFlag().getName();
        Object[] args = new Object[9];
        for (Map.Entry<String, Integer> entry : TOKEN_INDEX.entrySet()) {
            String token = entry.getKey();
            int idx = entry.getValue() - 1;
            args[idx] = substitutes.getOrDefault(token, "");
        }
        return Component.translatable((String)key, (Object[])args);
    }

    private static String getI18nFlagMsgTemplate(FlagCheckResult result) {
        String flagMsgLangKey = "flag.msg.deny." + result.getFlag().getName();
        String fallBackLangKey = "flag.msg.deny." + result.getResponsible().getRegionType().type + ".default";
        return Component.translatableWithFallback((String)flagMsgLangKey, (String)fallBackLangKey).getString();
    }

    private static String replaceMatches(String flagMsgTemplate, Map<String, String> substitutes) {
        String flagMsg = flagMsgTemplate;
        for (Map.Entry<String, String> entry : substitutes.entrySet()) {
            flagMsg = flagMsg.replace(entry.getKey(), entry.getValue());
        }
        return flagMsg;
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void mute(boolean mute) {
        this.muted = mute;
    }

    public void reset() {
        this.isDefault = true;
        this.msg = CONFIG_MSG;
    }

    public boolean isDefault() {
        return this.msg.equals(CONFIG_MSG);
    }

    public String msg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public String toString() {
        return this.msg;
    }

    static {
        DEFAULT_FLAG_MSG = new FlagMessage(CONFIG_MSG);
        MSG_TOKEN = new HashSet<String>();
        MSG_TOKEN.add(FLAG_TEMPLATE);
        MSG_TOKEN.add(REGION_TEMPLATE);
        MSG_TOKEN.add(DIM_TEMPLATE);
        MSG_TOKEN.add(POS_TEMPLATE);
        MSG_TOKEN.add(PLAYER_TEMPLATE);
        MSG_TOKEN.add(TEAM_TEMPLATE);
        MSG_TOKEN.add(GROUP_TEMPLATE);
        MSG_TOKEN.add(ENTITY_TEMPLATE);
        MSG_TOKEN.add(BLOCK_ENTITY);
        TOKEN_INDEX = Map.of(FLAG_TEMPLATE, 1, REGION_TEMPLATE, 2, DIM_TEMPLATE, 3, POS_TEMPLATE, 4, PLAYER_TEMPLATE, 5, TEAM_TEMPLATE, 6, GROUP_TEMPLATE, 7, ENTITY_TEMPLATE, 8, BLOCK_ENTITY, 9);
        CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("msg").orElse((Object)CONFIG_MSG).forGetter(FlagMessage::msg), (App)Codec.BOOL.fieldOf("muted").orElse((Object)false).forGetter(FlagMessage::isMuted), (App)Codec.BOOL.fieldOf("default").orElse((Object)true).forGetter(FlagMessage::isDefault)).apply((Applicative)instance, FlagMessage::new));
    }
}

