/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.LavaFluid;
import net.minecraft.world.level.material.WaterFluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FlowingFluid.class})
public class FlowingFluidMixin {
    @Inject(method={"spreadTo"}, at={@At(value="HEAD")}, cancellable=true)
    protected void canSpreadTo(LevelAccessor levelAccessor, BlockPos pos, BlockState blockState, Direction direction, FluidState fluidState, CallbackInfo ci) {
        FlagCheckEvent specificFluidCheckEvent;
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        if (!Services.FLAG_CONFIG.isDisabledByConfig(RegionFlag.FLUID_FLOW.name)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(pos, RegionFlag.FLUID_FLOW, (ResourceKey<Level>)level.dimension());
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> ci.cancel());
            if (ci.isCancelled()) {
                return;
            }
        }
        if (!Services.FLAG_CONFIG.isDisabledByConfig(RegionFlag.WATER_FLOW.name) && fluidState.getType() instanceof WaterFluid) {
            specificFluidCheckEvent = new FlagCheckEvent(pos, RegionFlag.WATER_FLOW, (ResourceKey<Level>)level.dimension());
            if (Services.EVENT.post(specificFluidCheckEvent)) {
                return;
            }
            FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> ci.cancel());
        }
        if (!Services.FLAG_CONFIG.isDisabledByConfig(RegionFlag.LAVA_FLOW.name) && fluidState.getType() instanceof LavaFluid) {
            specificFluidCheckEvent = new FlagCheckEvent(pos, RegionFlag.LAVA_FLOW, (ResourceKey<Level>)level.dimension());
            if (Services.EVENT.post(specificFluidCheckEvent)) {
                return;
            }
            FlagEvaluator.processCheck(specificFluidCheckEvent, deny -> ci.cancel());
        }
    }
}

