/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.pagination;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.TeleportAnchor;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.pagination.BasePaginationMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TeleportAnchorPagination
extends BasePaginationMessage<TeleportAnchor> {
    private final IMarkableRegion region;

    public TeleportAnchorPagination(IMarkableRegion region, int pageNumber, int pageSize) throws InvalidPageNumberException {
        super(region.getTpAnchors().getAnchors(), Commands.buildListRegionFlagsCommand(region), pageNumber, pageSize);
        this.region = region;
    }

    public static MutableComponent buildTeleportAnchorInfoHeader(IProtectedRegion region, MutableComponent flagListLink) {
        return ChatComponentBuilder.buildHeader(Component.translatableWithFallback((String)"cli.msg.info.header.in", (String)"== %s in %s ==", (Object[])new Object[]{flagListLink, ChatLinkBuilder.buildRegionInfoLink(region)}));
    }

    public static List<Component> buildTeleportAnchorEntries(IMarkableRegion region, List<TeleportAnchor> tpAnchors) {
        List<TeleportAnchor> alphabeticAnchors = tpAnchors.stream().sorted(Comparator.comparing(TeleportAnchor::getName)).toList();
        return alphabeticAnchors.stream().map(tpAnchor -> TeleportAnchorPagination.buildRemoveTeleportAnchorEntry(region, tpAnchor)).collect(Collectors.toList());
    }

    public static Component buildRemoveTeleportAnchorEntry(IMarkableRegion region, TeleportAnchor tpAnchor) {
        Component teleportAnchorRemoveLink = TeleportAnchorPagination.buildRemoveTeleportAnchorLink(region, tpAnchor);
        MutableComponent anchorNameText = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.text", (String)"%s", (Object[])new Object[]{tpAnchor.getName()});
        MutableComponent anchorNameHover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.hover", (String)"Anchor '%s' @ %s", (Object[])new Object[]{tpAnchor.getName(), ChatComponentBuilder.shortBlockPosBracketed(tpAnchor.getPos())});
        MutableComponent anchorName = ChatComponentBuilder.buildTextWithHoverMsg(anchorNameText, anchorNameHover, ChatFormatting.GREEN);
        Component tpLink = TeleportAnchorPagination.buildTeleportToAnchorLink(region, tpAnchor);
        Component showLink = TeleportAnchorPagination.buildShowTeleportAnchorLink(region, tpAnchor);
        Component hideLink = TeleportAnchorPagination.buildHideTeleportAnchorLink(region, tpAnchor);
        Component renameLink = TeleportAnchorPagination.buildRenameTeleportAnchorLink(region, tpAnchor);
        Component updateLink = TeleportAnchorPagination.buildUpdateTeleportAnchorLink(region, tpAnchor);
        return Messages.substitutable(" - %s %s @ %s | %s %s %s %s", teleportAnchorRemoveLink, anchorName, tpLink, showLink, hideLink, updateLink, renameLink);
    }

    public static Component buildShowTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String cmd = Commands.buildShowTpAnchorCommand(region, tpAnchor.getName());
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.show.link.text", (String)"s");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.show.link.hover", (String)"Click to show teleport anchor");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static Component buildHideTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String cmd = Commands.buildHideTpAnchorCommand(region, tpAnchor.getName());
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.hide.link.text", (String)"h");
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.hide.link.hover", (String)"Click to hide teleport anchor");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static Component buildRemoveTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String rmCmd = Commands.buildRemoveTeleportAnchorCommand(region, tpAnchor.getName());
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.remove.link.hover", (String)"Click to remove '%s' from region %s", (Object[])new Object[]{tpAnchor.getName(), region.getName()});
        MutableComponent text = Component.translatableWithFallback((String)"cli.link.remove", (String)"x");
        return ChatComponentBuilder.buildExecuteCmdComponent(text, hover, rmCmd, ClickEvent.Action.RUN_COMMAND, Messages.REMOVE_CMD_COLOR);
    }

    public static Component buildTeleportToAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String cmd = Commands.buildTeleportTpAnchorCommand(region, tpAnchor.getName());
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.tp.link.text", (String)"%s", (Object[])new Object[]{ChatComponentBuilder.commandBlockPosStr(tpAnchor.getPos())});
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.tp.link.hover", (String)"Click to teleport to '%s' @ %s", (Object[])new Object[]{tpAnchor.getName(), ChatComponentBuilder.shortBlockPosBracketed(tpAnchor.getPos())});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, cmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
    }

    public static Component buildRenameTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String renameCmd = Commands.buildSuggestRenameTpAnchorCommand(region, tpAnchor.getName());
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.rename.link.hover", (String)"Click to rename '%s'", (Object[])new Object[]{tpAnchor.getName()});
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.rename.link.text", (String)"r");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, renameCmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    public static Component buildUpdateTeleportAnchorLink(IMarkableRegion region, TeleportAnchor tpAnchor) {
        String renameCmd = Commands.buildSuggestUpdateTpAnchorCommand(region, tpAnchor.getName());
        MutableComponent hover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.update.link.hover", (String)"Click to set new teleport position");
        MutableComponent text = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.update.link.text", (String)"p");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, renameCmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.LINK_COLOR);
    }

    @Override
    public Component noContentMsg() {
        return Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.empty", (String)"No teleport anchors defined in %s", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(this.region)});
    }

    @Override
    public Component header() {
        return TeleportAnchorPagination.buildTeleportAnchorInfoHeader(this.region, TeleportAnchorPagination.buildRegionTeleportAnchorListLink(this.region));
    }

    @Override
    public List<Component> buildEntries() {
        return TeleportAnchorPagination.buildTeleportAnchorEntries(this.region, this.pageContent);
    }

    @Override
    public Component emptyEntry() {
        return Messages.substitutable(" - %s", TeleportAnchorPagination.buildSuggestAddTeleportAnchorLink(this.region, "tpAnchor", BlockPos.ZERO));
    }

    public static MutableComponent buildRegionTeleportAnchorListLink(IMarkableRegion region) {
        MutableComponent numberHover = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.link.hover", (String)"%s teleport anchor(s) defined in %s", (Object[])new Object[]{region.getTpAnchors().getAnchors().size(), region.getName()});
        MutableComponent regionTpAnchorAmountPlain = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", region.getTpAnchors().getAnchors().size()), numberHover, Messages.LINK_COLOR);
        MutableComponent regionTpAnchorAmount = ChatComponentBuilder.buildTextWithHoverMsg(Messages.substitutable("%s", region.getTpAnchors().getAnchors().size()), numberHover, Messages.LINK_COLOR);
        MutableComponent tpAnchorHoverText = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.link.hover", (String)"%s teleport anchor(s) defined in %s", (Object[])new Object[]{region.getTpAnchors().getAnchors().size(), region.getName()});
        String listAnchorCmd = Commands.buildListTeleportAnchorCommand(region);
        MutableComponent tpAnchorListLink = ChatComponentBuilder.buildExecuteCmdComponent(regionTpAnchorAmount, tpAnchorHoverText, listAnchorCmd, ClickEvent.Action.RUN_COMMAND, Messages.LINK_COLOR);
        MutableComponent tpAnchorComp = region.getTpAnchors().getAnchors().isEmpty() ? regionTpAnchorAmountPlain : tpAnchorListLink;
        return Messages.substitutable("%s %s", Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.link.text", (String)"%s teleport anchor(s)", (Object[])new Object[]{tpAnchorComp}), TeleportAnchorPagination.buildSuggestAddTeleportAnchorLink(region, "tpAnchor-name", BlockPos.ZERO));
    }

    public static MutableComponent buildSuggestAddTeleportAnchorLink(IMarkableRegion region, String name, BlockPos pos) {
        MutableComponent hoverText = Component.translatableWithFallback((String)"cli.msg.info.region.tp-anchor.add.link.hover", (String)"Click to create new teleport anchor in %s", (Object[])new Object[]{region.getName()});
        MutableComponent linkText = Component.translatableWithFallback((String)"cli.link.add", (String)"+");
        String cmd = Commands.buildAddTeleportAnchorCommand(region, name, pos);
        return ChatComponentBuilder.buildExecuteCmdComponent(linkText, hoverText, cmd, ClickEvent.Action.SUGGEST_COMMAND, Messages.ADD_CMD_COLOR);
    }
}

