package de.z0rdak.yawp.core.area;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Lifecycle;
import de.z0rdak.yawp.constants.Constants;
import java.util.Locale;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class MarkedAreaTypes {

    public static class_2960 areaIdentifier(AreaType areaType) {
        return new class_2960(Constants.MOD_ID, areaType.toString().toLowerCase(Locale.ROOT));
    }

    public static class_2378<MarkedAreaType<?>> REGISTRY = new class_2370<>(
            class_5321.method_29180(new class_2960(Constants.MOD_ID, "marked_area_types")), Lifecycle.stable());

    public static final MarkedAreaType<CuboidArea> CUBOID_AREA = register("cuboid", new MarkedAreaType<>(CuboidArea.CODEC));
    public static final MarkedAreaType<SphereArea> SPHERE_AREA = register("sphere", new MarkedAreaType<>(SphereArea.CODEC));

    public static Codec<IMarkableArea> MARKED_AREA_CODEC = REGISTRY.method_39673()
            .dispatch("areaType", IMarkableArea::getType, MarkedAreaType::codec);

    public static <T extends MarkedArea> MarkedAreaType<T> register(String id, MarkedAreaType<T> areaType) {
        return class_2378.method_10230(REGISTRY, new class_2960(Constants.MOD_ID, id), areaType);
    }

}
