package de.z0rdak.yawp.core.stick;

import de.z0rdak.yawp.constants.serialization.ItemNbtKeys;
import de.z0rdak.yawp.core.INbtSerializable;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.util.StickType;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class MarkerStick extends AbstractStick implements INbtSerializable<class_2487> {

    private class_5321<class_1937> dimension;
    private AreaType areaType;
    private boolean isValidArea;
    private List<class_2338> markedBlocks;

    public MarkerStick(class_5321<class_1937> dim) {
        super(StickType.MARKER);
        this.areaType = AreaType.CUBOID;
        this.isValidArea = false;
        this.markedBlocks = new ArrayList<>(this.areaType.maxBlocks);
        this.dimension = dim;
    }

    public MarkerStick(class_2487 nbt) {
        super(StickType.MARKER);
        this.deserializeNBT(nbt);
    }

    public void cycleMode() {
        this.areaType = AreaType.values()[(this.areaType.ordinal() + 1) % AreaType.values().length];
        reset();
    }

    public void reset() {
        this.markedBlocks = new ArrayList<>(this.areaType.maxBlocks);
        this.isValidArea = false;
    }

    public class_5321<class_1937> getDimension() {
        return dimension;
    }

    public boolean checkValidArea() {
        int numMarkedBlocks = markedBlocks.size();
        if (markedBlocks.isEmpty() || areaType.neededBlocks == -1) {
            return false;
        }
        // check for cylinder, sphere and cuboid
        boolean exactlyEnoughBlocks = numMarkedBlocks == areaType.neededBlocks && numMarkedBlocks == areaType.maxBlocks;
        // check for polygon and prism
        boolean minBlocks = numMarkedBlocks >= areaType.neededBlocks && numMarkedBlocks <= areaType.maxBlocks;
        this.isValidArea = exactlyEnoughBlocks || minBlocks;
        return this.isValidArea;
    }

    public AreaType getAreaType() {
        return areaType;
    }

    public void setAreaType(AreaType areaType) {
        this.areaType = areaType;
    }

    public boolean isValidArea() {
        return isValidArea;
    }

    public List<class_2338> getMarkedBlocks() {
        return markedBlocks;
    }

    public void addMarkedBlock(class_2338 pos) {
        int index = markedBlocks.size() % areaType.maxBlocks;
        this.markedBlocks.add(index, pos);
        if (markedBlocks.size() > areaType.maxBlocks) {
            markedBlocks.remove(areaType.maxBlocks);
        }
    }

    @Override
    public class_2487 serializeNBT() {
        class_2487 nbt = super.serializeNBT();
        nbt.method_10582(ItemNbtKeys.STICK_ID, UUID.randomUUID().toString());
        nbt.method_10556(ItemNbtKeys.VALID_AREA, this.isValidArea);
        nbt.method_10582(ItemNbtKeys.AREA_TYPE, this.areaType.areaType);
        nbt.method_10582(ItemNbtKeys.DIM, this.dimension.method_29177().toString());
        class_2499 blocks = new class_2499();
        this.markedBlocks.forEach(block -> blocks.add(class_2512.method_10692(block)));
        nbt.method_10566(ItemNbtKeys.MARKED_BLOCKS, blocks);
        return nbt;
    }

    @Override
    public void deserializeNBT(class_2487 nbt) {
        super.deserializeNBT(nbt);
        this.isValidArea = nbt.method_10577(ItemNbtKeys.VALID_AREA);
        this.areaType = AreaType.of(nbt.method_10558(ItemNbtKeys.AREA_TYPE));
        this.dimension = class_5321.method_29179(class_7924.field_41223, new class_2960(nbt.method_10558(ItemNbtKeys.DIM)));
        class_2499 markedBlocksNBT = nbt.method_10554(ItemNbtKeys.MARKED_BLOCKS, class_2520.field_33260);
        this.markedBlocks = new ArrayList<>(this.areaType.maxBlocks);
        markedBlocksNBT.forEach(block -> this.markedBlocks.add(class_2512.method_10691((class_2487) block)));
    }
}
