package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

import static de.z0rdak.yawp.api.commands.Commands.*;
import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.ChatLinkBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.LINK_COLOR;
import static net.minecraft.class_2558.class_2559.field_11750;
import static net.minecraft.class_2558.class_2559.field_11745;

public class VisualizationOptionsMessage implements MultiLineMessage<IMarkableArea> {

    private final IMarkableRegion region;
    private final List<class_2561> infoLines;

    public VisualizationOptionsMessage(IMarkableRegion region) {
        this.region = region;
        this.infoLines = new ArrayList<>();
    }

    /**
     * == Visualization for [region] == <br>
     * Show: [Hull] [Frame] [Minimal] [Marked] | [custom]
     * Hide: [Hull] [Frame] [Minimal] [Marked]
     * Hierarchy: [Show] | [Hide]
     * Intersecting: [Show] | [Hide]
     */
    @Override
    public List<class_2561> getLines() {
        infoLines.clear();
        var header = buildHeader(class_2561.method_48322("cli.msg.info.header.of", "== %s of %s ==", buildRegionVisualizationLink(region), buildRegionInfoLink(region)));
        var showSubject = class_2561.method_48321("cli.msg.info.region.visualization.show", "Show");
        var hideSubject = class_2561.method_48321("cli.msg.info.region.visualization.hide", "Hide");
        var hierarchySubject = class_2561.method_48321("cli.msg.info.region.visualization.hierarchy", "Hierarchy");
        var intersectingSubject = class_2561.method_48321("cli.msg.info.region.visualization.intersecting", "Intersecting");

        var customShowLink = buildShowAdvancedLink(region, DisplayType.FRAME, class_2960.method_43902(class_2960.field_33381, "cyan_stained_glass"), true, 15);
        var displayActions = buildInfoComponent(showSubject, buildShowLinks(region), customShowLink);
        var hideActions = buildInfoComponent(hideSubject, buildHideLinks(region));
        var hierarchy = buildInfoComponent(hierarchySubject, buildHierarchyShowLink(region), buildHierarchyHideLink(region));
        var intersecting = buildInfoComponent(intersectingSubject, buildIntersectingShowLink(region), buildIntersectingHideLink(region));

        infoLines.add(header);
        infoLines.add(displayActions);
        infoLines.add(hideActions);
        infoLines.add(hierarchy);
        infoLines.add(intersecting);
        return infoLines;
    }

    @Override
    public IMarkableArea getContent() {
        return region.getArea();
    }

    public static class_5250 buildShowLinks(IMarkableRegion region) {
        var frameLink = buildShowLink(region, DisplayType.FRAME);
        var hullLink = buildShowLink(region, DisplayType.HULL);
        var minimalLink = buildShowLink(region, DisplayType.MINIMAL);
        var markedLink = buildShowLink(region, DisplayType.MARKED);
        return Messages.substitutable("%s %s %s %s", frameLink, hullLink, minimalLink, markedLink);
    }

    public static class_5250 buildShowAdvancedLink(IMarkableRegion region, DisplayType displayType, class_2960 block, boolean glow, int lightLevel) {
        var cmd = buildAdvancedVisualizationShowCommand(region, displayType, block, glow, lightLevel);
        var text = class_2561.method_48321("cli.msg.info.region.visualization.show.advanced.link.text", "custom");
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.show.advanced.link.hover", "Click to paste custom visualization command for '%s'", displayType.name, region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, cmd, field_11745, LINK_COLOR);
    }

    public static class_5250 buildHideLinks(IMarkableRegion region) {
        var frameLink = buildHideLink(region, DisplayType.FRAME);
        var hullLink = buildHideLink(region, DisplayType.HULL);
        var minimalLink = buildHideLink(region, DisplayType.MINIMAL);
        var markedLink = buildHideLink(region, DisplayType.MARKED);
        return Messages.substitutable("%s %s %s %s", frameLink, hullLink, minimalLink, markedLink);
    }

    public static class_5250 buildShowLink(IMarkableRegion region, DisplayType displayType) {
        var text = class_2561.method_48322("cli.msg.info.region.visualization.show.link.text", "%s", displayType.name);
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.show.link.hover", "Click to show %s-Visualization for '%s'", displayType.name, region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildVisualizationShowCommand(region, displayType), field_11750, LINK_COLOR);
    }

    public static class_5250 buildHideLink(IMarkableRegion region, DisplayType displayType) {
        var text = class_2561.method_48322("cli.msg.info.region.visualization.hide.link.text", "%s", displayType.name);
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.hide.link.hover", "Click to hide %s-Visualization for '%s'", displayType.name, region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildVisualizationHideCommand(region, displayType), field_11750, LINK_COLOR);
    }

    public static class_5250 buildHierarchyShowLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.visualization.hierarchy.show.link.text", "Show");
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.hierarchy.show.link.hover", "Click to show visualization for all child regions of '%s'", region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildVisualizationShowHierarchyCommand(region), field_11750, LINK_COLOR);
    }

    public static class_5250 buildHierarchyHideLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.visualization.hierarchy.hide.link.text", "Hide");
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.hierarchy.hide.link.hover", "Click to hide visualization for all child regions of '%s'", region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildVisualizationHideHierarchyCommand(region), field_11750, LINK_COLOR);
    }

    public static class_5250 buildIntersectingHideLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.visualization.intersecting.hide.link.text", "Hide");
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.intersecting.hide.link.hover", "Click to hide visualization of intersecting regions for '%s'", region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildVisualizationHideIntersectingCommand(region), field_11750, LINK_COLOR);
    }

    public static class_5250 buildIntersectingShowLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.visualization.intersecting.show.link.text", "Show");
        var hover = class_2561.method_48322("cli.msg.info.region.visualization.intersecting.show.link.hover", "Click to show visualization of intersecting regions for '%s'", region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildVisualizationShowIntersectingCommand(region), field_11750, LINK_COLOR);
    }





}
