/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.permission;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Permissions {
    public static final String MEMBER = "members";
    public static final String OWNER = "owners";
    public static final List<String> GROUP_LIST = Arrays.asList("members", "owners");
    private static final Permissions permission = new Permissions();

    private Permissions() {
    }

    public static Permissions get() {
        return permission;
    }

    public static List<String> getGroups(IProtectedRegion region, class_1657 player) {
        return GROUP_LIST;
    }

    public static boolean playerHasBypassPermission(@NotNull IProtectedRegion region, @Nullable class_1657 player) {
        return player != null && Permissions.hasPermissionOrIsOpWithBypass(region, player);
    }

    private static boolean hasPermissionOrIsOpWithBypass(@NotNull IProtectedRegion region, @NotNull class_1657 player) {
        boolean hasPermission = permission.hasAnyPermission(region, player, Permissions.getGroups(region, player));
        return hasPermission || permission.hasConfigPermAndOpBypassFlags(player);
    }

    public boolean hasConfigPermAndOpBypassFlags(class_1657 player) {
        boolean byPassFlagAllowed = Services.PERMISSION_CONFIG.byPassFlagAllowed();
        boolean hasConfigPerm = Services.PERMISSION_CONFIG.hasConfigPermission(player);
        return hasConfigPerm && byPassFlagAllowed;
    }

    public boolean hasConfigPermission(class_2168 src, CommandSourceType srcType) throws CommandSyntaxException {
        return Services.PERMISSION_CONFIG.hasConfigPermission(src, srcType);
    }

    public boolean hasConfigPermission(class_1657 player) {
        return Services.PERMISSION_CONFIG.hasConfigPermission(player);
    }

    public boolean hasOwnerPermission(IProtectedRegion region, class_1657 player) {
        return this.hasGroupPermission(region, player, OWNER);
    }

    public boolean hasAnyPermission(IProtectedRegion region, class_1657 player, List<String> groups) {
        return groups.stream().map(group -> this.hasGroupPermission(region, player, (String)group)).reduce(false, (b1, b2) -> b1 != false || b2 != false);
    }

    public boolean hasCmdPermission(class_2168 src) {
        CommandSourceType cmdSrcType = CommandSourceType.of(src);
        try {
            return Services.PERMISSION_CONFIG.hasConfigPermission(src, cmdSrcType);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public boolean isAllowedForNonOp(class_2168 src) {
        CommandSourceType cmdSrcType = CommandSourceType.of(src);
        try {
            boolean hasConfigPerm = Services.PERMISSION_CONFIG.hasConfigPermission(src, cmdSrcType);
            return hasConfigPerm || Services.PERMISSION_CONFIG.isCmdEnabledForNonOp();
        }
        catch (CommandSyntaxException e) {
            return false;
        }
    }

    public boolean hasGroupPermission(IProtectedRegion region, class_1657 player, String permissionGroup) {
        return Services.PERMISSION_CONFIG.isHierarchyOwnershipEnabled() ? this.hasRegionHierarchyPermission(region, player, permissionGroup) : this.isInGroup(region, player, permissionGroup);
    }

    public boolean isInGroup(IProtectedRegion region, class_1657 player, String group) {
        return region.isInGroup(player, group);
    }

    private boolean hasRegionHierarchyPermission(IProtectedRegion region, class_1657 player, String permissionGroup) {
        return this.hasRegionHierarchyPermission(region, player, permissionGroup, false);
    }

    private boolean hasRegionHierarchyPermission(IProtectedRegion region, class_1657 player, String permissionGroup, boolean hasPermission) {
        if (region.getParent().equals(region)) {
            return hasPermission || this.isInGroup(region, player, permissionGroup);
        }
        hasPermission = hasPermission || this.isInGroup(region, player, permissionGroup);
        return this.hasRegionHierarchyPermission(region.getParent(), player, permissionGroup, hasPermission);
    }
}

