/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.core.IDimensionRegionApi;
import de.z0rdak.yawp.api.core.RegionManager;
import de.z0rdak.yawp.api.visualization.VisualizationManager;
import de.z0rdak.yawp.commands.CommandUtil;
import de.z0rdak.yawp.commands.DimensionCommands;
import de.z0rdak.yawp.commands.RegionCommands;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.commands.arguments.region.ContainingOwnedRegionArgumentType;
import de.z0rdak.yawp.commands.arguments.region.RegionArgumentType;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.DisplayType;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import de.z0rdak.yawp.util.text.messages.pagination.InvalidPageNumberException;
import de.z0rdak.yawp.util.text.messages.pagination.RegionsInDimensionPagination;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;

class ShortcutCommands {
    private ShortcutCommands() {
    }

    static LiteralArgumentBuilder<class_2168> buildInfoLocal() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.INFO).then(class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (class_1937)((class_2168)ctx.getSource()).method_9225())).executes(ctx -> CommandUtil.promptRegionInfo((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionIn((CommandContext<class_2168>)ctx, (class_1937)((class_2168)ctx.getSource()).method_9225()))));
    }

    static LiteralArgumentBuilder<class_2168> buildDeleteLocal() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.DELETE).then(class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (class_1937)((class_2168)ctx.getSource()).method_9225())).executes(ctx -> DimensionCommands.deleteRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionIn((CommandContext<class_2168>)ctx, (class_1937)((class_2168)ctx.getSource()).method_9225()))));
    }

    static LiteralArgumentBuilder<class_2168> buildCreateLocal() {
        return (LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.CREATE).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.NAME.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(Collections.singletonList(DimensionCommands.getRandomExample()), (SuggestionsBuilder)builder)).then(class_2170.method_9247((String)AreaType.CUBOID.areaType).then(class_2170.method_9244((String)CommandConstants.POS1.toString(), (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.POS2.toString(), (ArgumentType)class_2262.method_9698()).executes(ctx -> DimensionCommands.createCuboidRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.POS1.toString()), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.POS2.toString()), null))).then(class_2170.method_9244((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.createCuboidRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.POS1.toString()), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.POS2.toString()), ArgumentUtil.getContainingOwnedRegionArgument((CommandContext<class_2168>)ctx)))))))).then(class_2170.method_9247((String)AreaType.SPHERE.areaType).then(class_2170.method_9244((String)CommandConstants.CENTER_POS.toString(), (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> DimensionCommands.createSphereRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()), null))).then(class_2170.method_9244((String)CommandConstants.PARENT.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> ContainingOwnedRegionArgumentType.owningRegions().listSuggestions(ctx, builder)).executes(ctx -> DimensionCommands.createSphereRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionNameArgument((CommandContext<class_2168>)ctx), class_2262.method_9697((CommandContext)ctx, (String)CommandConstants.CENTER_POS.toString()), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()), ArgumentUtil.getContainingOwnedRegionArgument((CommandContext<class_2168>)ctx))))))));
    }

    static LiteralArgumentBuilder<class_2168> buildHide() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.HIDE).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (class_1937)((class_2168)ctx.getSource()).method_9225())).executes(ctx -> RegionCommands.hideRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionIn((CommandContext<class_2168>)ctx, (class_1937)((class_2168)ctx.getSource()).method_9225()), DisplayType.FRAME))).then(class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.hideRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionIn((CommandContext<class_2168>)ctx, (class_1937)((class_2168)ctx.getSource()).method_9225()), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx))))))).then(ShortcutCommands.buildHideAll())).then(ShortcutCommands.buildHideNear());
    }

    private static LiteralArgumentBuilder<class_2168> buildHideAll() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.ALL).executes(ShortcutCommands::hideRegions)).then(class_2170.method_9244((String)CommandConstants.UNTRACKED.toString(), (ArgumentType)BoolArgumentType.bool()).executes(ctx -> ShortcutCommands.hideRegions((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)CommandConstants.UNTRACKED.toString()))));
    }

    private static LiteralArgumentBuilder<class_2168> buildHideNear() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.NEAR).executes(ctx -> ShortcutCommands.hideRegionsAroundPlayer((CommandContext<class_2168>)ctx, 192))).then(class_2170.method_9244((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0, (int)800)).executes(ctx -> ShortcutCommands.hideRegionsAroundPlayer((CommandContext<class_2168>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString()))));
    }

    private static LiteralArgumentBuilder<class_2168> buildShowNear() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.NEAR).executes(ctx -> ShortcutCommands.showRegionsAroundPlayer((CommandContext<class_2168>)ctx, DisplayType.FRAME, 192))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.RADIUS.toString(), (ArgumentType)IntegerArgumentType.integer((int)0, (int)800)).executes(ctx -> ShortcutCommands.showRegionsAroundPlayer((CommandContext<class_2168>)ctx, DisplayType.FRAME, IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString())))).then(class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> ShortcutCommands.showRegionsAroundPlayer((CommandContext<class_2168>)ctx, ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx), IntegerArgumentType.getInteger((CommandContext)ctx, (String)CommandConstants.RADIUS.toString())))));
    }

    static LiteralArgumentBuilder<class_2168> buildShow() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ArgumentUtil.literal(CommandConstants.SHOW).then(ArgumentUtil.literal(CommandConstants.LOCAL).then(((RequiredArgumentBuilder)class_2170.method_9244((String)CommandConstants.LOCAL.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> RegionArgumentType.region().listSuggestionsIn(ctx, builder, (class_1937)((class_2168)ctx.getSource()).method_9225())).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionIn((CommandContext<class_2168>)ctx, (class_1937)((class_2168)ctx.getSource()).method_9225()), DisplayType.FRAME))).then(class_2170.method_9244((String)CommandConstants.STYLE.toString(), (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9265(DisplayType.entries(), (SuggestionsBuilder)builder)).executes(ctx -> RegionCommands.showRegion((CommandContext<class_2168>)ctx, ArgumentUtil.getRegionIn((CommandContext<class_2168>)ctx, (class_1937)((class_2168)ctx.getSource()).method_9225()), ArgumentUtil.getDisplayTypeArgument((CommandContext<class_2168>)ctx))))))).then(ShortcutCommands.buildShowNear());
    }

    private static int promptRegionsAroundPlayer(CommandContext<class_2168> ctx, int blockRadius) throws CommandSyntaxException {
        class_3218 level = ((class_2168)ctx.getSource()).method_9225();
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        Optional<IDimensionRegionApi> maybeDimRegionApi = RegionManager.get().getDimRegionApi((class_5321<class_1937>)level.method_27983());
        if (maybeDimRegionApi.isPresent()) {
            IDimensionRegionApi dimRegionApi = maybeDimRegionApi.get();
            List<IProtectedRegion> regionsAround = dimRegionApi.getRegionsAround(player.method_24515(), blockRadius).stream().map(r -> r).collect(Collectors.toList());
            try {
                int paginationSize = Services.REGION_CONFIG.getPaginationSize();
                RegionsInDimensionPagination childRegionPagination = new RegionsInDimensionPagination(dimRegionApi.getCache(), regionsAround, 0, paginationSize);
                MultiLineMessage.send((class_2168)ctx.getSource(), childRegionPagination);
            }
            catch (InvalidPageNumberException e) {
                MessageSender.sendError((class_2168)ctx.getSource(), e.getError());
                return -1;
            }
            return 0;
        }
        return -1;
    }

    private static int showRegionsAroundPlayer(CommandContext<class_2168> ctx, DisplayType displayType, int blockRadius) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        VisualizationManager.showRegionsAround((class_1657)player, blockRadius, displayType);
        class_1937 level = player.method_5770();
        class_2338 playerPos = player.method_24515();
        Optional<IDimensionRegionApi> maybeApi = RegionManager.get().getDimRegionApi((class_5321<class_1937>)level.method_27983());
        if (maybeApi.isPresent()) {
            IDimensionRegionApi dimApi = maybeApi.get();
            List<IMarkableRegion> list = dimApi.getRegionsAround(playerPos, blockRadius);
        }
        return 0;
    }

    private static int hideRegions(CommandContext<class_2168> ctx) {
        return ShortcutCommands.hideRegions(ctx, false);
    }

    private static int hideRegions(CommandContext<class_2168> ctx, boolean untracked) {
        VisualizationManager.hideAllRegions((class_1937)((class_2168)ctx.getSource()).method_9225(), untracked);
        return 0;
    }

    private static int hideRegionsAroundPlayer(CommandContext<class_2168> ctx, int blockRadius) throws CommandSyntaxException {
        class_3222 player = ((class_2168)ctx.getSource()).method_9207();
        VisualizationManager.hideRegionsAround((class_1657)player, blockRadius);
        return 0;
    }
}

