/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.config.server;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.commands.CommandSourceType;
import de.z0rdak.yawp.platform.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PermissionConfig {
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final String CONFIG_NAME = "yawp-common.toml";
    public static final Logger PERMISSION_CONFIG_LOGGER;
    private static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_REGION_TP;
    private static final ForgeConfigSpec.ConfigValue<Boolean> ALLOW_READ_ONLY_CMDS;
    private static final ForgeConfigSpec.ConfigValue<Boolean> DISABLE_CMD_FOR_NON_OP;
    private static final ForgeConfigSpec.ConfigValue<Boolean> OP_BYPASS_FLAGS;
    private static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_HIERARCHY_OWNERSHIP;
    private static final ForgeConfigSpec.ConfigValue<Integer> REQUIRED_OP_LEVEL;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> PLAYERS_WITH_PERMISSION;
    private static final ForgeConfigSpec.ConfigValue<Boolean> COMMAND_BLOCK_EXECUTION;
    private static final ForgeConfigSpec.ConfigValue<Boolean> ENABLE_MARKER_CREATION;

    private static boolean containsBadLength(List<String> tokens, int size) {
        return tokens.stream().anyMatch(t -> t.length() != size);
    }

    public static Set<String> UUIDsWithPermission() {
        return ((List)PLAYERS_WITH_PERMISSION.get()).stream().filter(Objects::nonNull).map(s -> s).collect(Collectors.toSet());
    }

    public static boolean isReadOnlyAllowed() {
        return (Boolean)ALLOW_READ_ONLY_CMDS.get();
    }

    public static boolean isCmdEnabledForNonOp() {
        return (Boolean)DISABLE_CMD_FOR_NON_OP.get() == false;
    }

    public static boolean allowRegionTp() {
        return (Boolean)ENABLE_REGION_TP.get();
    }

    public static boolean isMarkerCreationEnabled() {
        return (Boolean)ENABLE_MARKER_CREATION.get();
    }

    public static boolean isHierarchyOwnershipEnabled() {
        return (Boolean)ENABLE_HIERARCHY_OWNERSHIP.get();
    }

    public static boolean isCommandBlockExecutionAllowed() {
        return (Boolean)COMMAND_BLOCK_EXECUTION.get();
    }

    public static int getRequiredOpLevel() {
        return (Integer)REQUIRED_OP_LEVEL.get();
    }

    public static boolean byPassFlagAllowed() {
        return (Boolean)OP_BYPASS_FLAGS.get();
    }

    private static boolean validateUuid(Object uuid) {
        if (uuid instanceof String) {
            try {
                String uuidStr = (String)uuid;
                if (uuidStr.length() != 36) {
                    throw new IllegalArgumentException("Invalid UUID - wrong length");
                }
                List<String> uuidTokens = Arrays.asList(uuidStr.split("-"));
                List<String> shortTokens = uuidTokens.subList(1, 3);
                if (uuidTokens.get(0).length() != 8 || PermissionConfig.containsBadLength(shortTokens, 4) || uuidTokens.get(4).length() != 12) {
                    throw new IllegalArgumentException("Invalid UUID - wrong token sizes");
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                PERMISSION_CONFIG_LOGGER.warn("Invalid UUID '{}' in config", uuid);
                return false;
            }
        }
        return false;
    }

    public static boolean hasConfigPermission(class_1657 player) {
        return PermissionConfig.hasUUIDConfigEntry(player) || PermissionConfig.hasRequiredOpLevel(player);
    }

    public static boolean hasUUIDConfigEntry(class_1657 player) {
        return Services.PERMISSION_CONFIG.UUIDsWithPermission().contains(player.method_5845());
    }

    public static boolean hasRequiredOpLevel(class_1657 player) {
        return player.method_5687(Services.PERMISSION_CONFIG.getRequiredOpLevel());
    }

    public static boolean hasConfigPermission(class_2168 src, CommandSourceType cmdSrcType) throws CommandSyntaxException {
        switch (cmdSrcType) {
            case PLAYER: {
                class_3222 player = src.method_9207();
                return PermissionConfig.hasConfigPermission((class_1657)player);
            }
            case COMMAND_BLOCK: {
                return Services.PERMISSION_CONFIG.isCommandBlockExecutionAllowed();
            }
            case SERVER: {
                return true;
            }
        }
        return false;
    }

    static {
        PERMISSION_CONFIG_LOGGER = LogManager.getLogger((String)("yawp".toUpperCase() + "-Permission-Config"));
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.push("YetAnotherWorldProtector mod server configuration").build();
        COMMAND_BLOCK_EXECUTION = BUILDER.comment("Permission for command blocks to execute mod commands").define("command_block_execution", true);
        REQUIRED_OP_LEVEL = BUILDER.comment("Minimum OP level to use mod commands.\n 0 -> everyone can use the commands.\n 1-4 -> OP with specific level can use the commands.\n 5 -> no operator can use the commands.\n Defaults to 5.").defineInRange("command_op_level", 4, 0, 5);
        ALLOW_READ_ONLY_CMDS = BUILDER.comment("Defines whether info commands for regions can be used by every player.").define("allow_info_cmds", true);
        DISABLE_CMD_FOR_NON_OP = BUILDER.comment("Defines whether mod commands are disabled for non-OP players.").define("disable_cmd_for_non_op", false);
        OP_BYPASS_FLAGS = BUILDER.comment("Defines whether OPs/permitted players are allowed to bypass flags set in regions.").define("op_bypass_flags", true);
        ENABLE_HIERARCHY_OWNERSHIP = BUILDER.comment("Defines whether owners of parent regions have implicit ownership rights for child regions as well").define("hierarchy_ownership", true);
        ENABLE_REGION_TP = BUILDER.comment("Defines whether teleport in and out of a region is allowed by everyone. Mostly useful when using something like Waystones inside of regions.").define("allow_region_tp", false);
        ENABLE_MARKER_CREATION = BUILDER.comment("Enable creation of RegionMarker by renaming a stick in an Anvil.").define("enable_marker_creation", true);
        PLAYERS_WITH_PERMISSION = BUILDER.comment("Player UUIDs with permission to use mod commands.\n Make sure to put the UUIDs in parentheses, just like a normal string.\n Example: players_with_permission = [\"614c9eac-11c9-3ca6-b697-938355fa8235\", \"b9f5e998-520a-3fa2-8208-0c20f22aa20f\"]").defineListAllowEmpty(Collections.singletonList("players_with_permission"), ArrayList::new, PermissionConfig::validateUuid);
        BUILDER.pop();
        CONFIG_SPEC = BUILDER.build();
    }
}

