/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.flag;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.flag.Flag;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.IFlagContainer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class RegionFlags
implements IFlagContainer {
    public static Codec<RegionFlags> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING, Flag.CODEC).optionalFieldOf("flags", new HashMap()).forGetter(a -> a.flags)).apply((Applicative)instance, RegionFlags::new));
    private final Map<String, IFlag> flags;

    public RegionFlags() {
        this.flags = new HashMap<String, IFlag>();
    }

    public RegionFlags(Map<String, IFlag> flags) {
        this.flags = new HashMap<String, IFlag>(flags);
    }

    @Override
    public void put(IFlag flag) {
        this.flags.put(flag.getName(), flag);
    }

    @Override
    public IFlag get(String flagName) {
        return this.flags.get(flagName);
    }

    @Override
    public void remove(String flag) {
        this.flags.remove(flag);
    }

    @Override
    public boolean contains(String flag) {
        return this.flags.containsKey(flag);
    }

    @Override
    public void clear() {
        this.flags.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.flags.isEmpty();
    }

    @Override
    public int size() {
        return this.flags.size();
    }

    @Override
    public Set<Map.Entry<String, IFlag>> flagEntries() {
        return Collections.unmodifiableSet(this.flags.entrySet());
    }

    @Override
    public List<IFlag> flags() {
        return List.copyOf(this.flags.values());
    }

    @Override
    public List<IFlag> flags(FlagState state) {
        return this.flags.values().stream().filter(flag -> flag.getState() == state).toList();
    }

    @Override
    public FlagState flagState(String flagName) {
        if (this.contains(flagName)) {
            return this.flags.get(flagName).getState();
        }
        return FlagState.UNDEFINED;
    }

    @Override
    public boolean isFlagDefined(@NotNull String flagName) {
        return this.flagState(flagName) != FlagState.UNDEFINED;
    }

    @Override
    public boolean isAllowedOrDenied(@NotNull String flagName) {
        FlagState flagState = this.flagState(flagName);
        return flagState == FlagState.ALLOWED || flagState == FlagState.DENIED;
    }

    public Map<String, IFlag> getActiveFlags() {
        HashMap<String, IFlag> activeFlags = new HashMap<String, IFlag>();
        this.flags.forEach((k, v) -> {
            if (v.isActive()) {
                activeFlags.put((String)k, (IFlag)v);
            }
        });
        return activeFlags;
    }

    public Map<String, IFlag> getFlagMap() {
        return this.flags;
    }
}

