/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.handler.flags;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import java.util.Set;
import net.fabricmc.fabric.api.entity.event.v1.EntityElytraEvents;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2611;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3722;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7248;
import net.minecraft.class_7265;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public final class PlayerFlagHandler {
    public static final boolean ALLOW = true;

    private PlayerFlagHandler() {
    }

    public static void register() {
        EntitySleepEvents.ALLOW_SLEEPING.register(PlayerFlagHandler::onAllowSleeping);
        EntitySleepEvents.ALLOW_SETTING_SPAWN.register(PlayerFlagHandler::onSettingSpawn);
        EntityElytraEvents.ALLOW.register(PlayerFlagHandler::onElytraFlight);
        UseItemCallback.EVENT.register(PlayerFlagHandler::onUseItem);
        UseBlockCallback.EVENT.register(PlayerFlagHandler::onUseBlock);
        UseEntityCallback.EVENT.register(PlayerFlagHandler::onUseEntity);
        AttackBlockCallback.EVENT.register(PlayerFlagHandler::onAttackBlock);
    }

    private static class_1271<class_1799> onUseItem(class_1657 player, class_1937 world, class_1268 hand) {
        class_1799 stackInHand = player.method_5998(hand);
        if (player.method_7325() || player.method_7357().method_7904(stackInHand.method_7909())) {
            return class_1271.method_22430((Object)stackInHand);
        }
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return class_1271.method_22430((Object)stackInHand);
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            if (flagState == FlagState.DENIED) {
                return class_1271.method_22431((Object)stackInHand);
            }
        }
        return class_1271.method_22430((Object)stackInHand);
    }

    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (HandlerUtil.isServerSide(world)) {
            boolean isContainer;
            class_1838 useOnContext = new class_1838(player, hand, blockHitResult);
            class_2338 targetPos = useOnContext.method_8037();
            class_2338 placeBlockTarget = targetPos.method_10093(useOnContext.method_8038());
            class_2586 targetEntity = world.method_8321(targetPos);
            boolean hasEmptyHand = PlayerFlagHandler.hasEmptyHand(player, hand);
            class_1799 stackInHand = useOnContext.method_8041();
            boolean isBlock = stackInHand.method_7909() instanceof class_1747;
            boolean isSneakingWithEmptyHands = player.method_5715() && hasEmptyHand;
            boolean isBlockEntity = targetEntity instanceof class_2586;
            boolean isLockableTileEntity = targetEntity instanceof class_2624;
            boolean isEnderChest = targetEntity instanceof class_2611;
            boolean bl = isContainer = targetEntity instanceof class_3722 || isLockableTileEntity;
            if (isSneakingWithEmptyHands || !player.method_5715()) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(targetPos, RegionFlag.USE_BLOCKS, HandlerUtil.getDimKey((class_1297)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return class_1269.field_5811;
                }
                FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED) {
                    return class_1269.field_5814;
                }
                if (isEnderChest && (player.method_5715() && hasEmptyHand || !player.method_5715())) {
                    checkEvent = new FlagCheckEvent(targetPos, RegionFlag.ENDER_CHEST_ACCESS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return class_1269.field_5811;
                    }
                    flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                    if (flagState == FlagState.DENIED) {
                        return class_1269.field_5814;
                    }
                }
                if (isContainer && (player.method_5715() && hasEmptyHand || !player.method_5715())) {
                    checkEvent = new FlagCheckEvent(targetPos, RegionFlag.CONTAINER_ACCESS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return class_1269.field_5811;
                    }
                    flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                    if (flagState == FlagState.DENIED) {
                        return class_1269.field_5814;
                    }
                }
            }
            if (!hasEmptyHand) {
                FlagState flagState;
                FlagCheckEvent checkEvent;
                boolean targetsContainerWhileNotSneaking;
                boolean bl2 = targetsContainerWhileNotSneaking = (isContainer || isEnderChest) && !player.method_5715();
                if (targetsContainerWhileNotSneaking) {
                    // empty if block
                }
                class_2960 itemRl = class_7923.field_41178.method_10221((Object)stackInHand.method_7909());
                Set<String> entities = FlagConfig.getCoveredBlockEntities();
                Set<String> entityTags = FlagConfig.getCoveredBlockEntityTags();
                boolean isCoveredByTag = entityTags.stream().anyMatch(tag -> {
                    class_2960 tagRl = new class_2960(tag);
                    return stackInHand.method_40133().anyMatch(itemTagKey -> itemTagKey.comp_327().equals((Object)tagRl));
                });
                boolean isBlockCovered = entities.stream().anyMatch(entity -> {
                    class_2960 entityRl = new class_2960(entity);
                    return itemRl.equals((Object)entityRl);
                });
                if (isBlockCovered || isCoveredByTag) {
                    FlagCheckEvent checkEvent2 = new FlagCheckEvent(placeBlockTarget, RegionFlag.PLACE_BLOCKS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent2)) {
                        return class_1269.field_5811;
                    }
                    FlagState flagState2 = FlagEvaluator.processCheck(checkEvent2, MessageSender::sendFlagMsg);
                    if (flagState2 == FlagState.DENIED) {
                        return class_1269.field_5814;
                    }
                }
                boolean isBerry = class_1799.method_7984((class_1799)stackInHand, (class_1799)class_1802.field_28659.method_7854()) || class_1799.method_7984((class_1799)stackInHand, (class_1799)class_1802.field_28659.method_7854());
                class_1839 useAction = stackInHand.method_7976();
                if (isBlock || isBerry && useAction == class_1839.field_8950) {
                    checkEvent = new FlagCheckEvent(placeBlockTarget, RegionFlag.PLACE_BLOCKS, HandlerUtil.getDimKey((class_1297)player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return class_1269.field_5811;
                    }
                    flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                    if (flagState == FlagState.DENIED) {
                        return class_1269.field_5814;
                    }
                }
                if (Services.EVENT.post(checkEvent = new FlagCheckEvent(targetPos, RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((class_1297)player), player))) {
                    return class_1269.field_5811;
                }
                flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED) {
                    return class_1269.field_5814;
                }
            }
        }
        player.method_31548().method_5431();
        return class_1269.field_5811;
    }

    private static class_1269 onUseEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        class_1269 actionResult;
        if (player.method_7325()) {
            if (entity instanceof class_3908) {
                player.method_17355((class_3908)entity);
            }
            return class_1269.field_5811;
        }
        if (entityHitResult != null && (actionResult = PlayerFlagHandler.onUseEntitySpecific(player, world, hand, entity, entityHitResult)) == class_1269.field_5812) {
            return actionResult;
        }
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(entity.method_24515(), RegionFlag.USE_ENTITIES, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return class_1269.field_5811;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            if (flagState == FlagState.DENIED) {
                return class_1269.field_5814;
            }
            if (!PlayerFlagHandler.hasEmptyHand(player, hand)) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), RegionFlag.USE_ITEMS, HandlerUtil.getDimKey((class_1297)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return class_1269.field_5811;
                }
                flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED) {
                    return class_1269.field_5814;
                }
            }
            if (entity instanceof class_7265 || entity instanceof class_7248) {
                checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.CONTAINER_ACCESS, HandlerUtil.getDimKey((class_1297)player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return class_1269.field_5811;
                }
                flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED) {
                    return class_1269.field_5814;
                }
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 onUseEntitySpecific(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 entityHitResult) {
        return class_1269.field_5811;
    }

    private static class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        if (HandlerUtil.isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.BREAK_BLOCKS, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return class_1269.field_5811;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            return flagState == FlagState.DENIED ? class_1269.field_5814 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static boolean onSettingSpawn(class_1657 player, class_2338 blockPos) {
        if (HandlerUtil.isServerSide((class_1297)player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.SET_SPAWN, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return true;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            return flagState != FlagState.DENIED;
        }
        return true;
    }

    private static class_1657.class_1658 onAllowSleeping(class_1657 player, class_2338 blockPos) {
        if (HandlerUtil.isServerSide((class_1297)player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.SLEEP, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return null;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            if (flagState == FlagState.DENIED) {
                return class_1657.class_1658.field_7528;
            }
        }
        return null;
    }

    private static boolean onElytraFlight(class_1309 livingEntity) {
        if (HandlerUtil.isServerSide(livingEntity.method_37908()) && livingEntity instanceof class_1657) {
            class_1657 player = (class_1657)livingEntity;
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), RegionFlag.USE_ELYTRA, HandlerUtil.getDimKey((class_1297)player), player);
            if (Services.EVENT.post(checkEvent)) {
                return true;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            return flagState != FlagState.DENIED;
        }
        return true;
    }

    private static boolean hasEmptyHands(class_1657 player) {
        return player.method_5998(class_1268.field_5808).method_7909().equals(class_1802.field_8162) && player.method_5998(class_1268.field_5810).method_7909().equals(class_1802.field_8162);
    }

    private static boolean hasEmptyHand(class_1657 player, class_1268 hand) {
        return player.method_5998(hand).method_7909().equals(class_1802.field_8162);
    }
}

