package de.z0rdak.yawp.handler.flags;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.config.server.FlagConfig;
import de.z0rdak.yawp.core.flag.FlagState;
import de.z0rdak.yawp.platform.Services;
import de.z0rdak.yawp.api.MessageSender;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2611;
import net.minecraft.class_2624;
import net.minecraft.class_2960;
import net.minecraft.class_3722;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_7248;
import net.minecraft.class_7265;
import net.minecraft.class_7923;
import net.minecraft.world.item.*;
import org.jetbrains.annotations.Nullable;

import java.util.Set;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;

/**
 * Contains flag handler for events directly related/cause to/by players.
 */
public final class PlayerFlagHandler {

    public static final boolean ALLOW = true;

    private PlayerFlagHandler() {
    }

    public static void register() {
        EntitySleepEvents.ALLOW_SLEEPING.register(PlayerFlagHandler::onAllowSleeping);
        EntitySleepEvents.ALLOW_SETTING_SPAWN.register(PlayerFlagHandler::onSettingSpawn);
        // EntityElytraEvents.ALLOW.register(PlayerFlagHandler::onElytraFlight);

        UseItemCallback.EVENT.register(PlayerFlagHandler::onUseItem);
        UseBlockCallback.EVENT.register(PlayerFlagHandler::onUseBlock);
        UseEntityCallback.EVENT.register(PlayerFlagHandler::onUseEntity);

        AttackBlockCallback.EVENT.register(PlayerFlagHandler::onAttackBlock);
    }

    /**
     * This event is fired before the player triggers {@link class_1792#method_7836(class_1937, class_1657, class_1268)}.
     * Note that this is NOT fired if the player is targeting a block {@link UseBlockCallback} or entity {@link UseEntityCallback}.
     */
    private static class_1271<class_1799> onUseItem(class_1657 player, class_1937 world, class_1268 hand) {
        /* Vanilla code - START
        This is in place to ensure same behaviour of flags across fabric and forge - check this on each update! */
        class_1799 stackInHand = player.method_5998(hand);
        if (player.method_7325() || player.method_7357().method_7904(stackInHand.method_7909())) {
            return class_1271.method_22430(stackInHand);
        }
        /* Vanilla code - END */
        if (isServerSide(world)) {
            //FLAG_LOGGER.info("[onUseItem] Player={} ({}), at=[{}], Hand={}, Item={}", player.getName().getString(), player.getUuidAsString(), player.getBlockPos().toShortString(), hand, player.getStackInHand(hand));
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), USE_ITEMS, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent)) {
                return class_1271.method_22430(stackInHand);
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            if (flagState == FlagState.DENIED) {
                return class_1271.method_22431(stackInHand);
            }
        }
        return class_1271.method_22430(stackInHand);
    }


    /**
     * This event is fired whenever the player right clicks while targeting a block. <br>
     * This event controls which of
     * {@link net.minecraft.class_2680#method_55780(class_1799, class_1937, class_1657, class_1268, class_3965)}, and  <br>
     * {@link class_1799#method_7981(class_1838)}  <br>
     * will be called. <br>
     * Canceling the event will cause none of the above to be called. <br>
     * <br>
     * Let result be the first non-pass return value of the above methods, or pass, if they all pass. <br>
     * If result equals {@link class_1269#field_5811}, we proceed to {@link UseItemCallback}.  <br>
     */
    private static class_1269 onUseBlock(class_1657 player, class_1937 world, class_1268 hand, class_3965 blockHitResult) {
        if (isServerSide(world)) {
            class_1838 useOnContext = new class_1838(player, hand, blockHitResult);
            class_2338 targetPos = useOnContext.method_8037();
            class_2338 placeBlockTarget = targetPos.method_10093(useOnContext.method_8038());
            class_2586 targetEntity = world.method_8321(targetPos);
            boolean hasEmptyHand = hasEmptyHand(player, hand);
            class_1799 stackInHand = useOnContext.method_8041();
            boolean isBlock = stackInHand.method_7909() instanceof class_1747;
            boolean isSneakingWithEmptyHands = player.method_5715() && hasEmptyHand;
            boolean isBlockEntity = targetEntity instanceof class_2586;
            boolean isLockableTileEntity = targetEntity instanceof class_2624;
            boolean isEnderChest = targetEntity instanceof class_2611;
            boolean isContainer = targetEntity instanceof class_3722 || isLockableTileEntity;

            //FLAG_LOGGER.info("[onUseBlock] Player={} ({}), Target=[{}], PLaceOn=[{}], BlockEntity={}, Hand={}, Item={} (isBlock={})", player.getName().getString(), player.getUuidAsString(), targetPos.toShortString(), placeBlockTarget.toShortString(), isBlockEntity, useOnConComponent.getHand(), player.getStackInHand(useOnConComponent.getHand()), isBlock);

            // allow player to place blocks when shift clicking usable bock
            if ((isSneakingWithEmptyHands || !player.method_5715())) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(targetPos, USE_BLOCKS, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent))
                    return class_1269.field_5811;
                FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED)
                    return class_1269.field_5814;


                if (isEnderChest) {
                    // check allows player to place blocks when shift clicking container
                    if (player.method_5715() && hasEmptyHand || !player.method_5715()) {
                        checkEvent = new FlagCheckEvent(targetPos, ENDER_CHEST_ACCESS, getDimKey(player), player);
                        if (Services.EVENT.post(checkEvent))
                            return class_1269.field_5811;
                        flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                        if (flagState == FlagState.DENIED)
                            return class_1269.field_5814;
                    }
                }
                if (isContainer) {
                    // check allows player to place blocks when shift clicking container
                    if (player.method_5715() && hasEmptyHand || !player.method_5715()) {
                        checkEvent = new FlagCheckEvent(targetPos, CONTAINER_ACCESS, getDimKey(player), player);
                        if (Services.EVENT.post(checkEvent))
                            return class_1269.field_5811;
                        flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                        if (flagState == FlagState.DENIED)
                            return class_1269.field_5814;
                    }
                }
            }

            if (!hasEmptyHand) {
                boolean targetsContainerWhileNotSneaking = (isContainer || isEnderChest) && !player.method_5715();
                if (targetsContainerWhileNotSneaking) { // should be allowed to access container in this case
                    //FLAG_LOGGER.info("### targetsContainerWhileNotSneaking ###");
                }

                class_2960 itemRl = class_7923.field_41178.method_10221(stackInHand.method_7909());
                Set<String> entities = FlagConfig.getCoveredBlockEntities();
                Set<String> entityTags = FlagConfig.getCoveredBlockEntityTags();
                boolean isCoveredByTag = entityTags.stream().anyMatch(tag -> {
                    class_2960 tagRl = class_2960.method_60654(tag);
                    return stackInHand.method_40133().anyMatch(itemTagKey -> itemTagKey.comp_327().equals(tagRl));
                });
                boolean isBlockCovered = entities.stream().anyMatch(entity -> {
                    class_2960 entityRl = class_2960.method_60654(entity);
                    return itemRl.equals(entityRl);
                });
                if (isBlockCovered || isCoveredByTag) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(placeBlockTarget, PLACE_BLOCKS, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent)) {
                        return class_1269.field_5811;
                    }
                    FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                    if (flagState == FlagState.DENIED) {
                        return class_1269.field_5814;
                    }
                }


                boolean isBerry = class_1799.method_7984(stackInHand, class_1802.field_28659.method_7854()) || class_1799.method_7984(stackInHand, class_1802.field_28659.method_7854());
                class_1839 useAction = stackInHand.method_7976();
                if (isBlock || (isBerry && useAction == class_1839.field_8950)) {
                    FlagCheckEvent checkEvent = new FlagCheckEvent(placeBlockTarget, PLACE_BLOCKS, getDimKey(player), player);
                    if (Services.EVENT.post(checkEvent))
                        return class_1269.field_5811;
                    FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                    if (flagState == FlagState.DENIED)
                        return class_1269.field_5814;
                }

                FlagCheckEvent checkEvent = new FlagCheckEvent(targetPos, USE_ITEMS, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent))
                    return class_1269.field_5811;
                FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED)
                    return class_1269.field_5814;
            }
        }
        player.method_31548().method_5431();
        return class_1269.field_5811;
    }

    /**
     * This event is fired on both sides when the player right-clicks an entity.
     * It is responsible for all general entity interactions.
     * This event's state affects whether {@link class_1297#method_5688(class_1657, class_1268)} and
     * {@link class_1792#method_7847(class_1799, class_1657, class_1309, class_1268)} are called.
     * Let result be {@link class_1269#field_5812} if {@link class_1297#method_5688(class_1657, class_1268)} or
     * {@link class_1792#method_7847(class_1799, class_1657, class_1309, class_1268)} return true,
     * or FAIL if the event is cancelled.
     */
    private static class_1269 onUseEntity(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, @Nullable class_3966 entityHitResult) {
        /* Vanilla code - START
        This is in place to ensure same behaviour of flags across fabric and forge - check this on each update! */
        if (player.method_7325()) {
            if (entity instanceof class_3908) {
                player.method_17355((class_3908) entity);
            }
            return class_1269.field_5811;
        }
        /* Vanilla code - END */

        if (entityHitResult != null) {
            // present entity hit result acts the same as EntityInteractSpecificEvent in Forge - only used for ArmorStands in Vanilla
            class_1269 actionResult = onUseEntitySpecific(player, world, hand, entity, entityHitResult);
            if (actionResult == class_1269.field_5812) {
                return actionResult;
            }
        }

        if (isServerSide(world)) {
            //FLAG_LOGGER.info("[onUseEntity] Player={} ({}), Target={} ({}), at=[{}], Hand={}, Item={}", player.getName().getString(), player.getUuidAsString(), entity.getName().getString(), entity.getScoreboardName(), entity.getBlockPos().toShortString(), hand, player.getStackInHand(hand));

            FlagCheckEvent checkEvent = new FlagCheckEvent(entity.method_24515(), USE_ENTITIES, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return class_1269.field_5811;
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            if (flagState == FlagState.DENIED)
                return class_1269.field_5814;

            if (!hasEmptyHand(player, hand)) {
                checkEvent = new FlagCheckEvent(entity.method_24515(), USE_ITEMS, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent))
                    return class_1269.field_5811;
                flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED)
                    return class_1269.field_5814;
            }
            if (entity instanceof class_7265 || entity instanceof class_7248) {
                checkEvent = new FlagCheckEvent(player.method_24515(), CONTAINER_ACCESS, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent))
                    return class_1269.field_5811;
                flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                if (flagState == FlagState.DENIED)
                    return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    private static class_1269 onUseEntitySpecific(class_1657 player, class_1937 world, class_1268 hand, class_1297 entity, class_3966 entityHitResult) {
        return class_1269.field_5811;
    }

    private static class_1269 onAttackBlock(class_1657 player, class_1937 world, class_1268 hand, class_2338 blockPos, class_2350 direction) {
        if (isServerSide(world)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, BREAK_BLOCKS, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent)) {
                return class_1269.field_5811;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            return flagState == FlagState.DENIED ? class_1269.field_5814 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    private static boolean onSettingSpawn(class_1657 player, class_2338 blockPos) {
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, SET_SPAWN, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent)) {
                return ALLOW;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            return flagState != FlagState.DENIED;
        }
        return ALLOW;
    }

    private static class_1657.class_1658 onAllowSleeping(class_1657 player, class_2338 blockPos) {
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, SLEEP, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent)) {
                return null;
            }
            FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
            if (flagState == FlagState.DENIED) {
                return class_1657.class_1658.field_7528;
            }
        }
        return null;
    }

    private static boolean onElytraFlight(class_1309 livingEntity) {
        if (isServerSide(livingEntity.method_37908())) {
            if (livingEntity instanceof class_1657 player) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), USE_ELYTRA, getDimKey(player), player);
                if (Services.EVENT.post(checkEvent)) {
                    return ALLOW;
                }
                FlagState flagState = FlagEvaluator.processCheck(checkEvent, MessageSender::sendFlagMsg);
                return flagState != FlagState.DENIED;
            }
        }
        return ALLOW;
    }

    private static boolean hasEmptyHands(class_1657 player) {
        return player.method_5998(class_1268.field_5808).method_7909().equals(class_1802.field_8162)
                && player.method_5998(class_1268.field_5810).method_7909().equals(class_1802.field_8162);
    }

    private static boolean hasEmptyHand(class_1657 player, class_1268 hand) {
        return player.method_5998(hand).method_7909().equals(class_1802.field_8162);
    }
}