package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.handler.flags.ExplosionDamageCalculatorInterceptor;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_3414;
import net.minecraft.class_5362;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1927.class)
public abstract class ExplosionMixin {

    @Final
    @Shadow
    @Mutable
    private class_5362 damageCalculator;

    // Note: part of the explosion flag handling system is in ServerWorldMixin
    @Inject(method = "<init>(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/damagesource/DamageSource;Lnet/minecraft/world/level/ExplosionDamageCalculator;DDDFZLnet/minecraft/world/level/Explosion$BlockInteraction;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/particles/ParticleOptions;Lnet/minecraft/core/Holder;)V", at = @At("TAIL"))
    public void interposeExplosionBehavior(
            class_1937 level, 
            @Nullable class_1297 source, 
            @Nullable class_1282 damageSource, 
            @Nullable class_5362 damageCalculator, 
            double x, double y, double z, 
            float radius, boolean fire, 
            class_1927.class_4179 blockInteraction, 
            class_2394 smallExplosionParticles, class_2394 largeExplosionParticles, 
            class_6880<class_3414> explosionSound, 
            CallbackInfo ci
    ) {
        this.damageCalculator = new ExplosionDamageCalculatorInterceptor(this.damageCalculator, level);
    }
}
