package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_5454;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_3222.class)
public abstract class ServerPlayerMixin {

    // This is preferred to forge ItemTossEvent, because the forge event does delete the stack
    @Inject(method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    private void onDropItem(class_1799 stack, boolean b1, boolean b2, CallbackInfoReturnable<class_1542> cir) {
        class_3222 player = (class_3222) (Object) this;
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), ITEM_DROP, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                player.method_7270(stack);
                player.method_31548().method_5431();
                cir.setReturnValue(null);
            });
        }
    }

    @Inject(method = "changeDimension", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    private void onchangeDimension(class_5454 transition, CallbackInfoReturnable<class_1297> cir) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            RegionDataManager.initLevelDataOnChangeWorld(player, player.method_37908(), transition.comp_2820());

            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), USE_PORTAL_PLAYERS, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                cir.setReturnValue(null);
            });

            checkEvent = new FlagCheckEvent(player.method_24515(), ENTER_DIM, getDimKey(transition.comp_2820()), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                cir.setReturnValue(null);
            });
        }
    }
}