/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.commands.arguments.region;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.z0rdak.yawp.api.MessageSender;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2172;
import net.minecraft.class_2561;

public class RemoveRegionChildArgumentType
implements ArgumentType<String> {
    public static final Pattern VALID_NAME_PATTERN = Pattern.compile("^[A-Za-z]+[A-Za-z\\d\\-]+[A-Za-z\\d]+$");
    private static final Collection<String> EXAMPLES = Stream.of("spawn", "arena4pvp", "shop", "nether-hub").collect(Collectors.toSet());
    private static final SimpleCommandExceptionType ERROR_AREA_INVALID = new SimpleCommandExceptionType((Message)class_2561.method_48321((String)"cli.arg.region.parse.invalid", (String)"Unable to parse region name!"));
    private static final DynamicCommandExceptionType ERROR_INVALID_VALUE = new DynamicCommandExceptionType(flag -> class_2561.method_48322((String)"cli.arg.region.invalid", (String)"Region '%s' does not exist", (Object[])new Object[]{flag}));

    public static RemoveRegionChildArgumentType childRegions() {
        return new RemoveRegionChildArgumentType();
    }

    public String parse(StringReader reader) throws CommandSyntaxException {
        int i = reader.getCursor();
        while (reader.canRead() && String.valueOf(reader.peek()).matches(Pattern.compile("^[A-Za-z\\d\\-]$").pattern())) {
            reader.skip();
        }
        String s = reader.getString().substring(i, reader.getCursor());
        try {
            boolean isValidName = s.matches(VALID_NAME_PATTERN.pattern());
            if (isValidName) {
                return s;
            }
            throw new IllegalArgumentException("Invalid region name supplied");
        }
        catch (IllegalArgumentException argumentException) {
            reader.setCursor(i);
            Constants.LOGGER.error("Error parsing region name");
            throw ERROR_AREA_INVALID.createWithContext((ImmutableStringReader)reader);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        Object object = context.getSource();
        if (object instanceof class_2168) {
            class_2168 src = (class_2168)object;
            IMarkableRegion region = ArgumentUtil.getRegionArgument(context);
            List childNames = region.getChildren().values().stream().map(IProtectedRegion::getName).collect(Collectors.toList());
            if (childNames.isEmpty()) {
                if (src.method_43737()) {
                    MessageSender.overLayMessage((class_1657)src.method_44023(), class_2561.method_48322((String)"cli.arg.region.add.child.no-children", (String)"Region %s has no child regions.", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
                    return Suggestions.empty();
                }
                MessageSender.sendCmdFeedback(src, class_2561.method_48322((String)"cli.arg.region.add.child.no-children", (String)"Region %s has no child regions.", (Object[])new Object[]{ChatLinkBuilder.buildRegionInfoLink(region)}));
                return Suggestions.empty();
            }
            return class_2172.method_9265(childNames, (SuggestionsBuilder)builder);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

