/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.region;

import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.core.flag.RegionFlags;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.core.region.RegionType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_5321;

public abstract class ProtectedRegion
implements IProtectedRegion {
    protected class_5321<class_1937> dimension;
    protected IProtectedRegion parent;
    protected String parentName;
    private String name;
    private final RegionType regionType;
    private RegionFlags flags;
    private final Map<String, PlayerContainer> groups;
    private boolean isActive;
    private boolean isMuted;
    private final Map<String, IProtectedRegion> children;
    private final Set<String> childrenNames;

    protected ProtectedRegion(String name, class_5321<class_1937> dimension, RegionType type) {
        this.name = name;
        this.dimension = dimension;
        this.regionType = type;
        this.flags = new RegionFlags();
        this.groups = new HashMap<String, PlayerContainer>();
        this.groups.put("members", new PlayerContainer("members"));
        this.groups.put("owners", new PlayerContainer("owners"));
        this.children = new HashMap<String, IProtectedRegion>();
        this.isActive = true;
        this.childrenNames = new HashSet<String>();
    }

    protected ProtectedRegion(String name, class_5321<class_1937> dimension, RegionType regionType, class_1657 owner) {
        this(name, dimension, regionType);
        if (owner != null) {
            this.groups.get("owners").addPlayer(owner.method_5667(), owner.method_5820());
        }
    }

    @Override
    public String getParentName() {
        return this.parentName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public void setGroups(Map<String, PlayerContainer> groups) {
        this.groups.putAll(groups);
    }

    @Override
    public Map<String, PlayerContainer> getGroups() {
        return Collections.unmodifiableMap(this.groups);
    }

    @Override
    public class_5321<class_1937> getDim() {
        return this.dimension;
    }

    @Override
    public RegionType getRegionType() {
        return this.regionType;
    }

    @Override
    public void addFlag(IFlag flag) {
        this.flags.put(flag);
    }

    @Override
    public void removeFlag(String flag) {
        this.flags.remove(flag);
    }

    @Override
    public boolean containsFlag(RegionFlag flag) {
        return this.flags.contains(flag.name);
    }

    @Override
    public boolean containsFlag(String flag) {
        return this.flags.contains(flag);
    }

    @Override
    public void setFlags(RegionFlags flags) {
        this.flags = flags;
    }

    @Override
    public RegionFlags getFlags() {
        return this.flags;
    }

    @Override
    public IFlag getFlag(String flagName) {
        if (this.flags.contains(flagName)) {
            return this.flags.get(flagName);
        }
        return null;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.isActive = isActive;
    }

    @Override
    public boolean isMuted() {
        return this.isMuted;
    }

    @Override
    public void setIsMuted(boolean isMuted) {
        this.isMuted = isMuted;
    }

    @Override
    public void addPlayer(class_1657 player, String group) {
        this.getGroup(group).addPlayer(player.method_5667(), player.method_5820());
    }

    @Override
    public void addPlayer(UUID uuid, String playerName, String group) {
        this.getGroup(group).addPlayer(uuid, playerName);
    }

    @Override
    public void addTeam(String teamName, String group) {
        this.getGroup(group).addTeam(teamName);
    }

    @Override
    public void removeTeam(String teamName, String group) {
        this.getGroup(group).removeTeam(teamName);
    }

    @Override
    public void resetGroups() {
        this.groups.clear();
        this.groups.put("members", new PlayerContainer("members"));
        this.groups.put("owners", new PlayerContainer("owners"));
    }

    @Override
    public void removePlayer(UUID playerUuid, String group) {
        if (group.equals("*")) {
            for (String g : this.groups.keySet()) {
                this.getGroup(g).removePlayer(playerUuid);
            }
            return;
        }
        this.getGroup(group).removePlayer(playerUuid);
    }

    @Override
    public boolean hasTeam(String teamName, String group) {
        return this.getGroup(group).hasTeam(teamName);
    }

    @Override
    public boolean hasPlayer(UUID playerUuid, String group) {
        return this.getGroup(group).hasPlayer(playerUuid);
    }

    @Override
    public PlayerContainer getGroup(String group) {
        if (!this.groups.containsKey(group)) {
            return this.groups.put(group, new PlayerContainer(group));
        }
        return this.groups.get(group);
    }

    @Override
    public boolean permits(class_1657 player) {
        return this.isInGroup(player, "owners") || this.isInGroup(player, "members");
    }

    @Override
    public boolean isInGroup(class_1657 player, String group) {
        return this.groups.get(group).hasPlayer(player.method_5667()) || player.method_5781() != null && this.groups.get(group).hasTeam(player.method_5781().method_1197());
    }

    @Override
    public void removeChild(IProtectedRegion child) {
        this.children.remove(child.getName());
        this.childrenNames.remove(child.getName());
    }

    @Override
    public void clearChildren() {
        this.children.clear();
        this.childrenNames.clear();
    }

    public void setChildrenNames(List<String> childrenNames) {
        this.childrenNames.clear();
        this.childrenNames.addAll(childrenNames);
    }

    @Override
    public Map<String, IProtectedRegion> getChildren() {
        return Collections.unmodifiableMap(this.children);
    }

    @Override
    public Set<String> getChildrenNames() {
        return this.childrenNames;
    }

    @Override
    public boolean hasChild(IProtectedRegion maybeChild) {
        return this.children.containsKey(maybeChild.getName());
    }

    @Override
    public boolean addChild(IProtectedRegion child) {
        this.children.put(child.getName(), child);
        this.childrenNames.add(child.getName());
        ((ProtectedRegion)child).setParent(this);
        return true;
    }

    protected boolean setParent(IProtectedRegion parent) {
        this.parent = parent;
        this.parentName = parent.getName();
        return true;
    }

    @Override
    public IProtectedRegion getParent() {
        return this.parent;
    }
}

