/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.api.commands.Commands;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.ChatComponentBuilder;
import de.z0rdak.yawp.util.ChatLinkBuilder;
import de.z0rdak.yawp.util.text.Messages;
import de.z0rdak.yawp.util.text.messages.multiline.MultiLineMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2248;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class DisplaySettingsMessage
implements MultiLineMessage<BlockDisplayProperties> {
    private final IMarkableRegion region;
    private final List<class_2561> infoLines;

    public DisplaySettingsMessage(IMarkableRegion region) {
        this.region = region;
        this.infoLines = new ArrayList<class_2561>();
    }

    @Override
    public List<class_2561> getLines() {
        this.infoLines.clear();
        class_5250 header = ChatComponentBuilder.buildHeader(class_2561.method_48322((String)"cli.msg.info.header.of", (String)"== %s of %s ==", (Object[])new Object[]{ChatLinkBuilder.buildDisplaySettingsLink(this.region), ChatLinkBuilder.buildRegionInfoLink(this.region)}));
        class_5250 blockSubject = class_2561.method_48321((String)"cli.msg.info.region.display.block", (String)"Block");
        class_5250 glowSubject = class_2561.method_48321((String)"cli.msg.info.region.display.glow", (String)"Glow");
        class_5250 lightLevelSubject = class_2561.method_48321((String)"cli.msg.info.region.display.light-level", (String)"Light-Level");
        class_5250 blockComponent = ChatComponentBuilder.buildInfoComponent(blockSubject, DisplaySettingsMessage.buildDisplayBlockInfo(this.region), DisplaySettingsMessage.buildSetDisplayBlockLink(this.region));
        class_5250 glowActions = Messages.substitutable("%s %s", DisplaySettingsMessage.buildSetDisplayGlowOnLink(this.region), DisplaySettingsMessage.buildSetDisplayGlowOffLink(this.region));
        class_5250 glowComponent = ChatComponentBuilder.buildInfoComponent(glowSubject, DisplaySettingsMessage.buildDisplayGlowInfo(this.region), glowActions);
        class_5250 lightLevelComponent = ChatComponentBuilder.buildInfoComponent(lightLevelSubject, DisplaySettingsMessage.buildDisplayLightLevelInfo(this.region), DisplaySettingsMessage.buildSetDisplayLightLevelLink(this.region));
        this.infoLines.add((class_2561)header);
        this.infoLines.add((class_2561)blockComponent);
        this.infoLines.add((class_2561)glowComponent);
        this.infoLines.add((class_2561)lightLevelComponent);
        return this.infoLines;
    }

    @Override
    public BlockDisplayProperties getContent() {
        return this.region.getArea().getDisplay();
    }

    public static class_5250 buildDisplayBlockInfo(IMarkableRegion region) {
        class_5250 blockInfoHover = class_2561.method_43470((String)region.getArea().getDisplay().blockRl().toString());
        class_2248 block = (class_2248)class_7923.field_41175.method_10223(region.getArea().getDisplay().blockRl());
        class_5250 blockInfoText = block.method_9518();
        return ChatComponentBuilder.buildTextWithWhiteBracketsAndHover(blockInfoText, blockInfoHover, class_124.field_1078);
    }

    public static class_5250 buildSetDisplayBlockLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.display.block.link.text", (String)"set");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.display.block.link.hover", (String)"Set display block for area of %s", (Object[])new Object[]{region.getName()});
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayBlockCommand(region), class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }

    public static class_5250 buildDisplayGlowInfo(IMarkableRegion region) {
        boolean hasGlow = region.getArea().getDisplay().hasGlow();
        class_5250 text = hasGlow ? class_2561.method_48321((String)"cli.msg.info.region.display.glow-on.text", (String)"enabled") : class_2561.method_48321((String)"cli.msg.info.region.display.glow-off.text", (String)"disabled");
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.display.glow.hover", (String)"Glow effect for area display is %s", (Object[])new Object[]{hasGlow ? "enabled" : "disabled"});
        return ChatComponentBuilder.buildTextWithHoverMsg(text, hover, hasGlow ? class_124.field_1060 : class_124.field_1061);
    }

    public static class_5250 buildDisplayLightLevelInfo(IMarkableRegion region) {
        class_5250 text = class_2561.method_43470((String)String.valueOf(region.getArea().getDisplay().lightLevel()));
        class_5250 hover = class_2561.method_48322((String)"cli.msg.info.region.display.light-level.hover", (String)"Light level for area display is %s", (Object[])new Object[]{region.getArea().getDisplay().lightLevel()});
        return ChatComponentBuilder.buildTextWithHoverMsg(text, hover, class_124.field_1070);
    }

    public static class_5250 buildSetDisplayGlowOnLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.display.glow-on.link.text", (String)"on");
        class_5250 hover = class_2561.method_48321((String)"cli.msg.info.region.display.glow-on.link.hover", (String)"Enable glow effect for block display");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayGlowCommand(region, true), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildSetDisplayGlowOffLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.display.glow-off.link.text", (String)"off");
        class_5250 hover = class_2561.method_48321((String)"cli.msg.info.region.display.glow-off.link.hover", (String)"Disable glow effect for block display");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayGlowCommand(region, false), class_2558.class_2559.field_11750, Messages.LINK_COLOR);
    }

    public static class_5250 buildSetDisplayLightLevelLink(IMarkableRegion region) {
        class_5250 text = class_2561.method_48321((String)"cli.msg.info.region.display.light-level.link.text", (String)"set");
        class_5250 hover = class_2561.method_48321((String)"cli.msg.info.region.display.light-level.link.hover", (String)"Set light level for area display");
        return ChatComponentBuilder.buildExecuteCmdLinkWithBrackets(text, hover, Commands.buildSetDisplayLightLevelCommand(region), class_2558.class_2559.field_11745, Messages.LINK_COLOR);
    }
}

