package de.z0rdak.yawp.api.core;

import de.z0rdak.yawp.core.region.GlobalRegion;
import de.z0rdak.yawp.core.region.IProtectedRegion;
import de.z0rdak.yawp.data.region.LevelRegionData;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public interface IRegionManager {

    GlobalRegion getGlobalRegion();

    /**
     * This only resets the Global Region, not its child regions.
     */
    void resetGlobal();

    /**
     * You can safely cast the returned instance of to DimensionalRegion, but it doesn't provide any benefit.
     * @param dim the resource key of the dimension/level
     *      * @return the LevelRegionData corresponding to dim
     */
    Optional<IProtectedRegion> getDimensionalRegion(class_5321<class_1937> dim);

    /**
     * Gets the LevelRegionData for the specified dimension.
     * A LevelRegionData manages the DimensionalRegion and all Local Regions of the corresponding dimensions.
     * @param dim the resource key of the dimension/level
     * @return the LevelRegionData corresponding to dim
     */
    Optional<LevelRegionData> getLevelRegionData(class_5321<class_1937> dim);

    /**
     * Flag the scheduler to save the region data. This usually happens either 
     * - cyclic (when enabled) 
     * - when leaving the world (in single player) 
     * - shutting down the server gracefully 
     * - or executing the '/save-all' command.
     */
    void save();

    /**
     * Gets the DimensionalRegion API for the specified dimension key.
     *
     * @param dim the dimension key to get the API for
     * @return the DimensionalRegionApi for the specified dimension key if it exists, otherwise Optional.Empty
     */
    Optional<IDimensionRegionApi> getDimRegionApi(class_5321<class_1937> dim);

    /**
     * Gets the DimensionalRegion API for the specified dimension key (E.g. "minecraft:overworld").
     *
     * @param dimKey the dimension key to get the API for
     * @return the DimensionalRegionApi for the specified dimension key if it exists, otherwise Optional.Empty
     */
    Optional<IDimensionRegionApi> getDimRegionApiByKey(String dimKey);

    /**
     * Create the corresponding ResourceKey for the provided resource key string (e.g. 'minecraft:overworld')
     * Basically a wrapper around `ResourceKey.create(Registries.DIMENSION, ResourceLocation.parse(dimKey));`
     * @param dimKey resource key of the level/dimension
     * @return the corresponding ResourceKey for the level/dimension
     */
    class_5321<class_1937> getDimApiKey(String dimKey);

    /**
     * Check whether a DimensionalRegion for the specified dimension already exists.
     *
     * @param dim the dimension key to check for
     * @return true if a DimensionalRegion exists, false otherwise
     */
    boolean hasLevelData(class_5321<class_1937> dim);

    /**
     * Creates a new DimensionalRegionCache (and DimensionalRegion) for the specified dimension.
     *
     * @param dim the dimension identifier of the dimension
     * @return true if a new DimensionalRegionCache was created, false if it already existed
     */
    boolean createDimRegion(class_5321<class_1937> dim);

    /**
     * Returns a set of resource keys for all created Dimensional Regions
     * @return a set of resource keys corresponding to registered DimensionalRegions
     */
    Set<class_2960> getLevels();

    /**
     * Resets the DimensionalRegion as well as all LocalRegions of the corresponding level.
     * @param dim the resource key of the level/dimension you want to reset its corresponding data for.
     */
    void resetLevelData(class_5321<class_1937> dim);
}
