package de.z0rdak.yawp.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.z0rdak.yawp.api.commands.CommandConstants;
import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.commands.arguments.ArgumentUtil;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.util.text.Messages;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

import static de.z0rdak.yawp.util.ChatComponentBuilder.buildHeader;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildHelpStartComponent;
import static de.z0rdak.yawp.util.ChatLinkBuilder.buildWikiLink;
import static de.z0rdak.yawp.api.MessageSender.sendCmdFeedback;

public final class CommandRegistry {

    private CommandRegistry() {
    }

    public static void registerCommands(CommandDispatcher<class_2168> cmdDispatcher, class_7157 registryAccess, class_2170.class_5364 env) {
        if (env == class_2170.class_5364.field_25420 || env == class_2170.class_5364.field_25421) {
            try {
                LiteralArgumentBuilder<class_2168> modCmds = buildCommands();
                cmdDispatcher.register(modCmds);
            }
            catch (Exception e) {
                // Nothing to do here. Since multi project structure was introduced,
                // the config loads differently and will need more than one attempt to register the commands
            }
        }
    }

    private static LiteralArgumentBuilder<class_2168> buildCommands() {
        return class_2170.method_9247(Constants.MOD_ID)
                .requires(Permissions.get()::isAllowedForNonOp)
                .executes(ctx -> promptHelp(ctx.getSource()))
                .then(ArgumentUtil.literal(CommandConstants.HELP)
                        .executes(ctx -> promptHelp(ctx.getSource())))
                .then(FlagCommands.build())
                .then(MarkerCommands.build())
                .then(GlobalCommands.build())
                .then(DimensionCommands.build())
                .then(RegionCommands.build())
                .then(ShortcutCommands.buildShow())
                .then(ShortcutCommands.buildHide())
                .then(ShortcutCommands.buildInfoLocal())
                .then(ShortcutCommands.buildCreateLocal())
                .then(ShortcutCommands.buildDeleteLocal());
    }

    private static int promptHelp(class_2168 src) {
        sendCmdFeedback(src, buildHeader(class_2561.method_48321("help.header", "== Yet Another World Protector - Help ==")));
        class_5250 wikiHint = class_2561.method_48321("help.tooltip.wiki.detail", "The in-game help is under construction. Visit the online wiki for a guide on how to use the mod.");
        class_5250 wikiText = class_2561.method_48321("help.tooltip.wiki", "Online-Wiki");
        sendCmdFeedback(src, wikiHint);
        sendCmdFeedback(src, Messages.substitutable("%s: %s", wikiText, buildWikiLink()));
        sendCmdFeedback(src, Messages.substitutable(" => %s", buildHelpStartComponent()));
        return 0;
    }
}
