package de.z0rdak.yawp.core.area;

import de.z0rdak.yawp.util.AreaUtil;
import org.apache.commons.lang3.NotImplementedException;

import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2382;

import static de.z0rdak.yawp.util.AreaUtil.distanceManhattan;
import static de.z0rdak.yawp.util.AreaUtil.length;

/**
 * Vertical, cylindrical area defined by the bottom center position and a perimeter position.
 * The perimeter position defines both the height and radius of the area.
 */
public class VerticalCylinderArea extends CenteredArea {

    private final class_2338 centerTopPos;
    private final int distance;
    private final int radius;

    public VerticalCylinderArea(class_2338 centerBottomPos, class_2338 scopePos) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = new class_2338(centerBottomPos.method_10263(), scopePos.method_10264(), centerBottomPos.method_10260());
        this.radius = distanceManhattan(centerBottomPos, new class_2338(scopePos.method_10263(), centerBottomPos.method_10264(), scopePos.method_10260()));
        this.distance = distanceManhattan(centerBottomPos, this.centerTopPos);
    }

    public VerticalCylinderArea(class_2338 centerBottomPos, int radius, int distance) {
        super(centerBottomPos, AreaType.CYLINDER);
        this.centerTopPos = centerBottomPos.method_10069(0, distance, 0);
        this.radius = radius;
        this.distance = distance;
    }

    public class_2382 getCenter() {
        return new class_2382(this.center.method_10263(), this.center.method_10264(), this.center.method_10260());
    }

    /***
     * <a href="https://stackoverflow.com/questions/47932955/how-to-check-if-a-3d-point-is-inside-a-cylinder">...</a>
     * @param pos
     * @return
     */
    @Override
    public boolean contains(class_2338 pos) {
        class_2338 dist = centerTopPos.method_10059(center);
        boolean b1 = multiply(pos.method_10059(center), dist).method_10265(class_2338.field_10980) >= 0;
        boolean b2 = multiply(pos.method_10059(centerTopPos), dist).method_10265(class_2338.field_10980) <= 0;
        boolean isBetweenPlanes = b1 && b2;
        class_2338 crossProduct = pos.method_10059(center).method_10075(dist);
        double distance = length(crossProduct) / distanceManhattan(centerTopPos, center);
        boolean isInsideSurface = distance <= radius;
        return isBetweenPlanes && isInsideSurface;
    }

    @Override
    public Set<class_2338> getHull() {
        throw new NotImplementedException("CylinderArea.getHull() not implemented yet");
    }

    @Override
    public Set<class_2338> getFrame() {
        return Set.of();
    }

    @Override
    public Set<class_2338> getMinimalOutline() {
        return Set.of();
    }

    public int getDistance() {
        return distance;
    }

    public int getRadius() {
        return radius;
    }

    public class_2338 multiply(class_2338 p1, class_2338 p2) {
        return new class_2338(p1.method_10263() * p2.method_10263(), p1.method_10264() * p2.method_10264(), p1.method_10260() * p2.method_10260());
    }

    @Override
    public boolean containsOther(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        throw new NotImplementedException("Not yet implemented");
    }

    @Override
    public MarkedAreaType<?> getType() {
        return null;
    }

    // Cylinder [x,y,z] with radius r and height h
    @Override
    public String toString() {
        return "Cylinder " + AreaUtil.blockPosStr(this.center) + " with radius " + this.radius + " and height " + this.distance + ".";
    }
}
