package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1657;
import net.minecraft.class_1671;
import net.minecraft.class_1676;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;
import static de.z0rdak.yawp.core.flag.RegionFlag.NO_PVP;
import static de.z0rdak.yawp.core.flag.RegionFlag.SPAWN_PORTAL;
import static de.z0rdak.yawp.handler.HandlerUtil.getDimKey;
import static de.z0rdak.yawp.handler.HandlerUtil.isServerSide;

@Mixin(class_1671.class)
public class FireworkRocketEntityMixin {


    @Inject(method = "onHitEntity", at = @At(value = "HEAD"), cancellable = true)
    private void onHitPlayer(class_3966 result, CallbackInfo info) {
        if (isServerSide(result.method_17782().method_37908())) {
            class_1676 fwr = (class_1676) (Object) this;
            if (fwr.method_24921() instanceof class_1657 shooter && result.method_17782() instanceof class_1657 target) {
                FlagCheckEvent checkEvent = new FlagCheckEvent(target.method_24515(), NO_PVP, getDimKey(result.method_17782().method_37908()), shooter);
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, deny -> {
                    info.cancel();
                    sendFlagMsg(deny);
                });
            }
        }
    }
}
