package de.z0rdak.yawp.mixin.flag;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.class_1606;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import static de.z0rdak.yawp.core.flag.RegionFlag.SHULKER_TELEPORT_FROM_REGION;
import static de.z0rdak.yawp.handler.HandlerUtil.*;

@Mixin(class_1606.class)
public abstract class ShulkerEntityMixin {
    @Inject(method = "teleportSomewhere", at = @At(value = "HEAD"), cancellable = true, allow = 1)
    public void onShulkerTeleport(CallbackInfoReturnable<Boolean> cir) {
        class_1606 self = (class_1606) (Object) this;
        if (isServerSide(self.method_37908())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(self.method_24515(), SHULKER_TELEPORT_FROM_REGION, getDimKey(self));
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> cir.setReturnValue(false));
        }
    }
}
