package de.z0rdak.yawp.mixin.flag.player;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.data.region.RegionDataManager;
import de.z0rdak.yawp.platform.Services;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5454;

import static de.z0rdak.yawp.core.flag.RegionFlag.*;
import static de.z0rdak.yawp.handler.HandlerUtil.*;
import static de.z0rdak.yawp.api.MessageSender.sendFlagMsg;

@Mixin(class_3222.class)
public abstract class ServerPlayerMixin {

    // This is preferred to forge ItemTossEvent, because the forge event does delete the stack
    @Inject(method = "drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    private void onDropItem(class_1799 stack, boolean b1, boolean b2, CallbackInfoReturnable<class_1542> cir) {
        class_3222 player = (class_3222) (Object) this;
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), ITEM_DROP, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                player.method_7270(stack);
                player.method_31548().method_5431();
                cir.setReturnValue(null);
            });
        }
    }

    @Inject(method = "teleport(Lnet/minecraft/world/level/portal/TeleportTransition;)Lnet/minecraft/server/level/ServerPlayer;", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    private void onChangeDimension(class_5454 teleportTransition, CallbackInfoReturnable<class_1297> cir) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            RegionDataManager.initLevelDataOnChangeWorld(player, player.method_37908(), teleportTransition.comp_2820());

            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), USE_PORTAL_PLAYERS, getDimKey(player), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                cir.setReturnValue(null);
            });

            checkEvent = new FlagCheckEvent(player.method_24515(), ENTER_DIM, getDimKey(teleportTransition.comp_2820()), player);
            if (Services.EVENT.post(checkEvent))
                return;
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                cir.setReturnValue(null);
            });
        }
    }

    @Inject(method = "teleportTo(Lnet/minecraft/server/level/ServerLevel;DDDLjava/util/Set;FFZ)Z", at = @At(value = "HEAD"), allow = 1, cancellable = true)
    private void onTeleportToDimension(class_3218 level, double x, double y, double z, Set<class_2709> relativeMovements, float yaw, float pitch, boolean setCamera, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657) (Object) this;
        if (isServerSide(player)) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(player.method_24515(), USE_PORTAL_PLAYERS, player.method_37908().method_27983(), player);
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                sendFlagMsg(deny);
                cir.setReturnValue(false);
            });
        }
    }
}
