package de.z0rdak.yawp.util;

import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class NbtCompatHelper {
	public static Optional<class_2338> toBlockPosFromCompound(class_2487 nbt, String key) {
        if (nbt.method_10540(key) == class_2520.field_33260) {
    		return readBlockPosFromCompound(nbt.method_10562(key));
        }
		return Optional.empty();
	}

    private static Optional<class_2338> readBlockPosFromCompound(class_2487 nbt) {
        return Optional.of(new class_2338(nbt.method_10550("X"), nbt.method_10550("Y"), nbt.method_10550("Z")));
    }
	
	public static Optional<class_2338> toBlockPos(class_2487 nbt, String key) {
        Optional <class_2338> blockPos = class_2512.method_10691(nbt, key);
        if (blockPos.isEmpty()) {
        	blockPos = toBlockPosFromCompound(nbt, key);
        }
        return blockPos;
    }

    public static Optional<class_2338> toBlockPos(class_2495 nbt) {
        int[] is = nbt.method_10588();
        if (is.length == 3) {
            return Optional.of(new class_2338(is[0], is[1], is[2]));
        }
        return Optional.empty();

    }
	
}
