package de.z0rdak.yawp.util.text.messages.multiline;

import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.util.text.Messages;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

import static de.z0rdak.yawp.api.commands.Commands.*;
import static de.z0rdak.yawp.util.ChatComponentBuilder.*;
import static de.z0rdak.yawp.util.ChatComponentBuilder.buildInfoComponent;
import static de.z0rdak.yawp.util.ChatLinkBuilder.*;
import static de.z0rdak.yawp.util.text.Messages.LINK_COLOR;
import static net.minecraft.class_124.*;
import static net.minecraft.class_124.field_1070;
import static net.minecraft.class_2558.class_2559.field_11750;
import static net.minecraft.class_2558.class_2559.field_11745;

public class DisplaySettingsMessage implements MultiLineMessage<BlockDisplayProperties> {

    private final IMarkableRegion region;
    private final List<class_2561> infoLines;

    public DisplaySettingsMessage(IMarkableRegion region) {
        this.region = region;
        this.infoLines = new ArrayList<>();
    }

    /**
     *  == Display Settings for [region]  == <br>
     * Block: [minecraft:cyan_stained_glass] | [set] <br>
     * Glow: enabled | [on] [off] <br>
     * Light-Level: 15 | [set] <br>
     */
    @Override
    public List<class_2561> getLines() {
        infoLines.clear();
        var header = buildHeader(class_2561.method_48322("cli.msg.info.header.of", "== %s of %s ==", buildDisplaySettingsLink(region), buildRegionInfoLink(region)));
        var blockSubject = class_2561.method_48321("cli.msg.info.region.display.block", "Block");
        var glowSubject = class_2561.method_48321("cli.msg.info.region.display.glow", "Glow");
        var lightLevelSubject = class_2561.method_48321("cli.msg.info.region.display.light-level", "Light-Level");

        var blockComponent = buildInfoComponent(blockSubject, buildDisplayBlockInfo(region), buildSetDisplayBlockLink(region));
        var glowActions = Messages.substitutable("%s %s", buildSetDisplayGlowOnLink(region), buildSetDisplayGlowOffLink(region));
        var glowComponent = buildInfoComponent(glowSubject, buildDisplayGlowInfo(region), glowActions);
        var lightLevelComponent = buildInfoComponent(lightLevelSubject, buildDisplayLightLevelInfo(region), buildSetDisplayLightLevelLink(region));

        infoLines.add(header);
        infoLines.add(blockComponent);
        infoLines.add(glowComponent);
        infoLines.add(lightLevelComponent);
        return infoLines;
    }

    @Override
    public BlockDisplayProperties getContent() {
        return region.getArea().getDisplay();
    }

    /**
     *  [Cyan Stained Glass] { Hover: minecraft:cyan_stained_glass }
     */
    public static class_5250 buildDisplayBlockInfo(IMarkableRegion region) {
        var blockInfoHover = class_2561.method_43470(region.getArea().getDisplay().blockRl().toString());
        Optional<class_6880.class_6883<class_2248>> block = class_7923.field_41175.method_10223(region.getArea().getDisplay().blockRl());
        if (block.isPresent()) {
            var blockInfoText = block.get().comp_349().method_9518();
            return buildTextWithWhiteBracketsAndHover(blockInfoText, blockInfoHover, field_1078);
        }
        throw new IllegalStateException("BlockRl '" + region.getArea().getDisplay().blockRl().toString() + "' in region " + region.getName() + " is invalid.");
    }

    public static class_5250 buildSetDisplayBlockLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.display.block.link.text", "set");
        var hover = class_2561.method_48322("cli.msg.info.region.display.block.link.hover", "Set display block for area of %s", region.getName());
        return buildExecuteCmdLinkWithBrackets(text, hover, buildSetDisplayBlockCommand(region), field_11745, LINK_COLOR);
    }

    /**
     * enabled { Hover: Glow effect for area display is [] }
     */
    public static class_5250 buildDisplayGlowInfo(IMarkableRegion region) {
        boolean hasGlow = region.getArea().getDisplay().hasGlow();
        var text = hasGlow
                ? class_2561.method_48321("cli.msg.info.region.display.glow-on.text", "enabled")
                : class_2561.method_48321("cli.msg.info.region.display.glow-off.text", "disabled");
        var hover = class_2561.method_48322("cli.msg.info.region.display.glow.hover",
                "Glow effect for area display is %s", hasGlow ? "enabled" : "disabled");
        return buildTextWithHoverMsg(text, hover, hasGlow ? field_1060 : field_1061);
    }

    public static class_5250 buildDisplayLightLevelInfo(IMarkableRegion region) {
        var text = class_2561.method_43470(String.valueOf(region.getArea().getDisplay().lightLevel()));
        var hover = class_2561.method_48322("cli.msg.info.region.display.light-level.hover",
                "Light level for area display is %s", region.getArea().getDisplay().lightLevel());
        return buildTextWithHoverMsg(text, hover, field_1070);
    }

    public static class_5250 buildSetDisplayGlowOnLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.display.glow-on.link.text", "on");
        var hover = class_2561.method_48321("cli.msg.info.region.display.glow-on.link.hover", "Enable glow effect for block display");
        return buildExecuteCmdLinkWithBrackets(text, hover, buildSetDisplayGlowCommand(region, true), field_11750, LINK_COLOR);
    }

    public static class_5250 buildSetDisplayGlowOffLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.display.glow-off.link.text", "off");
        var hover = class_2561.method_48321("cli.msg.info.region.display.glow-off.link.hover", "Disable glow effect for block display");
        return buildExecuteCmdLinkWithBrackets(text, hover, buildSetDisplayGlowCommand(region, false), field_11750, LINK_COLOR);
    }

    public static class_5250 buildSetDisplayLightLevelLink(IMarkableRegion region) {
        var text = class_2561.method_48321("cli.msg.info.region.display.light-level.link.text", "set");
        var hover = class_2561.method_48321("cli.msg.info.region.display.light-level.link.hover", "Set light level for area display");
        return buildExecuteCmdLinkWithBrackets(text, hover, buildSetDisplayLightLevelCommand(region), field_11745, LINK_COLOR);
    }
}
