/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import de.z0rdak.yawp.api.visualization.VisualizationUtil;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2960;

public class RegionVisualization {
    private final Map<class_2338, class_1297> displayEntities = new HashMap<class_2338, class_1297>();
    private BlockDisplayProperties properties;

    public BlockDisplayProperties getProperties() {
        return this.properties;
    }

    public RegionVisualization(BlockDisplayProperties properties) {
        this.properties = properties;
    }

    public boolean doesTrackEntityAt(class_2338 pos) {
        return this.displayEntities.containsKey(pos);
    }

    public void trackBlockDisplay(class_2338 pos, class_1297 entity) {
        this.displayEntities.put(pos, entity);
    }

    public void updateDisplay(BlockDisplayProperties displayProperties, boolean refresh) {
        this.properties = displayProperties;
        if (refresh) {
            this.refresh(displayProperties);
        }
    }

    private void refresh(BlockDisplayProperties properties) {
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayProperties(entity, properties));
    }

    public boolean hasEntitiesTracked() {
        return !this.displayEntities.isEmpty();
    }

    public void discardEntities() {
        this.displayEntities.forEach((pos, entity) -> entity.method_5650(class_1297.class_5529.field_26999));
        this.displayEntities.clear();
    }

    public void updateBlock(class_2960 block) {
        this.properties.setBlockRl(block);
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayBlock(entity, block));
    }

    public void updateGlow(boolean glow) {
        this.properties.setHasGlow(glow);
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayGlow(entity, glow));
    }

    public void updateLightLevel(int lightLevel) {
        this.properties.setLightLevel(lightLevel);
        this.displayEntities.forEach((pos, entity) -> VisualizationUtil.updateDisplayLightLevel(entity, lightLevel));
    }
}

