/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.visualization;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.TextDisplayProperties;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.phys.Vec3;

public final class VisualizationUtil {
    private VisualizationUtil() {
    }

    public static void updateDisplayBlock(Entity blockDisplayEntity, ResourceLocation blockRl) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        try {
            EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
            CompoundTag entityTag = entityDataAccessor.getData();
            CompoundTag blockState = (CompoundTag)entityTag.getCompound("block_state").get();
            blockState.putString("Name", blockRl.toString());
            entityTag.put("block_state", (Tag)blockState);
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayGlow(Entity blockDisplayEntity, boolean glow) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.getData();
        entityTag.putBoolean("Glowing", glow);
        try {
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayLightLevel(Entity blockDisplayEntity, int lightLevel) {
        if (!(blockDisplayEntity instanceof Display.BlockDisplay)) {
            throw new IllegalArgumentException("BlockDisplay entity is not a Display.BlockDisplay");
        }
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        CompoundTag entityTag = entityDataAccessor.getData();
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", lightLevel);
        brightnessTag.putInt("block", lightLevel);
        entityTag.put("brightness", (Tag)brightnessTag);
        try {
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void initTextDisplayProperties(Entity blockDisplayEntity, String regionName, TextDisplayProperties properties) {
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        try {
            CompoundTag entityTag = VisualizationUtil.buildTeleportAnchorTextDisplayTag(regionName, properties);
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void initBlockDisplayProperties(Entity blockDisplayEntity, String regionName, BlockDisplayProperties properties) {
        EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
        try {
            CompoundTag blockDisplayTag = VisualizationUtil.buildBlockDisplayTag(regionName, properties);
            CompoundTag existingTag = entityDataAccessor.getData();
            existingTag.put("block_state", (Tag)blockDisplayTag.getCompound("block_state").get());
            existingTag.put("brightness", (Tag)blockDisplayTag.getCompound("brightness").get());
            existingTag.put("data", (Tag)blockDisplayTag.getCompound("data").get());
            existingTag.putString("id", (String)blockDisplayTag.getString("id").get());
            existingTag.putBoolean("Glowing", ((Boolean)blockDisplayTag.getBoolean("Glowing").get()).booleanValue());
            entityDataAccessor.setData(existingTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void updateDisplayProperties(Entity blockDisplayEntity, BlockDisplayProperties properties) {
        try {
            EntityDataAccessor entityDataAccessor = new EntityDataAccessor(blockDisplayEntity);
            CompoundTag entityTag = entityDataAccessor.getData();
            CompoundTag blockState = (CompoundTag)entityTag.getCompound("block_state").get();
            blockState.putString("Name", properties.blockRl().toString());
            entityTag.put("block_state", (Tag)blockState);
            entityTag.putBoolean("Glowing", properties.hasGlow());
            CompoundTag brightnessTag = new CompoundTag();
            brightnessTag.putInt("sky", properties.lightLevel());
            brightnessTag.putInt("block", properties.lightLevel());
            entityTag.put("brightness", (Tag)brightnessTag);
            entityDataAccessor.setData(entityTag);
        }
        catch (CommandSyntaxException e) {
            Constants.LOGGER.error("Should not happend - what did you do?!", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static Optional<Entity> createTextDisplayEntity(ServerLevel level, String regionName, BlockPos pos, TextDisplayProperties displayProperties) {
        Display.BlockDisplay textDisplay = (Display.BlockDisplay)EntityType.BLOCK_DISPLAY.create(level, e -> VisualizationUtil.initTextDisplayProperties((Entity)e, regionName, displayProperties), pos, EntitySpawnReason.COMMAND, false, false);
        return textDisplay == null ? Optional.empty() : Optional.of(textDisplay);
    }

    public static Optional<Entity> createBlockDisplayEntity(ServerLevel level, String regionName, BlockPos pos, BlockDisplayProperties displayProperties) {
        Entity blockDisplay = EntityType.BLOCK_DISPLAY.create(level, e -> {
            VisualizationUtil.initBlockDisplayProperties((Entity)e, regionName, displayProperties);
            e.moveOrInterpolateTo(new Vec3((Vec3i)pos), 0.0f, 0.0f);
        }, pos, EntitySpawnReason.COMMAND, false, false);
        return blockDisplay == null ? Optional.empty() : Optional.of(blockDisplay);
    }

    public static CompoundTag buildTeleportAnchorTextDisplayTag(String regionName, TextDisplayProperties properties) {
        CompoundTag textDisplayTag = new CompoundTag();
        ResourceLocation blockDisplayRl = ResourceLocation.withDefaultNamespace((String)"text_display");
        textDisplayTag.putString("id", blockDisplayRl.toString());
        CompoundTag data = new CompoundTag();
        data.putString("yawp_display", "text");
        data.putString("region", regionName);
        data.putString("tpAnchor", properties.getText());
        textDisplayTag.put("data", (Tag)data);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", 15);
        brightnessTag.putInt("block", 15);
        textDisplayTag.put("brightness", (Tag)brightnessTag);
        textDisplayTag.putString("billboard", "center");
        MutableComponent text = Component.literal((String)properties.toString());
        textDisplayTag.putString("text", text.toString());
        textDisplayTag.putString("alignment", "center");
        textDisplayTag.putInt("background", 0x1A000000);
        return textDisplayTag;
    }

    public static CompoundTag buildBlockDisplayTag(String regionName, BlockDisplayProperties properties) {
        CompoundTag blockDisplayTag = new CompoundTag();
        ResourceLocation blockDisplayRl = ResourceLocation.withDefaultNamespace((String)"block_display");
        blockDisplayTag.putString("id", blockDisplayRl.getPath());
        blockDisplayTag.putBoolean("Glowing", properties.hasGlow());
        CompoundTag data = new CompoundTag();
        data.putString("yawp_display", "block");
        data.putString("region", regionName);
        blockDisplayTag.put("data", (Tag)data);
        CompoundTag brightnessTag = new CompoundTag();
        brightnessTag.putInt("sky", properties.lightLevel());
        brightnessTag.putInt("block", properties.lightLevel());
        blockDisplayTag.put("brightness", (Tag)brightnessTag);
        CompoundTag blockstateTag = new CompoundTag();
        blockstateTag.putString("Name", properties.blockRl().toString());
        blockDisplayTag.put("block_state", (Tag)blockstateTag);
        return blockDisplayTag;
    }
}

