/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.core.area;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.area.BlockDisplayProperties;
import de.z0rdak.yawp.core.area.IMarkableArea;
import de.z0rdak.yawp.core.area.MarkedArea;
import de.z0rdak.yawp.core.area.MarkedAreaType;
import de.z0rdak.yawp.core.area.MarkedAreaTypes;
import de.z0rdak.yawp.core.area.SphereArea;
import de.z0rdak.yawp.util.AreaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import org.apache.commons.lang3.NotImplementedException;

public class CuboidArea
extends MarkedArea {
    public static MapCodec<CuboidArea> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BlockPos.CODEC.fieldOf("p1").forGetter(CuboidArea::getAreaP1), (App)BlockPos.CODEC.fieldOf("p2").forGetter(CuboidArea::getAreaP2), (App)Codec.STRING.fieldOf("areaType").forGetter(r -> MarkedAreaTypes.areaIdentifier(r.getAreaType()).toString()), (App)BlockDisplayProperties.CODEC.fieldOf("display").forGetter(MarkedArea::getDisplay)).apply((Applicative)instance, (p1, p2, area, display) -> {
        CuboidArea cuboid = new CuboidArea((BlockPos)p1, (BlockPos)p2);
        cuboid.updateDisplay((BlockDisplayProperties)display);
        return cuboid;
    }));
    private BoundingBox area;
    private BlockPos p1;
    private BlockPos p2;

    @Override
    public MarkedAreaType<?> getType() {
        return MarkedAreaTypes.CUBOID_AREA;
    }

    public CuboidArea(BoundingBox area) {
        super(AreaType.CUBOID);
        this.area = area;
    }

    public CuboidArea(BlockPos p1, BlockPos p2) {
        this(BoundingBox.fromCorners((Vec3i)p1, (Vec3i)p2));
        this.p1 = AreaUtil.getLowerPos(p1, p2);
        this.p2 = AreaUtil.getHigherPos(p1, p2);
    }

    public static CuboidArea expand(CuboidArea area, int min, int max) {
        BlockPos p1 = area.getAreaP1();
        BlockPos p2 = area.getAreaP2();
        CuboidArea expanded = new CuboidArea(new BlockPos(p1.getX(), min, p1.getZ()), new BlockPos(p2.getX(), max, p2.getZ()));
        expanded.updateDisplay(area.getDisplay());
        return expanded;
    }

    private static boolean isInFacePlane(BlockPos point, BlockPos corner1, BlockPos corner2, BlockPos corner3, BlockPos corner4) {
        return point.getX() >= corner1.getX() && point.getX() <= corner2.getX() && point.getY() >= corner1.getY() && point.getY() <= corner3.getY() && point.getZ() >= corner1.getZ() && point.getZ() <= corner4.getZ();
    }

    private static List<BlockPos> getBlocksInFace(BlockPos corner1, BlockPos corner2, BlockPos corner3, BlockPos corner4) {
        ArrayList<BlockPos> blocksInFace = new ArrayList<BlockPos>();
        int minX = Math.min(Math.min(corner1.getX(), corner2.getX()), Math.min(corner3.getX(), corner4.getX()));
        int minY = Math.min(Math.min(corner1.getY(), corner2.getY()), Math.min(corner3.getY(), corner4.getY()));
        int minZ = Math.min(Math.min(corner1.getZ(), corner2.getZ()), Math.min(corner3.getZ(), corner4.getZ()));
        int maxX = Math.max(Math.max(corner1.getX(), corner2.getX()), Math.max(corner3.getX(), corner4.getX()));
        int maxY = Math.max(Math.max(corner1.getY(), corner2.getY()), Math.max(corner3.getY(), corner4.getY()));
        int maxZ = Math.max(Math.max(corner1.getZ(), corner2.getZ()), Math.max(corner3.getZ(), corner4.getZ()));
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    if (!CuboidArea.isInFacePlane(currentPos, corner1, corner2, corner3, corner4)) continue;
                    blocksInFace.add(currentPos);
                }
            }
        }
        return blocksInFace;
    }

    @Override
    public boolean contains(BlockPos pos) {
        return pos.getX() >= this.area.minX() && pos.getX() <= this.area.maxX() && pos.getY() >= this.area.minY() && pos.getY() <= this.area.maxY() && pos.getZ() >= this.area.minZ() && pos.getZ() <= this.area.maxZ();
    }

    public boolean contains(CuboidArea inner) {
        return this.area.minX() <= inner.area.minX() && this.area.maxX() >= inner.area.maxX() && this.area.minY() <= inner.area.minY() && this.area.maxY() >= inner.area.maxY() && this.area.minZ() <= inner.area.minZ() && this.area.maxZ() >= inner.area.maxZ();
    }

    public boolean contains(SphereArea inner) {
        int sphereRadius = inner.getRadius();
        BlockPos center = inner.center;
        if (!this.intersects(inner)) {
            return false;
        }
        int maxDistanceToCorner = this.maxDistanceToCorners(center);
        if (maxDistanceToCorner > sphereRadius) {
            return false;
        }
        for (int x = center.getX() - sphereRadius; x <= center.getX() + sphereRadius; ++x) {
            for (int y = center.getY() - sphereRadius; y <= center.getY() + sphereRadius; ++y) {
                for (int z = center.getZ() - sphereRadius; z <= center.getZ() + sphereRadius; ++z) {
                    BlockPos currentPos = new BlockPos(x, y, z);
                    int distance = AreaUtil.distanceManhattan(center, currentPos);
                    if (distance > sphereRadius || this.contains(currentPos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private int maxDistanceToCorners(BlockPos center) {
        List<BlockPos> corners = this.getVertices();
        int maxDistance = Integer.MIN_VALUE;
        for (BlockPos corner : corners) {
            int distance = AreaUtil.distanceManhattan(center, corner);
            if (distance <= maxDistance) continue;
            maxDistance = distance;
        }
        return maxDistance;
    }

    public List<BlockPos> getVertices() {
        BlockPos p1 = new BlockPos(this.area.minX(), this.area.minY(), this.area.minZ());
        BlockPos p2 = new BlockPos(this.area.maxX(), this.area.minY(), this.area.minZ());
        BlockPos p3 = new BlockPos(this.area.minX(), this.area.minY(), this.area.maxZ());
        BlockPos p4 = new BlockPos(this.area.maxX(), this.area.minY(), this.area.maxZ());
        BlockPos p5 = new BlockPos(this.area.minX(), this.area.maxY(), this.area.minZ());
        BlockPos p6 = new BlockPos(this.area.maxX(), this.area.maxY(), this.area.minZ());
        BlockPos p7 = new BlockPos(this.area.minX(), this.area.maxY(), this.area.maxZ());
        BlockPos p8 = new BlockPos(this.area.maxX(), this.area.maxY(), this.area.maxZ());
        return Arrays.asList(p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    public Set<BlockPos> getHull() {
        List<BlockPos> vertices = this.getVertices();
        List<BlockPos> face1 = CuboidArea.getBlocksInFace(vertices.get(0), vertices.get(1), vertices.get(2), vertices.get(3));
        List<BlockPos> face2 = CuboidArea.getBlocksInFace(vertices.get(4), vertices.get(5), vertices.get(6), vertices.get(7));
        List<BlockPos> face3 = CuboidArea.getBlocksInFace(vertices.get(0), vertices.get(2), vertices.get(4), vertices.get(6));
        List<BlockPos> face4 = CuboidArea.getBlocksInFace(vertices.get(1), vertices.get(3), vertices.get(5), vertices.get(7));
        List<BlockPos> face5 = CuboidArea.getBlocksInFace(vertices.get(0), vertices.get(1), vertices.get(4), vertices.get(5));
        List<BlockPos> face6 = CuboidArea.getBlocksInFace(vertices.get(2), vertices.get(3), vertices.get(6), vertices.get(7));
        return Stream.of(face1, face2, face3, face4, face5, face6).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private boolean intersects(CuboidArea other) {
        return this.area.intersects(other.area);
    }

    public boolean intersects(SphereArea other) {
        return other.intersects(this);
    }

    public BoundingBox getArea() {
        return this.area;
    }

    public int getXsize() {
        return Math.max(this.area.getXSpan(), 1);
    }

    public int getZsize() {
        return Math.max(this.area.getZSpan(), 1);
    }

    public int getYsize() {
        return Math.max(this.area.getYSpan(), 1);
    }

    public BlockPos getAreaP1() {
        return this.p1;
    }

    public BlockPos getAreaP2() {
        return this.p2;
    }

    public String toString() {
        return this.getAreaType().areaType + " " + AreaUtil.blockPosStr(this.p1) + " <-> " + AreaUtil.blockPosStr(this.p2) + "\nSize: X=" + this.getXsize() + ", Y=" + this.getYsize() + ", Z=" + this.getZsize() + "\nBlocks: " + AreaUtil.blockPosStr(this.p1) + ", " + AreaUtil.blockPosStr(this.p2);
    }

    @Override
    public Set<BlockPos> markedBlocks() {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        set.add(this.p1);
        set.add(this.p2);
        return set;
    }

    @Override
    public Set<BlockPos> getFrame() {
        List<BlockPos> vertices = this.getVertices();
        Set<BlockPos> p12 = AreaUtil.blocksBetweenOnAxis(vertices.get(0), vertices.get(1), Direction.Axis.X);
        Set<BlockPos> p34 = AreaUtil.blocksBetweenOnAxis(vertices.get(2), vertices.get(3), Direction.Axis.X);
        Set<BlockPos> p56 = AreaUtil.blocksBetweenOnAxis(vertices.get(4), vertices.get(5), Direction.Axis.X);
        Set<BlockPos> p78 = AreaUtil.blocksBetweenOnAxis(vertices.get(6), vertices.get(7), Direction.Axis.X);
        Set<BlockPos> p15 = AreaUtil.blocksBetweenOnAxis(vertices.get(0), vertices.get(4), Direction.Axis.Y);
        Set<BlockPos> p26 = AreaUtil.blocksBetweenOnAxis(vertices.get(1), vertices.get(5), Direction.Axis.Y);
        Set<BlockPos> p37 = AreaUtil.blocksBetweenOnAxis(vertices.get(2), vertices.get(6), Direction.Axis.Y);
        Set<BlockPos> p48 = AreaUtil.blocksBetweenOnAxis(vertices.get(3), vertices.get(7), Direction.Axis.Y);
        Set<BlockPos> p13 = AreaUtil.blocksBetweenOnAxis(vertices.get(0), vertices.get(2), Direction.Axis.Z);
        Set<BlockPos> p24 = AreaUtil.blocksBetweenOnAxis(vertices.get(1), vertices.get(3), Direction.Axis.Z);
        Set<BlockPos> p57 = AreaUtil.blocksBetweenOnAxis(vertices.get(4), vertices.get(6), Direction.Axis.Z);
        Set<BlockPos> p68 = AreaUtil.blocksBetweenOnAxis(vertices.get(5), vertices.get(7), Direction.Axis.Z);
        return Stream.of(p12, p34, p56, p78, p15, p26, p37, p48, p13, p24, p57, p68).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @Override
    public Set<BlockPos> getMinimalOutline() {
        HashSet<BlockPos> corners = new HashSet<BlockPos>();
        int minX = this.area.minX();
        int minY = this.area.minY();
        int minZ = this.area.minZ();
        int maxX = this.area.maxX();
        int maxY = this.area.maxY();
        int maxZ = this.area.maxZ();
        corners.add(new BlockPos(minX, minY, minZ));
        corners.add(new BlockPos(minX, minY, maxZ));
        corners.add(new BlockPos(minX, maxY, minZ));
        corners.add(new BlockPos(minX, maxY, maxZ));
        corners.add(new BlockPos(maxX, minY, minZ));
        corners.add(new BlockPos(maxX, minY, maxZ));
        corners.add(new BlockPos(maxX, maxY, minZ));
        corners.add(new BlockPos(maxX, maxY, maxZ));
        HashSet<BlockPos> result = new HashSet<BlockPos>();
        for (BlockPos corner : corners) {
            result.add(corner);
            if (minX != maxX) {
                int dx = corner.getX() == minX ? 1 : -1;
                result.add(corner.offset(dx, 0, 0));
            }
            if (minY != maxY) {
                int dy = corner.getY() == minY ? 1 : -1;
                result.add(corner.offset(0, dy, 0));
            }
            if (minZ == maxZ) continue;
            int dz = corner.getZ() == minZ ? 1 : -1;
            result.add(corner.offset(0, 0, dz));
        }
        return result;
    }

    @Override
    public boolean containsOther(IMarkableArea inner) {
        switch (inner.getAreaType()) {
            case CUBOID: {
                return this.contains((CuboidArea)inner);
            }
            case SPHERE: {
                return this.contains((SphereArea)inner);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }

    @Override
    public boolean intersects(IMarkableArea other) {
        switch (other.getAreaType()) {
            case CUBOID: {
                return this.intersects((CuboidArea)other);
            }
            case SPHERE: {
                return this.intersects((SphereArea)other);
            }
        }
        throw new NotImplementedException("Area type not implemented yet");
    }
}

