/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.mixin;

import de.z0rdak.yawp.api.FlagEvaluator;
import de.z0rdak.yawp.api.events.region.FlagCheckEvent;
import de.z0rdak.yawp.constants.Constants;
import de.z0rdak.yawp.core.flag.RegionFlag;
import de.z0rdak.yawp.handler.HandlerUtil;
import de.z0rdak.yawp.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ExplosionParticleInfo;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ServerLevel.class})
public class ServerWorldMixin {
    @Inject(method={"tickThunder"}, locals=LocalCapture.CAPTURE_FAILSOFT, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LightningBolt;setVisualOnly(Z)V")}, cancellable=false, allow=1)
    public void onSpawnLightning(LevelChunk chunk, CallbackInfo ci, ChunkPos chunkPos, boolean bl, int i, int j, ProfilerFiller profiler, BlockPos blockPos, DifficultyInstance localDifficulty, boolean b, LightningBolt lightningEntity) {
        if (HandlerUtil.isServerSide(chunk.getLevel())) {
            FlagCheckEvent checkEvent = new FlagCheckEvent(blockPos, RegionFlag.LIGHTNING_PROT, HandlerUtil.getDimKey(chunk.getLevel()));
            if (Services.EVENT.post(checkEvent)) {
                return;
            }
            FlagEvaluator.processCheck(checkEvent, deny -> {
                lightningEntity.remove(Entity.RemovalReason.DISCARDED);
                Constants.LOGGER.info("Discarded 'minecraft:lightning_bolt' due to flag in region {}. You can ignore the warning printed by the vanilla code.", (Object)deny.getResponsible().getName());
            });
        }
    }

    @Inject(method={"explode"}, at={@At(value="HEAD")}, cancellable=true, allow=1)
    public void onIgniteExplosive(Entity entity, DamageSource ds, ExplosionDamageCalculator edc, double x, double y, double z, float power, boolean createFire, Level.ExplosionInteraction explosionMode, ParticleOptions small, ParticleOptions big, WeightedList<ExplosionParticleInfo> weightedList, Holder<SoundEvent> soundEvent, CallbackInfo ci) {
        ServerLevel world = (ServerLevel)this;
        if (HandlerUtil.isServerSide((Level)world)) {
            FlagCheckEvent checkEvent;
            if (explosionMode == Level.ExplosionInteraction.TNT || explosionMode == Level.ExplosionInteraction.BLOCK) {
                checkEvent = new FlagCheckEvent(new BlockPos((int)x, (int)y, (int)z), RegionFlag.IGNITE_EXPLOSIVES, (ResourceKey<Level>)world.dimension());
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> ci.cancel());
            }
            if (explosionMode == Level.ExplosionInteraction.MOB) {
                checkEvent = new FlagCheckEvent(new BlockPos((int)x, (int)y, (int)z), RegionFlag.MOB_GRIEFING, (ResourceKey<Level>)world.dimension());
                if (Services.EVENT.post(checkEvent)) {
                    return;
                }
                FlagEvaluator.processCheck(checkEvent, denyResult -> ci.cancel());
            }
        }
    }
}

