/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.util.text.messages;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.z0rdak.yawp.util.text.messages.SubstituteException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="Not used until YAWP is required on client-side", forRemoval=false)
public class SubstituteTextContent
implements ComponentContents {
    private static final FormattedText TEXT_PERCENT;
    private static final FormattedText TEXT_NULL;
    private static final Pattern SUBSTITUTE_PATTERN;
    private static final Codec<Object> PRIMITIVE_ARG_CODEC;
    private static final Codec<Object> ARG_CODEC;
    public static final MapCodec<SubstituteTextContent> CODEC;
    private final String pattern;
    @Nullable
    private final Object[] args;
    @Nullable
    private List<FormattedText> substitutes = ImmutableList.of();
    public static final Object[] NO_ARGS;

    private static Optional<List<Object>> adjustArgs(Object[] args) {
        return args.length == 0 ? Optional.empty() : Optional.of(Arrays.asList(args));
    }

    private static Object[] adjustArgs(Optional<List<Object>> args) {
        return args.map(arg -> arg.isEmpty() ? NO_ARGS : arg.toArray()).orElse(NO_ARGS);
    }

    private static SubstituteTextContent create(String pattern, Optional<List<Object>> args) {
        return new SubstituteTextContent(pattern, SubstituteTextContent.adjustArgs(args));
    }

    private static DataResult<Object> filterAllowedArguments(@Nullable Object input) {
        return !SubstituteTextContent.isAllowedPrimitiveArgument(input) ? DataResult.error(() -> "This value needs to be parsed as component") : DataResult.success((Object)input);
    }

    public static boolean isAllowedPrimitiveArgument(@Nullable Object input) {
        return input instanceof Number || input instanceof Boolean || input instanceof String;
    }

    @NotNull
    private static Either<Object, Component> getEither(Object either) {
        Either result;
        if (either instanceof Component) {
            Component component = (Component)either;
            result = Either.right((Object)component);
        } else {
            result = Either.left((Object)either);
        }
        return result;
    }

    public SubstituteTextContent(String pattern, Object[] args) {
        this.pattern = pattern;
        this.args = args;
    }

    private void updateSubstitutes() {
        try {
            ImmutableList.Builder builder = ImmutableList.builder();
            this.forEachPart(this.pattern, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
            this.substitutes = builder.build();
        }
        catch (SubstituteException substituteException) {
            this.substitutes = ImmutableList.of((Object)FormattedText.of((String)this.pattern));
        }
    }

    private void forEachPart(String substitute, Consumer<FormattedText> partsConsumer) {
        Matcher matcher = SUBSTITUTE_PATTERN.matcher(substitute);
        try {
            int i = 0;
            int j = 0;
            while (matcher.find(j)) {
                String string;
                int k = matcher.start();
                int l = matcher.end();
                if (k > j) {
                    string = substitute.substring(j, k);
                    if (string.indexOf(37) != -1) {
                        throw new IllegalArgumentException();
                    }
                    partsConsumer.accept(FormattedText.of((String)string));
                }
                string = matcher.group(2);
                String string2 = substitute.substring(k, l);
                if ("%".equals(string) && "%%".equals(string2)) {
                    partsConsumer.accept(TEXT_PERCENT);
                } else if ("s".equals(string)) {
                    String string3 = matcher.group(1);
                    int m = string3 != null ? Integer.parseInt(string3) - 1 : i++;
                    partsConsumer.accept(this.getArg(m));
                } else {
                    throw new SubstituteException(this, "Unsupported format: '" + string2 + "'");
                }
                j = l;
            }
            if (j < substitute.length()) {
                String string4 = substitute.substring(j);
                if (string4.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                partsConsumer.accept(FormattedText.of((String)string4));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SubstituteException(this, (Throwable)illegalArgumentException);
        }
    }

    public final FormattedText getArg(int index) {
        if (index < 0 || index >= this.args.length) {
            throw new SubstituteException(this, index);
        }
        Object object = this.args[index];
        if (object instanceof Component) {
            return (Component)object;
        }
        return object == null ? TEXT_NULL : FormattedText.of((String)object.toString());
    }

    public <T> Optional<T> visit(FormattedText.StyledContentConsumer<T> visitor, Style style) {
        this.updateSubstitutes();
        if (this.substitutes == null) {
            return Optional.empty();
        }
        for (FormattedText stringVisitable : this.substitutes) {
            Optional optional = stringVisitable.visit(visitor, style);
            if (optional.isEmpty()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public <T> Optional<T> visit(FormattedText.ContentConsumer<T> visitor) {
        this.updateSubstitutes();
        if (this.substitutes == null) {
            return Optional.empty();
        }
        for (FormattedText stringVisitable : this.substitutes) {
            Optional optional = stringVisitable.visit(visitor);
            if (optional.isEmpty()) continue;
            return optional;
        }
        return Optional.empty();
    }

    public MutableComponent resolve(@Nullable CommandSourceStack source, @Nullable Entity sender, int depth) throws CommandSyntaxException {
        Object[] objects = new Object[this.args.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = this.args[i];
            objects[i] = object instanceof Component ? ComponentUtils.updateForEntity((CommandSourceStack)source, (Component)((Component)object), (Entity)sender, (int)depth) : object;
        }
        return MutableComponent.create((ComponentContents)new SubstituteTextContent(this.pattern, objects));
    }

    public MapCodec<? extends ComponentContents> codec() {
        return CODEC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SubstituteTextContent)) {
            return false;
        }
        SubstituteTextContent substituteTextContent = (SubstituteTextContent)o;
        if (!Objects.equals(this.pattern, substituteTextContent.pattern)) {
            return false;
        }
        return Arrays.equals(this.args, substituteTextContent.args);
    }

    public int hashCode() {
        int i = Objects.hashCode(this.pattern);
        i = 31 * i + Arrays.hashCode(this.args);
        return i;
    }

    public String toString() {
        return "substitute{key='" + this.pattern + "', args=" + Arrays.toString(this.args) + "}";
    }

    public String getPattern() {
        return this.pattern;
    }

    public Object[] getArgs() {
        return this.args;
    }

    static {
        NO_ARGS = new Object[0];
        PRIMITIVE_ARG_CODEC = ExtraCodecs.JAVA.validate(SubstituteTextContent::filterAllowedArguments);
        ARG_CODEC = Codec.either(PRIMITIVE_ARG_CODEC, (Codec)ComponentSerialization.CODEC).xmap(objectOrComponent -> objectOrComponent.map(object -> object, component -> Objects.requireNonNullElse(component.tryCollapseToString(), component)), SubstituteTextContent::getEither);
        CODEC = RecordCodecBuilder.mapCodec(stcInstance -> stcInstance.group((App)Codec.STRING.fieldOf("pattern").forGetter(stc -> stc.pattern), (App)ARG_CODEC.listOf().optionalFieldOf("args").forGetter(stc -> SubstituteTextContent.adjustArgs(stc.args))).apply((Applicative)stcInstance, SubstituteTextContent::create));
        TEXT_PERCENT = FormattedText.of((String)"%");
        TEXT_NULL = FormattedText.of((String)"null");
        SUBSTITUTE_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");
    }
}

