/*
 * Decompiled with CFR 0.152.
 */
package net.akaciobahno.backported_animal_variants.entity.custom;

import javax.annotation.Nullable;
import net.akaciobahno.backported_animal_variants.entity.ModEntities;
import net.akaciobahno.backported_animal_variants.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class ColdChicken
extends Chicken {
    public ColdChicken(EntityType<? extends Chicken> entityType, Level level) {
        super(entityType, level);
    }

    public static AttributeSupplier.Builder createAtrributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 4.0).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.FOLLOW_RANGE, 10.0);
    }

    public void aiStep() {
        int currentEggTime = this.eggTime;
        if (currentEggTime == 1) {
            this.eggTime = Integer.MAX_VALUE;
        }
        super.aiStep();
        if (!(this.level().isClientSide || this.isBaby() || this.isChickenJockey() || currentEggTime != 1)) {
            this.playSound(SoundEvents.CHICKEN_EGG, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
            this.spawnAtLocation((ItemLike)ModItems.BLUE_EGG.get());
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            this.eggTime = this.random.nextInt(6000) + 6000;
        }
    }

    @Nullable
    public Chicken getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        return (Chicken)ModEntities.COLD_CHICKEN.get().create((Level)pLevel);
    }

    public boolean causeFallDamage(float fallDistance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public boolean checkSpawnRules(LevelAccessor level, MobSpawnType spawnType) {
        BlockPos pos = this.blockPosition();
        BlockState state = level.getBlockState(pos.below());
        return (state.is(BlockTags.ANIMALS_SPAWNABLE_ON) || state.is(Blocks.SNOW_BLOCK)) && super.checkSpawnRules(level, spawnType);
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.FREEZE)) {
            return false;
        }
        return super.hurt(source, amount);
    }
}

