/*
 * Decompiled with CFR 0.152.
 */
package ch.urotan.happywallpaintingmod.datagen;

import ch.urotan.happywallpaintingmod.block.ModBlocks;
import ch.urotan.happywallpaintingmod.item.ModItems;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class ModBlockLootTableProvider
extends BlockLootSubProvider {
    protected ModBlockLootTableProvider(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    protected void generate() {
        for (Block block2 : this.getKnownBlocks()) {
            this.dropSelf(block2);
        }
        for (Block block2 : this.getKnownBlocks()) {
            if (!(block2 instanceof SlabBlock)) continue;
            this.add(block2, b -> this.createSlabItemTable((Block)b));
        }
        for (Block block2 : this.getKnownBlocks()) {
            if (!(block2 instanceof DoorBlock)) continue;
            this.add(block2, b -> this.createDoorTable((Block)b));
        }
        this.add((Block)ModBlocks.KAOLINITE_ORE.get(), block -> this.createOreDrop((Block)ModBlocks.KAOLINITE_ORE.get(), (Item)ModItems.KAOLINITE.get()));
        this.add((Block)ModBlocks.KAOLINITE_DEEPSLATE_ORE.get(), block -> this.createMultipleOreDrops((Block)ModBlocks.KAOLINITE_DEEPSLATE_ORE.get(), (Item)ModItems.KAOLINITE.get(), 2.0f, 5.0f));
        this.add((Block)ModBlocks.PYROLUSITE_ORE.get(), block -> this.createOreDrop((Block)ModBlocks.PYROLUSITE_ORE.get(), (Item)ModItems.PYROLUSITE.get()));
        this.add((Block)ModBlocks.PYROLUSITE_DEEPSLATE_ORE.get(), block -> this.createMultipleOreDrops((Block)ModBlocks.PYROLUSITE_DEEPSLATE_ORE.get(), (Item)ModItems.PYROLUSITE.get(), 2.0f, 5.0f));
        this.add((Block)ModBlocks.HEMATITE_ORE.get(), block -> this.createOreDrop((Block)ModBlocks.HEMATITE_ORE.get(), (Item)ModItems.HEMATITE.get()));
        this.add((Block)ModBlocks.HEMATITE_DEEPSLATE_ORE.get(), block -> this.createMultipleOreDrops((Block)ModBlocks.HEMATITE_DEEPSLATE_ORE.get(), (Item)ModItems.HEMATITE.get(), 2.0f, 5.0f));
        this.add((Block)ModBlocks.AZURITE_ORE.get(), block -> this.createOreDrop((Block)ModBlocks.AZURITE_ORE.get(), (Item)ModItems.AZURITE.get()));
        this.add((Block)ModBlocks.AZURITE_DEEPSLATE_ORE.get(), block -> this.createMultipleOreDrops((Block)ModBlocks.AZURITE_DEEPSLATE_ORE.get(), (Item)ModItems.AZURITE.get(), 2.0f, 5.0f));
        this.add((Block)ModBlocks.LIMONITE_ORE.get(), block -> this.createOreDrop((Block)ModBlocks.LIMONITE_ORE.get(), (Item)ModItems.LIMONITE.get()));
        this.add((Block)ModBlocks.LIMONITE_DEEPSLATE_ORE.get(), block -> this.createMultipleOreDrops((Block)ModBlocks.LIMONITE_DEEPSLATE_ORE.get(), (Item)ModItems.LIMONITE.get(), 2.0f, 5.0f));
        this.add((Block)ModBlocks.MALACHITE_ORE.get(), block -> this.createOreDrop((Block)ModBlocks.MALACHITE_ORE.get(), (Item)ModItems.MALACHITE.get()));
        this.add((Block)ModBlocks.MALACHITE_DEEPSLATE_ORE.get(), block -> this.createMultipleOreDrops((Block)ModBlocks.MALACHITE_DEEPSLATE_ORE.get(), (Item)ModItems.MALACHITE.get(), 2.0f, 5.0f));
    }

    protected LootTable.Builder createMultipleOreDrops(Block pBlock, Item item, float minDrops, float maxDrops) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

