/*
 * Decompiled with CFR 0.152.
 */
package ch.urotan.happywallpaintingmod.worldgen;

import ch.urotan.happywallpaintingmod.block.ModBlocks;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_KAOLINITE_ORE_KEY = ModConfiguredFeatures.registerKey("kaolinite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_PYROLUSITE_ORE_KEY = ModConfiguredFeatures.registerKey("pyrolusite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_HEMATITE_ORE_KEY = ModConfiguredFeatures.registerKey("hematite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_AZURITE_ORE_KEY = ModConfiguredFeatures.registerKey("azurite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_LIMONITE_ORE_KEY = ModConfiguredFeatures.registerKey("limonite_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_MALACHITE_ORE_KEY = ModConfiguredFeatures.registerKey("malachite_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldKaoliniteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.KAOLINITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.KAOLINITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldPyrolusiteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.PYROLUSITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.PYROLUSITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldHematiteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.HEMATITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.HEMATITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldAzuriteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.AZURITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.AZURITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldLimoniteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.LIMONITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.LIMONITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldMalachiteOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.MALACHITE_ORE.get()).defaultBlockState()), OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.MALACHITE_DEEPSLATE_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_KAOLINITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldKaoliniteOres, 9));
        ModConfiguredFeatures.register(context, OVERWORLD_PYROLUSITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldPyrolusiteOres, 9));
        ModConfiguredFeatures.register(context, OVERWORLD_HEMATITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldHematiteOres, 9));
        ModConfiguredFeatures.register(context, OVERWORLD_AZURITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldAzuriteOres, 9));
        ModConfiguredFeatures.register(context, OVERWORLD_LIMONITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldLimoniteOres, 9));
        ModConfiguredFeatures.register(context, OVERWORLD_MALACHITE_ORE_KEY, Feature.ORE, new OreConfiguration(overworldMalachiteOres, 9));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"happywallpaintingmod", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

