/*
 * Decompiled with CFR 0.152.
 */
package io.github.bananapuncher714.nbteditor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public final class NBTEditor {
    private static final Set<ReflectionTarget> reflectionTargets;
    private static final Map<ClassId, Class<?>> classCache;
    private static final Map<MethodId, Method> methodCache;
    private static final Map<ClassId, Constructor<?>> constructorCache;
    private static final Map<Class<?>, Constructor<?>> NBTConstructors;
    private static final Map<Class<?>, Class<?>> NBTClasses;
    private static final Map<Class<?>, Field> NBTTagFieldCache;
    private static Field NBTListData;
    private static Field NBTCompoundMap;
    private static Field skullProfile;
    private static final String VERSION;
    private static final MinecraftVersion LOCAL_VERSION;
    private static final String BUKKIT_VERSION;
    public static final Type COMPOUND;
    public static final Type LIST;
    public static final Type NEW_ELEMENT;
    public static final Type DELETE;
    public static final Type CUSTOM_DATA;
    public static final Type ITEMSTACK_COMPONENTS;

    private static Constructor<?> getNBTTagConstructor(Class<?> primitiveType) {
        return NBTConstructors.get(NBTEditor.getNBTTag(primitiveType));
    }

    private static Class<?> getNBTTag(Class<?> primitiveType) {
        if (NBTClasses.containsKey(primitiveType)) {
            return NBTClasses.get(primitiveType);
        }
        return primitiveType;
    }

    private static Object getNBTVar(Object object) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        try {
            if (NBTTagFieldCache.containsKey(clazz)) {
                return NBTTagFieldCache.get(clazz).get(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    private static Method getMethod(MethodId name) {
        if (methodCache.containsKey((Object)name)) {
            return methodCache.get((Object)name);
        }
        for (ReflectionTarget target : reflectionTargets) {
            if (!target.getVersion().lessThanOrEqualTo(LOCAL_VERSION)) continue;
            try {
                Method method = target.fetchMethod(name);
                if (method == null) continue;
                methodCache.put(name, method);
                return method;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
        methodCache.put(name, null);
        return null;
    }

    private static Constructor<?> getConstructor(ClassId id) {
        if (constructorCache.containsKey((Object)id)) {
            return constructorCache.get((Object)id);
        }
        for (ReflectionTarget target : reflectionTargets) {
            if (!target.getVersion().lessThanOrEqualTo(LOCAL_VERSION)) continue;
            try {
                Constructor<?> cons = target.fetchConstructor(id);
                if (cons == null) continue;
                constructorCache.put(id, cons);
                return cons;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static Class<?> getNMSClass(ClassId id) {
        if (classCache.containsKey((Object)id)) {
            return classCache.get((Object)id);
        }
        for (ReflectionTarget target : reflectionTargets) {
            if (!target.getVersion().lessThanOrEqualTo(LOCAL_VERSION)) continue;
            try {
                Class<?> clazz = target.fetchClass(id);
                if (clazz == null) continue;
                classCache.put(id, clazz);
                return clazz;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private static String getMatch(String string, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static Object createItemStack(Object compound) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, InstantiationException, NoSuchFieldException, SecurityException {
        if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
            return ReflectionTarget.v1_21_R5.getItemFrom(NBTEditor.registryAccess(), compound);
        }
        if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_4)) {
            Optional optional = (Optional)NBTEditor.getMethod(MethodId.createStackOptional).invoke(null, NBTEditor.registryAccess(), compound);
            return optional.get();
        }
        if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
            Method createStack = NBTEditor.getMethod(MethodId.createStack);
            if (createStack.getParameterCount() == 2) {
                return NBTEditor.getMethod(MethodId.createStack).invoke(null, NBTEditor.registryAccess(), compound);
            }
            return NBTEditor.getMethod(MethodId.createStack).invoke(null, compound);
        }
        if (LOCAL_VERSION == MinecraftVersion.v1_11 || LOCAL_VERSION == MinecraftVersion.v1_12) {
            return NBTEditor.getConstructor(ClassId.ItemStack).newInstance(compound);
        }
        return NBTEditor.getMethod(MethodId.createStack).invoke(null, compound);
    }

    public static String getVersion() {
        return VERSION;
    }

    public static MinecraftVersion getMinecraftVersion() {
        return LOCAL_VERSION;
    }

    public static ItemStack getHead(String skinURL) {
        Material material = Material.getMaterial((String)"SKULL_ITEM");
        if (material == null) {
            material = Material.getMaterial((String)"PLAYER_HEAD");
        }
        ItemStack head = new ItemStack(material, 1, 3);
        if (skinURL == null || skinURL.isEmpty()) {
            return head;
        }
        ItemMeta headMeta = head.getItemMeta();
        Object profile = null;
        try {
            profile = NBTEditor.getConstructor(ClassId.GameProfile).newInstance(UUID.fromString("069a79f4-44e9-4726-a5be-fca90e38aaf5"), "Notch");
            Object propertyMap = NBTEditor.getMethod(MethodId.getProperties).invoke(profile, new Object[0]);
            Object textureProperty = NBTEditor.getConstructor(ClassId.Property).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", skinURL).getBytes())));
            NBTEditor.getMethod(MethodId.putProperty).invoke(propertyMap, "textures", textureProperty);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e1) {
            e1.printStackTrace();
        }
        Method setSkullResolvableProfile = NBTEditor.getMethod(MethodId.setCraftMetaSkullResolvableProfile);
        Method setSkullProfile = NBTEditor.getMethod(MethodId.setCraftMetaSkullProfile);
        if (setSkullResolvableProfile != null) {
            try {
                setSkullResolvableProfile.invoke((Object)headMeta, NBTEditor.getConstructor(ClassId.ResolvableProfile).newInstance(profile));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else if (setSkullProfile != null) {
            try {
                setSkullProfile.invoke((Object)headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                skullProfile.set(headMeta, profile);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        head.setItemMeta(headMeta);
        return head;
    }

    public static String getTexture(ItemStack head) {
        ItemMeta meta = head.getItemMeta();
        if (!(meta instanceof SkullMeta)) {
            throw new IllegalArgumentException("Item is not a player skull!");
        }
        try {
            Object profile = skullProfile.get(meta);
            Class<?> resolvableProfile = NBTEditor.getNMSClass(ClassId.ResolvableProfile);
            if (resolvableProfile != null && resolvableProfile.isInstance(profile)) {
                Method getGameProfile = NBTEditor.getMethod(MethodId.getResolvableProfileGameProfile);
                profile = getGameProfile.invoke(profile, new Object[0]);
            }
            if (profile == null) {
                return null;
            }
            Collection properties = (Collection)NBTEditor.getMethod(MethodId.propertyValues).invoke(NBTEditor.getMethod(MethodId.getProperties).invoke(profile, new Object[0]), new Object[0]);
            for (Object prop : properties) {
                if (!"textures".equals(NBTEditor.getMethod(MethodId.getPropertyName).invoke(prop, new Object[0]))) continue;
                String texture = new String(Base64.getDecoder().decode((String)NBTEditor.getMethod(MethodId.getPropertyValue).invoke(prop, new Object[0])));
                return NBTEditor.getMatch(texture, "\\{\"url\":\"(.*?)\"\\}");
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getItemTag(ItemStack item, Object ... keys) {
        try {
            Object compound = NBTEditor.getCompound(item);
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4) && !BUKKIT_VERSION.startsWith("1.20.4") && !BUKKIT_VERSION.startsWith("1.20.5") && keys.length > 0 && keys[0] != Type.ITEMSTACK_COMPONENTS) {
                compound = NBTEditor.getMethod(MethodId.compoundGet).invoke(compound, "components");
            }
            return NBTEditor.getTag(compound, keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(ItemStack item) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = NBTEditor.getMethod(MethodId.asNMSCopy).invoke(null, item);
            Object tag = null;
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                tag = ReflectionTarget.v1_21_R5.save(stack, NBTEditor.registryAccess());
            } else {
                Method saveOptional = null;
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                    saveOptional = NBTEditor.getMethod(MethodId.saveOptional);
                }
                tag = saveOptional != null ? saveOptional.invoke(stack, NBTEditor.registryAccess()) : (NBTEditor.getMethod(MethodId.itemHasTag).invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod(MethodId.getItemTag).invoke(stack, new Object[0]) : NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance());
            }
            return tag;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getItemNBTTag(ItemStack item, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = null;
            stack = NBTEditor.getMethod(MethodId.asNMSCopy).invoke(null, item);
            Object tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                tag = ReflectionTarget.v1_21_R5.save(stack, NBTEditor.registryAccess());
            } else {
                Method saveOptional = null;
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                    saveOptional = NBTEditor.getMethod(MethodId.saveOptional);
                }
                tag = saveOptional != null ? saveOptional.invoke(stack, NBTEditor.registryAccess()) : NBTEditor.getMethod(MethodId.itemSave).invoke(stack, tag);
            }
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static ItemStack setItemTag(ItemStack item, Object value, Object ... keys) {
        if (item == null) {
            return null;
        }
        try {
            Object stack = NBTEditor.getMethod(MethodId.asNMSCopy).invoke(null, item);
            Object tag = null;
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                tag = ReflectionTarget.v1_21_R5.save(stack, NBTEditor.registryAccess());
            } else {
                Method saveOptional = null;
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                    saveOptional = NBTEditor.getMethod(MethodId.saveOptional);
                }
                tag = saveOptional != null ? saveOptional.invoke(stack, NBTEditor.registryAccess()) : (NBTEditor.getMethod(MethodId.itemHasTag).invoke(stack, new Object[0]).equals(true) ? NBTEditor.getMethod(MethodId.getItemTag).invoke(stack, new Object[0]) : NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance());
            }
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4) && !BUKKIT_VERSION.startsWith("1.20.4") && !BUKKIT_VERSION.startsWith("1.20.5") && keys.length > 0 && keys[0] != Type.ITEMSTACK_COMPONENTS) {
                    ArrayList<Object> keyList = new ArrayList<Object>(Arrays.asList(keys));
                    keyList.add(0, "components");
                    keys = keyList.toArray();
                }
                NBTEditor.setTag(tag, value, keys);
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4) && !BUKKIT_VERSION.startsWith("1.20.4") && !BUKKIT_VERSION.startsWith("1.20.5")) {
                return (ItemStack)NBTEditor.getMethod(MethodId.asBukkitCopy).invoke(null, NBTEditor.createItemStack(tag));
            }
            NBTEditor.getMethod(MethodId.setItemTag).invoke(stack, tag);
            return (ItemStack)NBTEditor.getMethod(MethodId.asBukkitCopy).invoke(null, stack);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static ItemStack getItemFromTag(NBTCompound compound) {
        if (compound == null) {
            return null;
        }
        try {
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4) && !BUKKIT_VERSION.startsWith("1.20.4") && !BUKKIT_VERSION.startsWith("1.20.5")) {
                return (ItemStack)NBTEditor.getMethod(MethodId.asBukkitCopy).invoke(null, NBTEditor.createItemStack(compound.tag));
            }
            Object tag = compound.tag;
            Object count = NBTEditor.getTag(tag, "Count");
            Object id = NBTEditor.getTag(tag, "id");
            if (count == null || id == null) {
                return null;
            }
            if (count instanceof Byte && id instanceof String) {
                return (ItemStack)NBTEditor.getMethod(MethodId.asBukkitCopy).invoke(null, NBTEditor.createItemStack(tag));
            }
            return null;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static Object getEntityTag(Entity entity, Object ... keys) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(entity), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Entity entity) {
        if (entity == null) {
            return entity;
        }
        try {
            Object NMSEntity = NBTEditor.getMethod(MethodId.getEntityHandle).invoke((Object)entity, new Object[0]);
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                Object tagValueOutput = ReflectionTarget.v1_21_R5.newTagValueOutput(NBTEditor.registryAccess());
                NBTEditor.getMethod(MethodId.getEntityTag).invoke(NMSEntity, tagValueOutput);
                return NBTEditor.getMethod(MethodId.convertToNbtTagCompound).invoke(tagValueOutput, new Object[0]);
            }
            Object tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
            NBTEditor.getMethod(MethodId.getEntityTag).invoke(NMSEntity, tag);
            return tag;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getEntityNBTTag(Entity entity, Object ... keys) {
        if (entity == null) {
            return null;
        }
        try {
            Object tag;
            Object NMSEntity = NBTEditor.getMethod(MethodId.getEntityHandle).invoke((Object)entity, new Object[0]);
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                Object tagValueOutput = ReflectionTarget.v1_21_R5.newTagValueOutput(NBTEditor.registryAccess());
                NBTEditor.getMethod(MethodId.getEntityTag).invoke(NMSEntity, tagValueOutput);
                tag = NBTEditor.getMethod(MethodId.convertToNbtTagCompound).invoke(tagValueOutput, new Object[0]);
            } else {
                tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
                NBTEditor.getMethod(MethodId.getEntityTag).invoke(NMSEntity, tag);
            }
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setEntityTag(Entity entity, Object value, Object ... keys) {
        if (entity == null) {
            return;
        }
        try {
            Object tag;
            Object NMSEntity = NBTEditor.getMethod(MethodId.getEntityHandle).invoke((Object)entity, new Object[0]);
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                Object tagValueOutput = ReflectionTarget.v1_21_R5.newTagValueOutput(NBTEditor.registryAccess());
                NBTEditor.getMethod(MethodId.getEntityTag).invoke(NMSEntity, tagValueOutput);
                tag = NBTEditor.getMethod(MethodId.convertToNbtTagCompound).invoke(tagValueOutput, new Object[0]);
            } else {
                tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
                NBTEditor.getMethod(MethodId.getEntityTag).invoke(NMSEntity, tag);
            }
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTEditor.setTag(tag, value, keys);
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                Object valueInput = ReflectionTarget.v1_21_R5.getValueInputFromNbtTagCompound(NBTEditor.registryAccess(), tag);
                NBTEditor.getMethod(MethodId.setEntityTag).invoke(NMSEntity, valueInput);
            } else {
                NBTEditor.getMethod(MethodId.setEntityTag).invoke(NMSEntity, tag);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    private static Object getBlockTag(Block block, Object ... keys) {
        try {
            return NBTEditor.getTag(NBTEditor.getCompound(block), keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Object getCompound(Block block) {
        try {
            Object tag;
            if (block == null || !NBTEditor.getNMSClass(ClassId.CraftBlockState).isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(ClassId.BlockPosition).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod(MethodId.getWorldHandle).invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod(MethodId.getTileEntity).invoke(nmsWorld, blockPosition);
            if (tileEntity == null) {
                throw new IllegalArgumentException(block + " is not a tile entity!");
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                Method getTileTag = NBTEditor.getMethod(MethodId.getTileTag);
                tag = getTileTag.getParameterCount() == 1 ? getTileTag.invoke(tileEntity, NBTEditor.registryAccess()) : getTileTag.invoke(tileEntity, new Object[0]);
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_18_R1)) {
                tag = NBTEditor.getMethod(MethodId.getTileTag).invoke(tileEntity, new Object[0]);
            } else {
                tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
                NBTEditor.getMethod(MethodId.getTileTag).invoke(tileEntity, tag);
            }
            return tag;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static NBTCompound getBlockNBTTag(Block block, Object ... keys) {
        try {
            Object tag;
            if (block == null || !NBTEditor.getNMSClass(ClassId.CraftBlockState).isInstance(block.getState())) {
                return null;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(ClassId.BlockPosition).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod(MethodId.getWorldHandle).invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod(MethodId.getTileEntity).invoke(nmsWorld, blockPosition);
            if (tileEntity == null) {
                throw new IllegalArgumentException(block + " is not a tile entity!");
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                Method getTileTag = NBTEditor.getMethod(MethodId.getTileTag);
                tag = getTileTag.getParameterCount() == 1 ? getTileTag.invoke(tileEntity, NBTEditor.registryAccess()) : getTileTag.invoke(tileEntity, new Object[0]);
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_18_R1)) {
                tag = NBTEditor.getMethod(MethodId.getTileTag).invoke(tileEntity, new Object[0]);
            } else {
                tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
                NBTEditor.getMethod(MethodId.getTileTag).invoke(tileEntity, tag);
            }
            return NBTEditor.getNBTTag(tag, keys);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private static void setBlockTag(Block block, Object value, Object ... keys) {
        try {
            Method setTileTag;
            Object tag;
            if (block == null || !NBTEditor.getNMSClass(ClassId.CraftBlockState).isInstance(block.getState())) {
                return;
            }
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(ClassId.BlockPosition).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod(MethodId.getWorldHandle).invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod(MethodId.getTileEntity).invoke(nmsWorld, blockPosition);
            if (tileEntity == null) {
                throw new IllegalArgumentException(block + " is not a tile entity!");
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                Method getTileTag = NBTEditor.getMethod(MethodId.getTileTag);
                tag = getTileTag.getParameterCount() == 1 ? getTileTag.invoke(tileEntity, NBTEditor.registryAccess()) : getTileTag.invoke(tileEntity, new Object[0]);
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_18_R1)) {
                tag = NBTEditor.getMethod(MethodId.getTileTag).invoke(tileEntity, new Object[0]);
            } else {
                tag = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
                NBTEditor.getMethod(MethodId.getTileTag).invoke(tileEntity, tag);
            }
            if (keys.length == 0 && value instanceof NBTCompound) {
                tag = ((NBTCompound)value).tag;
            } else {
                NBTEditor.setTag(tag, value, keys);
            }
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R5)) {
                setTileTag = NBTEditor.getMethod(MethodId.setTileTag);
                setTileTag.invoke(tileEntity, ReflectionTarget.v1_21_R5.getValueInputFromNbtTagCompound(NBTEditor.registryAccess(), tag));
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                setTileTag = NBTEditor.getMethod(MethodId.setTileTag);
                if (setTileTag.getParameterCount() == 2) {
                    setTileTag.invoke(tileEntity, tag, NBTEditor.registryAccess());
                } else {
                    setTileTag.invoke(tileEntity, tag);
                }
            } else if (LOCAL_VERSION == MinecraftVersion.v1_16) {
                NBTEditor.getMethod(MethodId.setTileTag).invoke(tileEntity, NBTEditor.getMethod(MethodId.getTileType).invoke(nmsWorld, blockPosition), tag);
            } else {
                NBTEditor.getMethod(MethodId.setTileTag).invoke(tileEntity, tag);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchFieldException | SecurityException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    public static void setSkullTexture(Block block, String texture) {
        try {
            Object profile = NBTEditor.getConstructor(ClassId.GameProfile).newInstance(UUID.randomUUID(), null);
            Object propertyMap = NBTEditor.getMethod(MethodId.getProperties).invoke(profile, new Object[0]);
            Object textureProperty = NBTEditor.getConstructor(ClassId.Property).newInstance("textures", new String(Base64.getEncoder().encode(String.format("{textures:{SKIN:{\"url\":\"%s\"}}}", texture).getBytes())));
            NBTEditor.getMethod(MethodId.putProperty).invoke(propertyMap, "textures", textureProperty);
            Location location = block.getLocation();
            Object blockPosition = NBTEditor.getConstructor(ClassId.BlockPosition).newInstance(location.getBlockX(), location.getBlockY(), location.getBlockZ());
            Object nmsWorld = NBTEditor.getMethod(MethodId.getWorldHandle).invoke((Object)location.getWorld(), new Object[0]);
            Object tileEntity = NBTEditor.getMethod(MethodId.getTileEntity).invoke(nmsWorld, blockPosition);
            if (!NBTEditor.getNMSClass(ClassId.TileEntitySkull).isInstance(tileEntity)) {
                throw new IllegalArgumentException(block + " is not a skull!");
            }
            NBTEditor.getMethod(MethodId.setGameProfile).invoke(tileEntity, profile);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException exception) {
            exception.printStackTrace();
        }
    }

    private static Object getValue(Object object, Object ... keys) {
        if (object instanceof ItemStack) {
            return NBTEditor.getItemTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return NBTEditor.getEntityTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return NBTEditor.getBlockTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTEditor.getTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static NBTCompound getNBTCompound(Object object, Object ... keys) {
        if (object == null) {
            throw new NullPointerException("Provided object was null!");
        }
        if (object instanceof ItemStack) {
            return NBTEditor.getItemNBTTag((ItemStack)object, keys);
        }
        if (object instanceof Entity) {
            return NBTEditor.getEntityNBTTag((Entity)object, keys);
        }
        if (object instanceof Block) {
            return NBTEditor.getBlockNBTTag((Block)object, keys);
        }
        if (object instanceof NBTCompound) {
            try {
                return NBTEditor.getNBTTag(((NBTCompound)object).tag, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(object)) {
            try {
                return NBTEditor.getNBTTag(object, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
        throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
    }

    public static String getString(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof String ? (String)result : null;
    }

    public static int getInt(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Integer ? (Integer)result : 0;
    }

    public static double getDouble(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Double ? (Double)result : 0.0;
    }

    public static long getLong(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Long ? (Long)result : 0L;
    }

    public static float getFloat(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Float ? ((Float)result).floatValue() : 0.0f;
    }

    public static short getShort(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Short ? (Short)result : (short)0;
    }

    public static byte getByte(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof Byte ? (Byte)result : (byte)0;
    }

    public static boolean getBoolean(Object object, Object ... keys) {
        return NBTEditor.getByte(object, keys) == 1;
    }

    public static byte[] getByteArray(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof byte[] ? (byte[])result : null;
    }

    public static int[] getIntArray(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result instanceof int[] ? (int[])result : null;
    }

    public static boolean contains(Object object, Object ... keys) {
        Object result = NBTEditor.getValue(object, keys);
        return result != null;
    }

    public static Collection<String> getKeys(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = NBTEditor.getCompound((ItemStack)object);
            ArrayList<Object> keyList = new ArrayList<Object>(Arrays.asList(keys));
            keyList.add(0, (Object)ITEMSTACK_COMPONENTS);
            keys = keyList.toArray();
        } else if (object instanceof Entity) {
            compound = NBTEditor.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = NBTEditor.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = NBTEditor.getNBTTag(compound, keys);
            if (nbtCompound != null && nbtCompound.tag != null) {
                Object tag = nbtCompound.tag;
                if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(tag)) {
                    return (Collection)NBTEditor.getMethod(MethodId.compoundKeys).invoke(tag, new Object[0]);
                }
                return Collections.EMPTY_LIST;
            }
            return Collections.EMPTY_LIST;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public static int getSize(Object object, Object ... keys) {
        Object compound;
        if (object instanceof ItemStack) {
            compound = NBTEditor.getCompound((ItemStack)object);
        } else if (object instanceof Entity) {
            compound = NBTEditor.getCompound((Entity)object);
        } else if (object instanceof Block) {
            compound = NBTEditor.getCompound((Block)object);
        } else if (object instanceof NBTCompound) {
            compound = ((NBTCompound)object).tag;
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        try {
            NBTCompound nbtCompound = NBTEditor.getNBTTag(compound, keys);
            if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(nbtCompound.tag)) {
                return NBTEditor.getKeys(nbtCompound, new Object[0]).size();
            }
            if (NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(nbtCompound.tag)) {
                return (Integer)NBTEditor.getMethod(MethodId.listSize).invoke(nbtCompound.tag, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return 0;
        }
        throw new IllegalArgumentException("Value is not a compound or list!");
    }

    public static <T> T set(T object, Object value, Object ... keys) {
        if (object instanceof ItemStack) {
            return (T)NBTEditor.setItemTag((ItemStack)object, value, keys);
        }
        if (object instanceof Entity) {
            NBTEditor.setEntityTag((Entity)object, value, keys);
        } else if (object instanceof Block) {
            NBTEditor.setBlockTag((Block)object, value, keys);
        } else if (object instanceof NBTCompound) {
            try {
                NBTEditor.setTag(((NBTCompound)object).tag, value, keys);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            throw new IllegalArgumentException("Object provided must be of type ItemStack, Entity, Block, or NBTCompound!");
        }
        return object;
    }

    public static NBTCompound getNBTCompound(String json) {
        return NBTCompound.fromJson(json);
    }

    public static NBTCompound getEmptyNBTCompound() {
        try {
            return new NBTCompound(NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setTag(Object tag, Object value, Object ... keys) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        void var3_9;
        if (value != null && value != Type.DELETE) {
            if (value instanceof NBTCompound) {
                Object object = ((NBTCompound)value).tag;
            } else if (NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(value) || NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(value)) {
                Object object = value;
            } else if (value == Type.COMPOUND) {
                Object obj = NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
            } else if (value == Type.LIST) {
                Object obj = NBTEditor.getNMSClass(ClassId.NBTTagList).newInstance();
            } else {
                Constructor<?> cons;
                if (value instanceof Boolean) {
                    value = (byte)((Boolean)value == true ? 1 : 0);
                }
                if ((cons = NBTEditor.getNBTTagConstructor(value.getClass())) == null) throw new IllegalArgumentException("Provided value type(" + value.getClass() + ") is not supported!");
                Object obj = cons.newInstance(value);
            }
        } else {
            Type type = Type.DELETE;
        }
        Object compound = tag;
        for (int index = 0; index < keys.length - 1; ++index) {
            void var6_14;
            Object object = keys[index];
            Object prevCompound = compound;
            if (object == Type.CUSTOM_DATA) {
                if (!LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) continue;
                String string = "minecraft:custom_data";
            } else if (object == Type.ITEMSTACK_COMPONENTS) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) {
                    String string = "components";
                } else {
                    String string = "tag";
                }
            }
            if (var6_14 instanceof Integer) {
                int keyIndex = (Integer)var6_14;
                List tagList = (List)NBTListData.get(compound);
                compound = keyIndex >= 0 && keyIndex < tagList.size() ? tagList.get(keyIndex) : null;
            } else if (var6_14 != null && var6_14 != Type.NEW_ELEMENT) {
                compound = NBTEditor.getMethod(MethodId.compoundGet).invoke(compound, (String)var6_14);
            }
            if (compound != null && var6_14 != null && var6_14 != Type.NEW_ELEMENT) continue;
            compound = keys[index + 1] == null || keys[index + 1] instanceof Integer || keys[index + 1] == Type.NEW_ELEMENT ? NBTEditor.getNMSClass(ClassId.NBTTagList).newInstance() : NBTEditor.getNMSClass(ClassId.NBTTagCompound).newInstance();
            if (NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(prevCompound)) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTEditor.getMethod(MethodId.listAdd).invoke(prevCompound, NBTEditor.getMethod(MethodId.listSize).invoke(prevCompound, new Object[0]), compound);
                    continue;
                }
                NBTEditor.getMethod(MethodId.listAdd).invoke(prevCompound, compound);
                continue;
            }
            NBTEditor.getMethod(MethodId.compoundSet).invoke(prevCompound, (String)var6_14, compound);
        }
        if (keys.length > 0) {
            Object lastKey = keys[keys.length - 1];
            if (lastKey == null || lastKey == Type.NEW_ELEMENT) {
                if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_14)) {
                    NBTEditor.getMethod(MethodId.listAdd).invoke(compound, NBTEditor.getMethod(MethodId.listSize).invoke(compound, new Object[0]), var3_9);
                    return;
                } else {
                    NBTEditor.getMethod(MethodId.listAdd).invoke(compound, var3_9);
                }
                return;
            } else if (lastKey instanceof Integer) {
                if (var3_9 == Type.DELETE) {
                    NBTEditor.getMethod(MethodId.listRemove).invoke(compound, (int)((Integer)lastKey));
                    return;
                } else {
                    NBTEditor.getMethod(MethodId.listSet).invoke(compound, (int)((Integer)lastKey), var3_9);
                }
                return;
            } else if (var3_9 == Type.DELETE) {
                NBTEditor.getMethod(MethodId.compoundRemove).invoke(compound, (String)lastKey);
                return;
            } else {
                NBTEditor.getMethod(MethodId.compoundSet).invoke(compound, (String)lastKey, var3_9);
            }
            return;
        } else {
            if (var3_9 == null || !NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(var3_9) || !NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(compound)) return;
            for (String string : NBTEditor.getKeys(var3_9, new Object[0])) {
                NBTEditor.getMethod(MethodId.compoundSet).invoke(compound, string, NBTEditor.getMethod(MethodId.compoundGet).invoke((Object)var3_9, string));
            }
        }
    }

    private static NBTCompound getNBTTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Object compound = tag;
        for (Object key : keys) {
            if (compound == null) {
                return null;
            }
            if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(compound)) {
                if (key == Type.CUSTOM_DATA) {
                    if (!LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) continue;
                    key = "minecraft:custom_data";
                } else if (key == Type.ITEMSTACK_COMPONENTS) {
                    key = LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4) ? "components" : "tag";
                }
                compound = NBTEditor.getMethod(MethodId.compoundGet).invoke(compound, (String)key);
                continue;
            }
            if (!NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(compound)) continue;
            int keyIndex = (Integer)key;
            List tagList = (List)NBTListData.get(compound);
            compound = keyIndex >= 0 && keyIndex < tagList.size() ? tagList.get(keyIndex) : null;
        }
        return new NBTCompound(compound);
    }

    private static Object getTag(Object tag, Object ... keys) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (keys.length == 0) {
            return NBTEditor.getTags(tag);
        }
        Object nbtObj = tag;
        for (Object key : keys) {
            if (nbtObj == null) {
                return null;
            }
            if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(nbtObj)) {
                if (key == Type.CUSTOM_DATA) {
                    if (!LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4)) continue;
                    key = "minecraft:custom_data";
                } else if (key == Type.ITEMSTACK_COMPONENTS) {
                    key = LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_20_R4) ? "components" : "tag";
                }
                if (key instanceof String) {
                    nbtObj = NBTEditor.getMethod(MethodId.compoundGet).invoke(nbtObj, (String)key);
                    continue;
                }
                throw new IllegalArgumentException("Key " + key + " is not a string! Must provide a valid key for an NBT Tag Compound");
            }
            if (NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(nbtObj)) {
                if (!(key instanceof Integer)) {
                    throw new IllegalArgumentException("Key " + key + " is not an integer! Must provide a valid index for an NBT Tag List");
                }
                int keyIndex = (Integer)key;
                List tagList = (List)NBTListData.get(nbtObj);
                if (keyIndex >= 0 && keyIndex < tagList.size()) {
                    nbtObj = tagList.get(keyIndex);
                    continue;
                }
                nbtObj = null;
                continue;
            }
            return NBTEditor.getNBTVar(nbtObj);
        }
        if (nbtObj == null) {
            return null;
        }
        if (NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(nbtObj)) {
            return NBTEditor.getTags(nbtObj);
        }
        if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(nbtObj)) {
            return NBTEditor.getTags(nbtObj);
        }
        return NBTEditor.getNBTVar(nbtObj);
    }

    private static Object getTags(Object tag) {
        HashMap<Object, Object> tags = new HashMap<Object, Object>();
        try {
            if (NBTEditor.getNMSClass(ClassId.NBTTagCompound).isInstance(tag)) {
                Map tagCompound = (Map)NBTCompoundMap.get(tag);
                for (String key : tagCompound.keySet()) {
                    Object value = tagCompound.get(key);
                    if (NBTEditor.getNMSClass(ClassId.NBTTagEnd).isInstance(value)) continue;
                    tags.put(key, NBTEditor.getTag(value, new Object[0]));
                }
            } else if (NBTEditor.getNMSClass(ClassId.NBTTagList).isInstance(tag)) {
                List tagList = (List)NBTListData.get(tag);
                for (int index = 0; index < tagList.size(); ++index) {
                    Object value = tagList.get(index);
                    if (NBTEditor.getNMSClass(ClassId.NBTTagEnd).isInstance(value)) continue;
                    tags.put(index, NBTEditor.getTag(value, new Object[0]));
                }
            } else {
                return NBTEditor.getNBTVar(tag);
            }
            return tags;
        }
        catch (Exception e) {
            e.printStackTrace();
            return tags;
        }
    }

    private static Object registryAccess() {
        try {
            return NBTEditor.getMethod(MethodId.registryAccess).invoke(NBTEditor.getMethod(MethodId.getServer).invoke((Object)Bukkit.getServer(), new Object[0]), new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        COMPOUND = Type.COMPOUND;
        LIST = Type.LIST;
        NEW_ELEMENT = Type.NEW_ELEMENT;
        DELETE = Type.DELETE;
        CUSTOM_DATA = Type.CUSTOM_DATA;
        ITEMSTACK_COMPONENTS = Type.ITEMSTACK_COMPONENTS;
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        String bukkitVersion = Bukkit.getServer().getBukkitVersion();
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = bukkitVersion;
        }
        VERSION = detectedVersion;
        LOCAL_VERSION = MinecraftVersion.get(VERSION);
        BUKKIT_VERSION = bukkitVersion;
        classCache = new HashMap();
        methodCache = new HashMap<MethodId, Method>();
        constructorCache = new HashMap();
        reflectionTargets = new TreeSet<ReflectionTarget>();
        reflectionTargets.addAll(Arrays.asList(new ReflectionTarget.v1_8().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_9().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_11().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_12().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_13().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_15().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_16().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_17().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_18_R1().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_18_R2().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_19_R1().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_19_R2().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_20_R1().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_20_R2().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_20_R3().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_20_R4().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_21_R1().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_21_R4().setClassFetcher(NBTEditor::getNMSClass), new ReflectionTarget.v1_21_R5().setClassFetcher(NBTEditor::getNMSClass)));
        NBTClasses = new HashMap();
        try {
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_17)) {
                NBTClasses.put(Byte.class, Class.forName("net.minecraft.nbt.NBTTagByte"));
                NBTClasses.put(Boolean.class, Class.forName("net.minecraft.nbt.NBTTagByte"));
                NBTClasses.put(String.class, Class.forName("net.minecraft.nbt.NBTTagString"));
                NBTClasses.put(Double.class, Class.forName("net.minecraft.nbt.NBTTagDouble"));
                NBTClasses.put(Integer.class, Class.forName("net.minecraft.nbt.NBTTagInt"));
                NBTClasses.put(Long.class, Class.forName("net.minecraft.nbt.NBTTagLong"));
                NBTClasses.put(Short.class, Class.forName("net.minecraft.nbt.NBTTagShort"));
                NBTClasses.put(Float.class, Class.forName("net.minecraft.nbt.NBTTagFloat"));
                NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.nbt.NBTTagByteArray"));
                NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.nbt.NBTTagIntArray"));
            } else {
                NBTClasses.put(Byte.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
                NBTClasses.put(Boolean.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagByte"));
                NBTClasses.put(String.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagString"));
                NBTClasses.put(Double.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagDouble"));
                NBTClasses.put(Integer.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagInt"));
                NBTClasses.put(Long.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagLong"));
                NBTClasses.put(Short.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagShort"));
                NBTClasses.put(Float.class, Class.forName("net.minecraft.server." + VERSION + ".NBTTagFloat"));
                NBTClasses.put(Class.forName("[B"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagByteArray"));
                NBTClasses.put(Class.forName("[I"), Class.forName("net.minecraft.server." + VERSION + ".NBTTagIntArray"));
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        NBTConstructors = new HashMap();
        try {
            NBTConstructors.put(NBTEditor.getNBTTag(Byte.class), NBTEditor.getNBTTag(Byte.class).getDeclaredConstructor(Byte.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(Boolean.class), NBTEditor.getNBTTag(Boolean.class).getDeclaredConstructor(Byte.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(String.class), NBTEditor.getNBTTag(String.class).getDeclaredConstructor(String.class));
            NBTConstructors.put(NBTEditor.getNBTTag(Double.class), NBTEditor.getNBTTag(Double.class).getDeclaredConstructor(Double.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(Integer.class), NBTEditor.getNBTTag(Integer.class).getDeclaredConstructor(Integer.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(Long.class), NBTEditor.getNBTTag(Long.class).getDeclaredConstructor(Long.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(Float.class), NBTEditor.getNBTTag(Float.class).getDeclaredConstructor(Float.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(Short.class), NBTEditor.getNBTTag(Short.class).getDeclaredConstructor(Short.TYPE));
            NBTConstructors.put(NBTEditor.getNBTTag(Class.forName("[B")), NBTEditor.getNBTTag(Class.forName("[B")).getDeclaredConstructor(Class.forName("[B")));
            NBTConstructors.put(NBTEditor.getNBTTag(Class.forName("[I")), NBTEditor.getNBTTag(Class.forName("[I")).getDeclaredConstructor(Class.forName("[I")));
            for (Constructor constructor : NBTConstructors.values()) {
                constructor.setAccessible(true);
            }
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            e.printStackTrace();
        }
        NBTTagFieldCache = new HashMap();
        try {
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R4)) {
                NBTTagFieldCache.put(NBTClasses.get(Byte.class), NBTClasses.get(Byte.class).getDeclaredField("v"));
                NBTTagFieldCache.put(NBTClasses.get(Boolean.class), NBTClasses.get(Boolean.class).getDeclaredField("v"));
                NBTTagFieldCache.put(NBTClasses.get(String.class), NBTClasses.get(String.class).getDeclaredField("b"));
                NBTTagFieldCache.put(NBTClasses.get(Double.class), NBTClasses.get(Double.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Integer.class), NBTClasses.get(Integer.class).getDeclaredField("b"));
                NBTTagFieldCache.put(NBTClasses.get(Long.class), NBTClasses.get(Long.class).getDeclaredField("b"));
                NBTTagFieldCache.put(NBTClasses.get(Float.class), NBTClasses.get(Float.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Short.class), NBTClasses.get(Short.class).getDeclaredField("b"));
                NBTTagFieldCache.put(NBTClasses.get(Class.forName("[B")), NBTClasses.get(Class.forName("[B")).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Class.forName("[I")), NBTClasses.get(Class.forName("[I")).getDeclaredField("c"));
                for (Field field : NBTTagFieldCache.values()) {
                    field.setAccessible(true);
                }
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_17)) {
                NBTTagFieldCache.put(NBTClasses.get(Byte.class), NBTClasses.get(Byte.class).getDeclaredField("x"));
                NBTTagFieldCache.put(NBTClasses.get(Boolean.class), NBTClasses.get(Boolean.class).getDeclaredField("x"));
                NBTTagFieldCache.put(NBTClasses.get(String.class), NBTClasses.get(String.class).getDeclaredField("A"));
                NBTTagFieldCache.put(NBTClasses.get(Double.class), NBTClasses.get(Double.class).getDeclaredField("w"));
                NBTTagFieldCache.put(NBTClasses.get(Integer.class), NBTClasses.get(Integer.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Long.class), NBTClasses.get(Long.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Float.class), NBTClasses.get(Float.class).getDeclaredField("w"));
                NBTTagFieldCache.put(NBTClasses.get(Short.class), NBTClasses.get(Short.class).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Class.forName("[B")), NBTClasses.get(Class.forName("[B")).getDeclaredField("c"));
                NBTTagFieldCache.put(NBTClasses.get(Class.forName("[I")), NBTClasses.get(Class.forName("[I")).getDeclaredField("c"));
                for (Field field : NBTTagFieldCache.values()) {
                    field.setAccessible(true);
                }
            } else {
                for (Class<?> clazz : NBTClasses.values()) {
                    Field data = clazz.getDeclaredField("data");
                    data.setAccessible(true);
                    NBTTagFieldCache.put(clazz, data);
                }
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
        try {
            if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_21_R4)) {
                try {
                    NBTListData = NBTEditor.getNMSClass(ClassId.NBTTagList).getDeclaredField("list");
                    NBTCompoundMap = NBTEditor.getNMSClass(ClassId.NBTTagCompound).getDeclaredField("tags");
                }
                catch (NoSuchFieldException ex) {
                    NBTListData = NBTEditor.getNMSClass(ClassId.NBTTagList).getDeclaredField("v");
                    NBTCompoundMap = NBTEditor.getNMSClass(ClassId.NBTTagCompound).getDeclaredField("x");
                }
            } else if (LOCAL_VERSION.greaterThanOrEqualTo(MinecraftVersion.v1_17)) {
                NBTListData = NBTEditor.getNMSClass(ClassId.NBTTagList).getDeclaredField("c");
                NBTCompoundMap = NBTEditor.getNMSClass(ClassId.NBTTagCompound).getDeclaredField("x");
            } else {
                NBTListData = NBTEditor.getNMSClass(ClassId.NBTTagList).getDeclaredField("list");
                NBTCompoundMap = NBTEditor.getNMSClass(ClassId.NBTTagCompound).getDeclaredField("map");
            }
            NBTListData.setAccessible(true);
            NBTCompoundMap.setAccessible(true);
            skullProfile = NBTEditor.getNMSClass(ClassId.CraftMetaSkull).getDeclaredField("profile");
            skullProfile.setAccessible(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static enum ClassId {
        NBTBase,
        NBTTagCompound,
        NBTTagList,
        NBTTagEnd,
        MojangsonParser,
        ItemStack,
        Entity,
        EntityLiving,
        BlockPosition,
        IBlockData,
        World,
        TileEntity,
        TileEntitySkull,
        CraftItemStack,
        CraftMetaSkull,
        CraftEntity,
        CraftWorld,
        CraftBlockState,
        GameProfile,
        Property,
        PropertyMap,
        CraftServer,
        MinecraftServer,
        RegistryAccess,
        ResolvableProfile,
        IRegistryCustomDimension,
        Codec,
        NbtOps,
        DataResult,
        DynamicOps,
        TagValueInput,
        TagValueOutput,
        ValueInput,
        ValueOutput,
        ProblemReporter,
        ValueInputContextHelper;

    }

    public static enum MinecraftVersion {
        v1_8,
        v1_9,
        v1_10,
        v1_11,
        v1_12,
        v1_13,
        v1_14,
        v1_15,
        v1_16,
        v1_17,
        v1_18_R1,
        v1_18_R2,
        v1_19_R1,
        v1_19_R2,
        v1_19_R3,
        v1_20_R1,
        v1_20(false),
        v1_20_1(false),
        v1_20_R2,
        v1_20_2(false),
        v1_20_R3,
        v1_20_3(false),
        v1_20_R4,
        v1_20_4(false),
        v1_20_5(false),
        v1_20_6(false),
        v1_21_R1,
        v1_21(false),
        v1_21_R2,
        v1_21_3(false),
        v1_21_R3,
        v1_21_4(false),
        v1_21_R4,
        v1_21_5(false),
        v1_21_R5,
        v1_21_6(false),
        v1_21_7(false),
        v1_21_8(false),
        v1_21_9(false),
        v1_21_10(false),
        v1_22;

        private boolean implemented = true;

        private MinecraftVersion() {
            this(true);
        }

        private MinecraftVersion(boolean implemented) {
            this.implemented = implemented;
        }

        public boolean greaterThanOrEqualTo(MinecraftVersion other) {
            return this.ordinal() >= other.ordinal();
        }

        public boolean lessThanOrEqualTo(MinecraftVersion other) {
            return this.ordinal() <= other.ordinal();
        }

        public static MinecraftVersion get(String v) {
            v = v.replace('.', '_');
            for (int i = MinecraftVersion.values().length; i > 0; --i) {
                MinecraftVersion k = MinecraftVersion.values()[i - 1];
                if (!v.contains(k.name().substring(1))) continue;
                return MinecraftVersion.getLastImplemented(k);
            }
            return MinecraftVersion.values()[MinecraftVersion.values().length - 1];
        }

        private static MinecraftVersion getLastImplemented(MinecraftVersion v) {
            for (int i = v.ordinal(); i >= 0; --i) {
                MinecraftVersion version = MinecraftVersion.values()[i];
                if (!version.implemented) continue;
                return version;
            }
            return null;
        }
    }

    private static enum MethodId {
        compoundGet,
        compoundSet,
        compoundHasKey,
        listSet,
        listAdd,
        listSize,
        listRemove,
        compoundRemove,
        compoundKeys,
        itemHasTag,
        getItemTag,
        setItemTag,
        itemSave,
        asNMSCopy,
        asBukkitCopy,
        getEntityHandle,
        getWorldHandle,
        getTileEntity,
        getTileType,
        getEntityTag,
        setEntityTag,
        createStack,
        setTileTag,
        getTileTag,
        getProperties,
        setGameProfile,
        setCraftMetaSkullProfile,
        propertyValues,
        putProperty,
        getPropertyName,
        getPropertyValue,
        loadNBTTagCompound,
        getServer,
        registryAccess,
        saveOptional,
        setCraftMetaSkullResolvableProfile,
        getResolvableProfileGameProfile,
        createStackOptional,
        decoderParse,
        createSerializationContext,
        encoderEncodeStart,
        getOrThrow,
        createTagValueOutput,
        convertToNbtTagCompound;

    }

    private static abstract class ReflectionTarget
    implements Comparable<ReflectionTarget> {
        private final MinecraftVersion version;
        private Function<ClassId, Class<?>> classFetcher;
        private final Map<ClassId, String> classTargets = new HashMap<ClassId, String>();
        private final Map<MethodId, ConstructorTarget> methodTargets = new HashMap<MethodId, ConstructorTarget>();
        private final Map<ClassId, ConstructorTarget> constructorTargets = new HashMap<ClassId, ConstructorTarget>();

        protected ReflectionTarget(MinecraftVersion version) {
            this.version = version;
        }

        protected MinecraftVersion getVersion() {
            return this.version;
        }

        protected final ReflectionTarget setClassFetcher(Function<ClassId, Class<?>> func) {
            this.classFetcher = func;
            return this;
        }

        protected final void addClass(ClassId name, String path) {
            this.classTargets.put(name, path);
        }

        protected final MethodTarget addMethod(MethodId name, ClassId clazz, String methodName, Object ... params) {
            MethodTarget newTarget = new MethodTarget(clazz, methodName, params);
            this.methodTargets.put(name, newTarget);
            return newTarget;
        }

        protected final ReturnMethodTarget addMethod(MethodId name, ClassId clazz, ClassId returnType, Object ... params) {
            ReturnMethodTarget newTarget = new ReturnMethodTarget(clazz, returnType, params);
            this.methodTargets.put(name, newTarget);
            return newTarget;
        }

        protected final void addConstructor(ClassId clazz, Object ... params) {
            this.constructorTargets.put(clazz, new ConstructorTarget(clazz, params));
        }

        protected final Class<?> fetchClass(ClassId name) throws ClassNotFoundException {
            String className = this.classTargets.get((Object)name);
            return className != null ? Class.forName(className) : null;
        }

        protected final Method fetchMethod(MethodId name) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
            ConstructorTarget constructorTarget = this.methodTargets.get((Object)name);
            if (constructorTarget instanceof MethodTarget) {
                MethodTarget target = (MethodTarget)constructorTarget;
                Class<?> clazz = this.findClass(target.clazz);
                Class<?>[] params = this.convert(target.params);
                try {
                    return clazz.getMethod(target.name, params);
                }
                catch (NoSuchMethodException e) {
                    try {
                        Method method = clazz.getDeclaredMethod(target.name, params);
                        method.setAccessible(true);
                        return method;
                    }
                    catch (NoSuchMethodException e2) {
                        if (target.silent) {
                            return null;
                        }
                        throw e;
                    }
                }
            }
            if (constructorTarget instanceof ReturnMethodTarget) {
                ReturnMethodTarget target = (ReturnMethodTarget)constructorTarget;
                Class<?> clazz = this.findClass(target.clazz);
                Class<?> returnClazz = this.findClass(target.returnType);
                Class<?>[] params = this.convert(target.params);
                for (Method method : clazz.getDeclaredMethods()) {
                    if (!method.getReturnType().equals(returnClazz) || !this.matches(method.getParameterTypes(), params)) continue;
                    method.setAccessible(true);
                    return method;
                }
                return null;
            }
            return null;
        }

        protected final Constructor<?> fetchConstructor(ClassId name) throws NoSuchMethodException, SecurityException, ClassNotFoundException {
            Constructor<?> constructor;
            ConstructorTarget target = this.constructorTargets.get((Object)name);
            Constructor<?> constructor2 = constructor = target != null ? this.findClass(target.clazz).getDeclaredConstructor(this.convert(target.params)) : null;
            if (constructor != null) {
                constructor.setAccessible(true);
            }
            return constructor;
        }

        private final boolean matches(Class<?>[] params, Class<?>[] find) {
            if (params.length != find.length) {
                return false;
            }
            for (int i = 0; i < params.length; ++i) {
                if (find[i].isAssignableFrom(params[i])) continue;
                return false;
            }
            return true;
        }

        private final Class<?>[] convert(Object[] objects) throws ClassNotFoundException {
            Class[] params = new Class[objects.length];
            for (int i = 0; i < objects.length; ++i) {
                Object obj = objects[i];
                if (obj instanceof Class) {
                    params[i] = (Class)obj;
                    continue;
                }
                if (obj instanceof ClassId) {
                    params[i] = this.findClass((ClassId)((Object)obj));
                    continue;
                }
                throw new IllegalArgumentException("Invalid parameter type: " + obj);
            }
            return params;
        }

        private final Class<?> findClass(ClassId name) throws ClassNotFoundException {
            return this.classFetcher != null ? this.classFetcher.apply(name) : this.fetchClass(name);
        }

        @Override
        public int compareTo(ReflectionTarget o) {
            return o.version.compareTo(this.version);
        }

        private static class MethodTarget
        extends ConstructorTarget {
            final String name;
            boolean silent = false;

            public MethodTarget(ClassId clazz, String name, Object ... params) {
                super(clazz, params);
                this.name = name;
            }

            public MethodTarget failSilently(boolean silent) {
                this.silent = silent;
                return this;
            }
        }

        private static class ReturnMethodTarget
        extends ConstructorTarget {
            final ClassId returnType;

            public ReturnMethodTarget(ClassId clazz, ClassId returnType, Object ... params) {
                super(clazz, params);
                this.returnType = returnType;
            }
        }

        private static class ConstructorTarget {
            final ClassId clazz;
            final Object[] params;

            public ConstructorTarget(ClassId clazz, Object ... params) {
                this.clazz = clazz;
                this.params = params;
            }
        }

        private static class v1_21_R5
        extends ReflectionTarget {
            private static Object ITEMSTACK_CODEC;
            private static Object NBT_OPS;
            private static Object PROBLEM_REPORTER;

            protected v1_21_R5() {
                super(MinecraftVersion.v1_21_R5);
                this.addClass(ClassId.DataResult, "com.mojang.serialization.DataResult");
                this.addClass(ClassId.Codec, "com.mojang.serialization.Codec");
                this.addClass(ClassId.DynamicOps, "com.mojang.serialization.DynamicOps");
                this.addClass(ClassId.NbtOps, "net.minecraft.nbt.DynamicOpsNBT");
                this.addClass(ClassId.ValueInput, "net.minecraft.world.level.storage.ValueInput");
                this.addClass(ClassId.TagValueInput, "net.minecraft.world.level.storage.TagValueInput");
                this.addClass(ClassId.ValueOutput, "net.minecraft.world.level.storage.ValueOutput");
                this.addClass(ClassId.TagValueOutput, "net.minecraft.world.level.storage.TagValueOutput");
                this.addClass(ClassId.ValueInputContextHelper, "net.minecraft.world.level.storage.ValueInputContextHelper");
                this.addClass(ClassId.ProblemReporter, "net.minecraft.util.ProblemReporter");
                this.addMethod(MethodId.decoderParse, ClassId.Codec, "parse", new Object[]{ClassId.DynamicOps, Object.class});
                this.addMethod(MethodId.encoderEncodeStart, ClassId.Codec, "encodeStart", new Object[]{ClassId.DynamicOps, Object.class});
                this.addMethod(MethodId.createSerializationContext, ClassId.RegistryAccess, "a", new Object[]{ClassId.DynamicOps});
                this.addMethod(MethodId.getOrThrow, ClassId.DataResult, "getOrThrow", new Object[0]);
                this.addMethod(MethodId.createTagValueOutput, ClassId.TagValueOutput, "a", new Object[]{ClassId.ProblemReporter, ClassId.RegistryAccess});
                this.addMethod(MethodId.convertToNbtTagCompound, ClassId.TagValueOutput, "b", new Object[0]);
                this.addMethod(MethodId.getResolvableProfileGameProfile, ClassId.ResolvableProfile, "g", new Object[0]);
                this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "b", new Object[]{ClassId.ValueInput});
                this.addMethod(MethodId.getEntityTag, ClassId.Entity, "b", new Object[]{ClassId.ValueOutput});
                this.addMethod(MethodId.setEntityTag, ClassId.Entity, "e", new Object[]{ClassId.ValueInput});
                this.addConstructor(ClassId.ValueInputContextHelper, new Object[]{ClassId.RegistryAccess, ClassId.DynamicOps});
                this.addConstructor(ClassId.TagValueInput, new Object[]{ClassId.ProblemReporter, ClassId.ValueInputContextHelper, ClassId.NBTTagCompound});
            }

            private static Object getItemStackCodec() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
                if (ITEMSTACK_CODEC == null) {
                    ITEMSTACK_CODEC = NBTEditor.getNMSClass(ClassId.ItemStack).getField("b").get(null);
                }
                return ITEMSTACK_CODEC;
            }

            private static Object getNbtOps() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
                if (NBT_OPS == null) {
                    NBT_OPS = NBTEditor.getNMSClass(ClassId.NbtOps).getField("a").get(null);
                }
                return NBT_OPS;
            }

            private static Object getProblemReporter() throws IllegalArgumentException, IllegalAccessException, NoSuchFieldException, SecurityException {
                if (PROBLEM_REPORTER == null) {
                    PROBLEM_REPORTER = NBTEditor.getNMSClass(ClassId.ProblemReporter).getField("a").get(null);
                }
                return PROBLEM_REPORTER;
            }

            protected static Object newTagValueOutput(Object registryAccess) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                return NBTEditor.getMethod(MethodId.createTagValueOutput).invoke(null, v1_21_R5.getProblemReporter(), registryAccess);
            }

            protected static Object getValueInputFromNbtTagCompound(Object registryAccess, Object compound) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchFieldException, SecurityException {
                Object contextHelper = NBTEditor.getConstructor(ClassId.ValueInputContextHelper).newInstance(registryAccess, v1_21_R5.getNbtOps());
                return NBTEditor.getConstructor(ClassId.TagValueInput).newInstance(v1_21_R5.getProblemReporter(), contextHelper, compound);
            }

            protected static Object getItemFrom(Object registryAccess, Object compound) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                return NBTEditor.getMethod(MethodId.getOrThrow).invoke(NBTEditor.getMethod(MethodId.decoderParse).invoke(v1_21_R5.getItemStackCodec(), NBTEditor.getMethod(MethodId.createSerializationContext).invoke(registryAccess, v1_21_R5.getNbtOps()), compound), new Object[0]);
            }

            protected static Object save(Object item, Object registryAccess) throws IllegalAccessException, InvocationTargetException, IllegalArgumentException, NoSuchFieldException, SecurityException {
                return NBTEditor.getMethod(MethodId.getOrThrow).invoke(NBTEditor.getMethod(MethodId.encoderEncodeStart).invoke(v1_21_R5.getItemStackCodec(), NBTEditor.getMethod(MethodId.createSerializationContext).invoke(registryAccess, v1_21_R5.getNbtOps()), item), new Object[0]);
            }
        }

        private static class v1_21_R4
        extends ReflectionTarget {
            protected v1_21_R4() {
                super(MinecraftVersion.v1_21_R4);
                this.addMethod(MethodId.compoundGet, ClassId.NBTTagCompound, "a", String.class);
                this.addMethod(MethodId.createStackOptional, ClassId.ItemStack, "a", new Object[]{ClassId.RegistryAccess, ClassId.NBTBase});
                this.addMethod(MethodId.listSet, ClassId.NBTTagList, "c", new Object[]{Integer.TYPE, ClassId.NBTBase});
                this.addMethod(MethodId.listAdd, ClassId.NBTTagList, "d", new Object[]{Integer.TYPE, ClassId.NBTBase});
                this.addMethod(MethodId.setEntityTag, ClassId.Entity, "i", new Object[]{ClassId.NBTTagCompound});
            }
        }

        private static class v1_21_R1
        extends ReflectionTarget {
            protected v1_21_R1() {
                super(MinecraftVersion.v1_21_R1);
                this.addClass(ClassId.ResolvableProfile, "net.minecraft.world.item.component.ResolvableProfile");
                this.addClass(ClassId.IRegistryCustomDimension, "net.minecraft.core.IRegistryCustom$Dimension");
                this.addMethod(MethodId.setCraftMetaSkullResolvableProfile, ClassId.CraftMetaSkull, "setProfile", new Object[]{ClassId.ResolvableProfile}).failSilently(true);
                this.addMethod(MethodId.getResolvableProfileGameProfile, ClassId.ResolvableProfile, "f", new Object[0]);
                this.addMethod(MethodId.registryAccess, ClassId.MinecraftServer, ClassId.IRegistryCustomDimension, new Object[0]);
                this.addConstructor(ClassId.ResolvableProfile, new Object[]{ClassId.GameProfile});
            }
        }

        private static class v1_20_R4
        extends ReflectionTarget {
            protected v1_20_R4() {
                super(MinecraftVersion.v1_20_R4);
                if (!BUKKIT_VERSION.startsWith("1.20.4") && !BUKKIT_VERSION.startsWith("1.20.5")) {
                    this.addClass(ClassId.MinecraftServer, "net.minecraft.server.MinecraftServer");
                    this.addClass(ClassId.RegistryAccess, "net.minecraft.core.HolderLookup$a");
                    this.addClass(ClassId.ResolvableProfile, "net.minecraft.world.item.component.ResolvableProfile");
                    this.addMethod(MethodId.getServer, ClassId.CraftServer, "getServer", new Object[0]);
                    this.addMethod(MethodId.registryAccess, ClassId.MinecraftServer, "bc", new Object[0]);
                    this.addMethod(MethodId.saveOptional, ClassId.ItemStack, "a", new Object[]{ClassId.RegistryAccess});
                    this.addMethod(MethodId.createStack, ClassId.ItemStack, "a", new Object[]{ClassId.RegistryAccess, ClassId.NBTTagCompound});
                    this.addMethod(MethodId.getTileTag, ClassId.TileEntity, "b", new Object[]{ClassId.RegistryAccess});
                    this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "a", new Object[]{ClassId.NBTTagCompound, ClassId.RegistryAccess});
                }
            }
        }

        private static class v1_20_R3
        extends ReflectionTarget {
            protected v1_20_R3() {
                super(MinecraftVersion.v1_20_R3);
                this.addMethod(MethodId.getTileTag, ClassId.TileEntity, "o", new Object[0]);
            }
        }

        private static class v1_20_R2
        extends ReflectionTarget {
            protected v1_20_R2() {
                super(MinecraftVersion.v1_20_R2);
                this.addMethod(MethodId.getPropertyName, ClassId.Property, "name", new Object[0]);
                this.addMethod(MethodId.getPropertyValue, ClassId.Property, "value", new Object[0]);
            }
        }

        private static class v1_20_R1
        extends ReflectionTarget {
            protected v1_20_R1() {
                super(MinecraftVersion.v1_20_R1);
                this.addMethod(MethodId.itemHasTag, ClassId.ItemStack, "u", new Object[0]);
                this.addMethod(MethodId.getItemTag, ClassId.ItemStack, "v", new Object[0]);
            }
        }

        private static class v1_19_R2
        extends ReflectionTarget {
            protected v1_19_R2() {
                super(MinecraftVersion.v1_19_R2);
                this.addMethod(MethodId.compoundKeys, ClassId.NBTTagCompound, "e", new Object[0]);
            }
        }

        private static class v1_19_R1
        extends ReflectionTarget {
            protected v1_19_R1() {
                super(MinecraftVersion.v1_19_R1);
                this.addMethod(MethodId.itemHasTag, ClassId.ItemStack, "t", new Object[0]);
                this.addMethod(MethodId.getItemTag, ClassId.ItemStack, "u", new Object[0]);
            }
        }

        private static class v1_18_R2
        extends ReflectionTarget {
            protected v1_18_R2() {
                super(MinecraftVersion.v1_18_R2);
                this.addMethod(MethodId.itemHasTag, ClassId.ItemStack, "s", new Object[0]);
                this.addMethod(MethodId.getItemTag, ClassId.ItemStack, "t", new Object[0]);
            }
        }

        private static class v1_18_R1
        extends ReflectionTarget {
            protected v1_18_R1() {
                super(MinecraftVersion.v1_18_R1);
                this.addMethod(MethodId.compoundGet, ClassId.NBTTagCompound, "c", String.class);
                this.addMethod(MethodId.compoundSet, ClassId.NBTTagCompound, "a", new Object[]{String.class, ClassId.NBTBase});
                this.addMethod(MethodId.compoundHasKey, ClassId.NBTTagCompound, "e", String.class);
                this.addMethod(MethodId.listSet, ClassId.NBTTagList, "d", new Object[]{Integer.TYPE, ClassId.NBTBase});
                this.addMethod(MethodId.listAdd, ClassId.NBTTagList, "c", new Object[]{Integer.TYPE, ClassId.NBTBase});
                this.addMethod(MethodId.listRemove, ClassId.NBTTagList, "c", Integer.TYPE);
                this.addMethod(MethodId.compoundRemove, ClassId.NBTTagCompound, "r", String.class);
                this.addMethod(MethodId.compoundKeys, ClassId.NBTTagCompound, "d", new Object[0]);
                this.addMethod(MethodId.itemHasTag, ClassId.ItemStack, "r", new Object[0]);
                this.addMethod(MethodId.getItemTag, ClassId.ItemStack, "s", new Object[0]);
                this.addMethod(MethodId.setItemTag, ClassId.ItemStack, "c", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.itemSave, ClassId.ItemStack, "b", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.getEntityTag, ClassId.Entity, "f", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.setEntityTag, ClassId.Entity, "g", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "a", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.getTileTag, ClassId.TileEntity, "m", new Object[0]);
                this.addMethod(MethodId.getTileEntity, ClassId.World, "c_", new Object[]{ClassId.BlockPosition});
                this.addMethod(MethodId.setGameProfile, ClassId.TileEntitySkull, "a", new Object[]{ClassId.GameProfile});
                this.addMethod(MethodId.loadNBTTagCompound, ClassId.MojangsonParser, "a", String.class);
            }
        }

        private static class v1_17
        extends ReflectionTarget {
            protected v1_17() {
                super(MinecraftVersion.v1_17);
                this.addClass(ClassId.NBTBase, "net.minecraft.nbt.NBTBase");
                this.addClass(ClassId.NBTTagCompound, "net.minecraft.nbt.NBTTagCompound");
                this.addClass(ClassId.NBTTagList, "net.minecraft.nbt.NBTTagList");
                this.addClass(ClassId.NBTTagEnd, "net.minecraft.nbt.NBTTagEnd");
                this.addClass(ClassId.MojangsonParser, "net.minecraft.nbt.MojangsonParser");
                this.addClass(ClassId.ItemStack, "net.minecraft.world.item.ItemStack");
                this.addClass(ClassId.Entity, "net.minecraft.world.entity.Entity");
                this.addClass(ClassId.EntityLiving, "net.minecraft.world.entity.EntityLiving");
                this.addClass(ClassId.BlockPosition, "net.minecraft.core.BlockPosition");
                this.addClass(ClassId.IBlockData, "net.minecraft.world.level.block.state.IBlockData");
                this.addClass(ClassId.World, "net.minecraft.world.level.World");
                this.addClass(ClassId.TileEntity, "net.minecraft.world.level.block.entity.TileEntity");
                this.addClass(ClassId.TileEntitySkull, "net.minecraft.world.level.block.entity.TileEntitySkull");
                this.addMethod(MethodId.listSet, ClassId.NBTTagList, "set", new Object[]{Integer.TYPE, ClassId.NBTBase});
                this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "load", new Object[]{ClassId.NBTTagCompound});
            }
        }

        private static class v1_16
        extends ReflectionTarget {
            protected v1_16() {
                super(MinecraftVersion.v1_16);
                this.addMethod(MethodId.getEntityTag, ClassId.Entity, "save", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.setEntityTag, ClassId.Entity, "load", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.getTileType, ClassId.World, "getType", new Object[]{ClassId.BlockPosition});
                this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "load", new Object[]{ClassId.IBlockData, ClassId.NBTTagCompound});
            }
        }

        private static class v1_15
        extends ReflectionTarget {
            protected v1_15() {
                super(MinecraftVersion.v1_15);
                this.addMethod(MethodId.setCraftMetaSkullProfile, ClassId.CraftMetaSkull, "setProfile", new Object[]{ClassId.GameProfile}).failSilently(MinecraftVersion.v1_21_R1.lessThanOrEqualTo(LOCAL_VERSION));
            }
        }

        private static class v1_13
        extends ReflectionTarget {
            protected v1_13() {
                super(MinecraftVersion.v1_13);
                this.addMethod(MethodId.compoundKeys, ClassId.NBTTagCompound, "getKeys", new Object[0]);
                this.addMethod(MethodId.createStack, ClassId.ItemStack, "a", new Object[]{ClassId.NBTTagCompound});
            }
        }

        private static class v1_12
        extends ReflectionTarget {
            protected v1_12() {
                super(MinecraftVersion.v1_12);
                this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "load", new Object[]{ClassId.NBTTagCompound});
            }
        }

        private static class v1_11
        extends ReflectionTarget {
            protected v1_11() {
                super(MinecraftVersion.v1_11);
                this.addConstructor(ClassId.ItemStack, new Object[]{ClassId.NBTTagCompound});
            }
        }

        private static class v1_9
        extends ReflectionTarget {
            protected v1_9() {
                super(MinecraftVersion.v1_9);
                this.addMethod(MethodId.listRemove, ClassId.NBTTagList, "remove", Integer.TYPE);
                this.addMethod(MethodId.compoundKeys, ClassId.NBTTagCompound, "c", new Object[0]);
                this.addMethod(MethodId.getTileTag, ClassId.TileEntity, "save", new Object[]{ClassId.NBTTagCompound});
            }
        }

        private static class v1_8
        extends ReflectionTarget {
            protected v1_8() {
                super(MinecraftVersion.v1_8);
                String craftbukkitPackage = Bukkit.getServer().getClass().getPackage().getName();
                this.addClass(ClassId.NBTBase, "net.minecraft.server." + VERSION + ".NBTBase");
                this.addClass(ClassId.NBTTagCompound, "net.minecraft.server." + VERSION + ".NBTTagCompound");
                this.addClass(ClassId.NBTTagList, "net.minecraft.server." + VERSION + ".NBTTagList");
                this.addClass(ClassId.NBTTagEnd, "net.minecraft.server." + VERSION + ".NBTTagEnd");
                this.addClass(ClassId.MojangsonParser, "net.minecraft.server." + VERSION + ".MojangsonParser");
                this.addClass(ClassId.ItemStack, "net.minecraft.server." + VERSION + ".ItemStack");
                this.addClass(ClassId.Entity, "net.minecraft.server." + VERSION + ".Entity");
                this.addClass(ClassId.EntityLiving, "net.minecraft.server." + VERSION + ".EntityLiving");
                this.addClass(ClassId.BlockPosition, "net.minecraft.server." + VERSION + ".BlockPosition");
                this.addClass(ClassId.IBlockData, "net.minecraft.server." + VERSION + ".IBlockData");
                this.addClass(ClassId.World, "net.minecraft.server." + VERSION + ".World");
                this.addClass(ClassId.TileEntity, "net.minecraft.server." + VERSION + ".TileEntity");
                this.addClass(ClassId.TileEntitySkull, "net.minecraft.server." + VERSION + ".TileEntitySkull");
                this.addClass(ClassId.CraftServer, craftbukkitPackage + ".CraftServer");
                this.addClass(ClassId.CraftItemStack, craftbukkitPackage + ".inventory.CraftItemStack");
                this.addClass(ClassId.CraftMetaSkull, craftbukkitPackage + ".inventory.CraftMetaSkull");
                this.addClass(ClassId.CraftEntity, craftbukkitPackage + ".entity.CraftEntity");
                this.addClass(ClassId.CraftWorld, craftbukkitPackage + ".CraftWorld");
                this.addClass(ClassId.CraftBlockState, craftbukkitPackage + ".block.CraftBlockState");
                this.addClass(ClassId.GameProfile, "com.mojang.authlib.GameProfile");
                this.addClass(ClassId.Property, "com.mojang.authlib.properties.Property");
                this.addClass(ClassId.PropertyMap, "com.mojang.authlib.properties.PropertyMap");
                this.addMethod(MethodId.compoundGet, ClassId.NBTTagCompound, "get", String.class);
                this.addMethod(MethodId.compoundSet, ClassId.NBTTagCompound, "set", new Object[]{String.class, ClassId.NBTBase});
                this.addMethod(MethodId.compoundHasKey, ClassId.NBTTagCompound, "hasKey", String.class);
                this.addMethod(MethodId.listSet, ClassId.NBTTagList, "a", new Object[]{Integer.TYPE, ClassId.NBTBase});
                this.addMethod(MethodId.listAdd, ClassId.NBTTagList, "add", new Object[]{ClassId.NBTBase});
                this.addMethod(MethodId.listSize, ClassId.NBTTagList, "size", new Object[0]);
                this.addMethod(MethodId.listRemove, ClassId.NBTTagList, "a", Integer.TYPE);
                this.addMethod(MethodId.compoundRemove, ClassId.NBTTagCompound, "remove", String.class);
                this.addMethod(MethodId.compoundKeys, ClassId.NBTTagCompound, "c", new Object[0]);
                this.addMethod(MethodId.itemHasTag, ClassId.ItemStack, "hasTag", new Object[0]);
                this.addMethod(MethodId.getItemTag, ClassId.ItemStack, "getTag", new Object[0]);
                this.addMethod(MethodId.setItemTag, ClassId.ItemStack, "setTag", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.itemSave, ClassId.ItemStack, "save", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.asNMSCopy, ClassId.CraftItemStack, "asNMSCopy", ItemStack.class);
                this.addMethod(MethodId.asBukkitCopy, ClassId.CraftItemStack, "asBukkitCopy", new Object[]{ClassId.ItemStack});
                this.addMethod(MethodId.getEntityHandle, ClassId.CraftEntity, "getHandle", new Object[0]);
                this.addMethod(MethodId.getEntityTag, ClassId.Entity, "c", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.setEntityTag, ClassId.Entity, "f", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.createStack, ClassId.ItemStack, "createStack", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.setTileTag, ClassId.TileEntity, "a", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.getTileTag, ClassId.TileEntity, "b", new Object[]{ClassId.NBTTagCompound});
                this.addMethod(MethodId.getWorldHandle, ClassId.CraftWorld, "getHandle", new Object[0]);
                this.addMethod(MethodId.getTileEntity, ClassId.World, "getTileEntity", new Object[]{ClassId.BlockPosition});
                this.addMethod(MethodId.getProperties, ClassId.GameProfile, "getProperties", new Object[0]);
                this.addMethod(MethodId.setGameProfile, ClassId.TileEntitySkull, "setGameProfile", new Object[]{ClassId.GameProfile});
                this.addMethod(MethodId.propertyValues, ClassId.PropertyMap, "values", new Object[0]);
                this.addMethod(MethodId.putProperty, ClassId.PropertyMap, "put", Object.class, Object.class);
                this.addMethod(MethodId.getPropertyName, ClassId.Property, "getName", new Object[0]);
                this.addMethod(MethodId.getPropertyValue, ClassId.Property, "getValue", new Object[0]);
                this.addMethod(MethodId.loadNBTTagCompound, ClassId.MojangsonParser, "parse", String.class);
                this.addConstructor(ClassId.BlockPosition, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                this.addConstructor(ClassId.GameProfile, UUID.class, String.class);
                this.addConstructor(ClassId.Property, String.class, String.class);
            }
        }
    }

    private static enum Type {
        COMPOUND,
        LIST,
        NEW_ELEMENT,
        DELETE,
        CUSTOM_DATA,
        ITEMSTACK_COMPONENTS;

    }

    public static final class NBTCompound {
        protected final Object tag;

        protected NBTCompound(Object tag) {
            this.tag = tag;
        }

        public void set(Object value, Object ... keys) {
            try {
                NBTEditor.setTag(this.tag, value, keys);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public String toJson() {
            return this.tag.toString();
        }

        public static NBTCompound fromJson(String json) {
            try {
                return new NBTCompound(NBTEditor.getMethod(MethodId.loadNBTTagCompound).invoke(null, json));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }

        public String toString() {
            return this.tag.toString();
        }

        public int hashCode() {
            return this.tag.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NBTCompound other = (NBTCompound)obj;
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }
    }
}

