/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.Bukkit;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.platform.bukkit.BukkitAudiences;
import net.meme20200.Bukkit.Commands.BukkitDupeCommand;
import net.meme20200.Bukkit.Commands.BukkitDupePlusCommand;
import net.meme20200.Bukkit.Utilities.BukkitConfigyml;
import net.meme20200.Bukkit.Utilities.UpdateChecker;
import net.meme20200.Bukkit.events.NotifyJoinPlayer;
import net.meme20200.bukkit.Metrics;
import net.meme20200.charts.SimplePie;
import net.meme20200.commandapi.CommandAPI;
import net.meme20200.commandapi.CommandAPIBukkitConfig;
import net.meme20200.commandapi.CommandAPICommand;
import net.meme20200.commandapi.CommandPermission;
import net.meme20200.commandapi.arguments.Argument;
import net.meme20200.commandapi.arguments.ArgumentSuggestions;
import net.meme20200.commandapi.arguments.IntegerArgument;
import net.meme20200.commandapi.arguments.StringArgument;
import net.meme20200.commandapi.executors.ExecutorType;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitDupePlus
extends JavaPlugin {
    private static BukkitDupePlus plugin;
    private BukkitAudiences adventure;
    public static String version;
    public static boolean isItemsadderInstalled;
    public static boolean isPlaceholderAPIInstalled;

    @NotNull
    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public void reloadCommand(String customName) {
        if (!BukkitConfigyml.dupeAliases().isEmpty()) {
            ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(customName).withOptionalArguments(new Argument[]{new IntegerArgument("times")})).withAliases(BukkitConfigyml.dupeAliases().toArray(new String[0]))).withPermission(CommandPermission.NONE)).executes(new BukkitDupeCommand(), new ExecutorType[0])).register();
        } else {
            ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(customName).withOptionalArguments(new Argument[]{new IntegerArgument("times")})).withPermission(CommandPermission.NONE)).executes(new BukkitDupeCommand(), new ExecutorType[0])).register();
        }
    }

    public void onLoad() {
        plugin = this;
        CommandAPI.onLoad(new CommandAPIBukkitConfig(plugin).silentLogs(true));
    }

    public void onEnable() {
        CommandAPI.onEnable();
        this.adventure = BukkitAudiences.create((Plugin)plugin);
        version = plugin.getDescription().getVersion();
        this.checkConfigVersion();
        this.getConfig().options().copyDefaults();
        this.saveDefaultConfig();
        isItemsadderInstalled = this.getServer().getPluginManager().getPlugin("ItemsAdder") != null && BukkitConfigyml.config.getBoolean("integrations.itemsadder", true);
        isPlaceholderAPIInstalled = this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null && BukkitConfigyml.config.getBoolean("integrations.placeholderapi", true);
        Metrics metrics = new Metrics(this, 18772);
        metrics.addCustomChart(new SimplePie("configversion", () -> version));
        if (BukkitConfigyml.isCheckUpdateAllowed()) {
            new UpdateChecker(this, BukkitConfigyml.isSpigotMC()).getVersion(newversion -> {
                if (!version.equals(newversion)) {
                    if (BukkitConfigyml.isPlayerNotifyAllowed()) {
                        Bukkit.getServer().getPluginManager().registerEvents((Listener)new NotifyJoinPlayer((String)newversion), (Plugin)this);
                        return;
                    }
                    if ((BukkitConfigyml.isPlayerNotifyAllowed() || BukkitConfigyml.isConsoleNotifyAllowed()) && BukkitConfigyml.isConsoleNotifyAllowed()) {
                        BukkitConfigyml.updateConsoleMessage(this, newversion);
                    }
                }
            });
        }
        ((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("dupeplus").withOptionalArguments(new Argument[]{(Argument)new StringArgument("option").includeSuggestions(ArgumentSuggestions.strings("blacklist", "reload")), new StringArgument("item")})).withPermission(CommandPermission.OP)).executes(new BukkitDupePlusCommand(), new ExecutorType[0])).register();
        if (BukkitConfigyml.isCustomCommandEnabled() & !BukkitConfigyml.customCommandName().isEmpty()) {
            this.reloadCommand(BukkitConfigyml.customCommandName());
        } else {
            this.reloadCommand("dupe");
        }
    }

    public void onDisable() {
        CommandAPI.onDisable();
        if (this.adventure != null) {
            this.adventure.close();
            this.adventure = null;
        }
    }

    private void checkConfigVersion() {
        File configFile = new File(this.getDataFolder(), "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        ArrayList<String> versions = new ArrayList<String>(List.of("1.0", "1.1", "1.2", "1.3"));
        if (versions.contains(config.getString("config-version", "1.4"))) {
            File oldConfigFile = new File(this.getDataFolder(), "old.config.yml");
            if (oldConfigFile.exists()) {
                oldConfigFile.delete();
            }
            if (configFile.renameTo(oldConfigFile)) {
                this.getLogger().info("Old config renamed to old.config.yml");
            } else {
                this.getLogger().info("Failed to rename old config to old.config.yml");
            }
            this.saveResource("config.yml", true);
        }
    }

    public static BukkitDupePlus getPlugin() {
        return plugin;
    }

    public void unregisterCommands(String name) {
        CommandAPI.unregister(name);
    }

    static {
        version = "1.4.0";
        isItemsadderInstalled = false;
        isPlaceholderAPIInstalled = false;
    }
}

