/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.Bukkit.Commands;

import java.time.Duration;
import java.util.ArrayList;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.meme20200.Bukkit.BukkitDupePlus;
import net.meme20200.Bukkit.Utilities.BukkitConfigyml;
import net.meme20200.Bukkit.Utilities.CooldownManager;
import net.meme20200.commandapi.exceptions.WrapperCommandSyntaxException;
import net.meme20200.commandapi.executors.CommandArguments;
import net.meme20200.commandapi.executors.CommandExecutor;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class BukkitDupeCommand
implements CommandExecutor {
    private final CooldownManager cooldownManager = new CooldownManager();

    @Override
    public void run(CommandSender commandSender, CommandArguments commandArguments) throws WrapperCommandSyntaxException {
        ItemStack item;
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage(BukkitConfigyml.ConsoleMessage());
            return;
        }
        Player player = (Player)commandSender;
        Audience p = BukkitDupePlus.getPlugin().adventure().player(player);
        if (BukkitConfigyml.DupePermissionOption() && !BukkitConfigyml.hasDupePermission(player)) {
            BukkitConfigyml.DupeNoPermission(player, p);
            return;
        }
        if (BukkitConfigyml.isWorldsEnabled()) {
            if (BukkitConfigyml.getWorldsMode().equals("blacklist")) {
                if (BukkitConfigyml.getWorlds().contains(player.getWorld().getName())) {
                    BukkitConfigyml.WorldBlockedMessage(player, p);
                    return;
                }
            } else if (BukkitConfigyml.getWorldsMode().equals("whitelist") && !BukkitConfigyml.getWorlds().contains(player.getWorld().getName())) {
                BukkitConfigyml.WorldBlockedMessage(player, p);
                return;
            }
        }
        if ((item = BukkitConfigyml.getDupedItem(player)).getType() == Material.AIR) {
            BukkitConfigyml.dupingnothingmessage(player, p);
            return;
        }
        if (BukkitConfigyml.listEnabled()) {
            if (BukkitConfigyml.isblacklistEnabled()) {
                if (BukkitConfigyml.listedItems().contains(item.getType())) {
                    BukkitConfigyml.blockedmessage(player, p);
                    return;
                }
                if (BukkitConfigyml.CustomBlacklistItems(item)) {
                    BukkitConfigyml.blockedmessage(player, p);
                    return;
                }
                if (BukkitConfigyml.customBlacklistedNamespace(item)) {
                    BukkitConfigyml.blockedmessage(player, p);
                    return;
                }
            } else {
                if (!BukkitConfigyml.listedItems().contains(item.getType())) {
                    BukkitConfigyml.blockedmessage(player, p);
                    return;
                }
                if (!BukkitConfigyml.CustomBlacklistItems(item)) {
                    BukkitConfigyml.blockedmessage(player, p);
                    return;
                }
                if (!BukkitConfigyml.customBlacklistedNamespace(item)) {
                    BukkitConfigyml.blockedmessage(player, p);
                    return;
                }
            }
        }
        if (BukkitConfigyml.isCooldownEnabled() && this.cooldownManager.hasCooldown(player.getUniqueId())) {
            BukkitConfigyml.Cooldownmessage(p, player, this.formatDuration(this.cooldownManager.getRemainingCooldown(player.getUniqueId())));
            return;
        }
        if (BukkitConfigyml.isCustomNBTAllowed() && BukkitConfigyml.customNBTItem(player, item)) {
            BukkitConfigyml.customNBTItemMessage(player, p);
            return;
        }
        int times = (Integer)commandArguments.getOptional("times").orElse(0);
        if (BukkitConfigyml.timingsEnabled() && times != 0) {
            if (BukkitConfigyml.TimesPermissionOption() && !BukkitConfigyml.hasTimesPermission(player)) {
                BukkitConfigyml.TimesNoPermission(player, p);
                return;
            }
            try {
                if (BukkitConfigyml.timesMax(player) != 0 && !player.hasPermission("dupeplus.times.max.unlimited") && times > BukkitConfigyml.timesMax(player)) {
                    BukkitConfigyml.timesMaxMessage(player, p);
                    return;
                }
                if (BukkitConfigyml.timesMini() != 0 && !player.hasPermission("dupeplus.times.min.unlimited") && times < BukkitConfigyml.timesMini()) {
                    BukkitConfigyml.timesMiniMessage(player, p);
                    return;
                }
                if (item.getType() == Material.AIR) {
                    BukkitConfigyml.dupingnothingmessage(player, p);
                    return;
                }
                for (int i = 0; i < times; ++i) {
                    if (!BukkitConfigyml.isDupeMessageEmpty() && !BukkitConfigyml.OneTimeMessage()) {
                        BukkitConfigyml.DupeMessage(player, p);
                    }
                    this.dupe(player, item);
                }
                if (!BukkitConfigyml.isDupeMessageEmpty() && BukkitConfigyml.OneTimeMessage()) {
                    BukkitConfigyml.DupeMessage(player, p);
                }
                if (BukkitConfigyml.isCooldownEnabled()) {
                    this.cooldownManager.setCooldown(player.getUniqueId(), Duration.ofSeconds(BukkitConfigyml.cooldownSeconds()));
                }
                return;
            }
            catch (NumberFormatException e) {
                Component a = BukkitConfigyml.getPrefix().append((Component)MiniMessage.miniMessage().deserialize(" <dark_gray>|</dark_gray> <red>Enter a number next time!</red>"));
                p.sendMessage(a);
                return;
            }
        }
        if (!BukkitConfigyml.isDupeMessageEmpty()) {
            BukkitConfigyml.DupeMessage(player, p);
        }
        this.dupe(player, item);
        if (BukkitConfigyml.isCooldownEnabled()) {
            this.cooldownManager.setCooldown(player.getUniqueId(), Duration.ofSeconds(BukkitConfigyml.cooldownSeconds()));
        }
    }

    private void dupe(Player player, ItemStack item) {
        if (BukkitConfigyml.isLoreEnabled()) {
            item = BukkitConfigyml.addLore(item);
        }
        player.getInventory().addItem(new ItemStack[]{item});
    }

    private String formatDuration(Duration duration) {
        int minutes;
        int hours;
        ArrayList<String> parts = new ArrayList<String>();
        long days = duration.toDaysPart();
        if (days > 0L) {
            parts.add(this.plural(days, "day"));
        }
        if ((hours = duration.toHoursPart()) > 0 || !parts.isEmpty()) {
            parts.add(this.plural(hours, "hour"));
        }
        if ((minutes = duration.toMinutesPart()) > 0 || !parts.isEmpty()) {
            parts.add(this.plural(minutes, "minute"));
        }
        int seconds = duration.toSecondsPart();
        parts.add(this.plural(seconds, "second"));
        return String.join((CharSequence)", ", parts);
    }

    private String plural(long num, String unit) {
        return num + " " + unit + (num == 1L ? "" : "s");
    }
}

