/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.Bukkit.Utilities;

import dev.lone.itemsadder.api.CustomStack;
import io.github.bananapuncher714.nbteditor.NBTEditor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.meme20200.Bukkit.BukkitDupePlus;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class BukkitConfigyml {
    public static FileConfiguration config = BukkitDupePlus.getPlugin().getConfig();

    public static String ConsoleMessage() {
        return config.getString("dupe.console-message", "DupePlus | You can't do that!");
    }

    public static void reloadConfig() {
        if (BukkitConfigyml.isCustomCommandEnabled()) {
            BukkitDupePlus.getPlugin().unregisterCommands(BukkitConfigyml.customCommandName());
        } else {
            BukkitDupePlus.getPlugin().unregisterCommands("dupe");
        }
        if (!BukkitConfigyml.dupeAliases().isEmpty()) {
            for (String a : BukkitConfigyml.dupeAliases()) {
                BukkitDupePlus.getPlugin().unregisterCommands(a);
            }
        }
        BukkitDupePlus.getPlugin().reloadConfig();
        config = BukkitDupePlus.getPlugin().getConfig();
        if (BukkitConfigyml.isCustomCommandEnabled() & !BukkitConfigyml.customCommandName().isEmpty()) {
            BukkitDupePlus.getPlugin().reloadCommand(BukkitConfigyml.customCommandName());
        } else {
            BukkitDupePlus.getPlugin().reloadCommand("dupe");
        }
    }

    public static boolean dupingnothingmessage(Player player, Audience p) {
        Component a = BukkitConfigyml.format(player, config.getString("dupe.duping-nothing-message", ""), Placeholder.component("prefix", BukkitConfigyml.getPrefix()));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean DupePermissionOption() {
        return config.getBoolean("dupe.permission", false);
    }

    public static boolean isDupeMessageEmpty() {
        return config.getString("dupe.message", "<prefix> <dark_gray>|</dark_gray> <gray>Duped <dupe_item></gray>").isEmpty();
    }

    public static boolean hasDupePermission(Player player) {
        return player.hasPermission("dupeplus.dupe");
    }

    public static ItemStack getDupedItem(Player player) {
        if (config.getString("dupe.dupe-on", "MainHand").equals("MainHand")) {
            return player.getInventory().getItemInMainHand();
        }
        if (config.getString("dupe.dupe-on", "MainHand").equals("OffHand")) {
            return player.getInventory().getItemInOffHand();
        }
        return player.getInventory().getItemInMainHand();
    }

    public static boolean listEnabled() {
        return config.getBoolean("dupe.list.enabled", false);
    }

    public static boolean isblacklistEnabled() {
        return config.getBoolean("dupe.list.blacklist", true);
    }

    public static List<Material> listedItems() {
        List blacklistItemsSTR = config.getStringList("dupe.blacklist.items");
        ArrayList<Material> blacklistedItems = new ArrayList<Material>();
        for (String itemName : blacklistItemsSTR) {
            if (!itemName.startsWith("minecraft:")) continue;
            try {
                Material material = Material.valueOf((String)itemName.replaceAll("minecraft:", "").toUpperCase());
                blacklistedItems.add(material);
            }
            catch (IllegalArgumentException e) {
                BukkitDupePlus.getPlugin().getLogger().warning("Invalid Minecraft Item name in config: " + itemName);
            }
        }
        return blacklistedItems;
    }

    public static boolean CustomBlacklistItems(ItemStack itemStack) {
        List blacklistItemsSTR = config.getStringList("dupe.list.items");
        for (String itemName : blacklistItemsSTR) {
            if (!BukkitDupePlus.isItemsadderInstalled || !itemName.startsWith("itemsadder:")) continue;
            if (itemName.equalsIgnoreCase("itemsadder:*")) {
                return true;
            }
            CustomStack customStack = CustomStack.byItemStack((ItemStack)itemStack);
            if (customStack != null) {
                return Objects.equals(customStack.getId(), itemName.replaceAll("itemsadder:", ""));
            }
            return false;
        }
        return false;
    }

    public static boolean customBlacklistedNamespace(ItemStack itemStack) {
        List blacklistItemsSTR = config.getStringList("dupe.list.itemsadder-namespaces");
        for (String namespace : blacklistItemsSTR) {
            if (!BukkitDupePlus.isItemsadderInstalled) continue;
            CustomStack customStack = CustomStack.byItemStack((ItemStack)itemStack);
            if (customStack != null) {
                return Objects.equals(customStack.getNamespace(), namespace);
            }
            return false;
        }
        return false;
    }

    public static boolean timingsEnabled() {
        return config.getBoolean("dupe.times.enabled", false);
    }

    public static int timesMax(Player player) {
        ConfigurationSection maxValues = config.getConfigurationSection("dupe.times.max-values");
        if (maxValues == null) {
            return 5;
        }
        int maxAllowed = maxValues.getInt("default", 5);
        for (String key : maxValues.getKeys(false)) {
            String permission = "dupeplus.times.max." + key;
            if (!player.hasPermission(permission)) continue;
            int value = maxValues.getInt(key);
            if (value == 0) {
                return 0;
            }
            maxAllowed = Math.max(maxAllowed, value);
        }
        return maxAllowed;
    }

    public static int timesMini() {
        return config.getInt("dupe.times.mini", 0);
    }

    public static boolean timesMaxMessage(Player player, Audience p) {
        Component a = BukkitConfigyml.format(player, config.getString("dupe.times.max-message", "<prefix> <dark_gray>|</dark_gray> <red>This is above maximum! Do something lower than <max></red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("max", String.valueOf(BukkitConfigyml.timesMax(player))), Placeholder.unparsed("min", String.valueOf(BukkitConfigyml.timesMini())));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean timesMiniMessage(Player player, Audience p) {
        Component a = BukkitConfigyml.format(player, config.getString("dupe.times.min-message", "<prefix> <dark_gray>|</dark_gray> <red>This is lower than minimum! Do something higher than <min></red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("max", String.valueOf(BukkitConfigyml.timesMax(player))), Placeholder.unparsed("min", String.valueOf(BukkitConfigyml.timesMini())));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean hasTimesPermission(Player player) {
        return player.hasPermission("dupeplus.times");
    }

    public static boolean TimesNoPermission(@NotNull Player player, Audience p) {
        Component a = BukkitConfigyml.format(player, config.getString("dupe.permission-message", "<prefix> <dark_gray>|</dark_gray> <red>You are not allowed to use this command</red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean TimesPermissionOption() {
        return config.getBoolean("dupe.times.permission", false);
    }

    public static boolean OneTimeMessage() {
        return config.getBoolean("dupe.times.one-time-message", true);
    }

    @NotNull
    public static boolean DupeMessage(Player player, Audience p) {
        ItemStack item = BukkitConfigyml.getDupedItem(player);
        Component a = BukkitConfigyml.format(player, config.getString("dupe.message", "<prefix> <dark_gray>|</dark_gray> <gray>Duped <item_name> x<new_item_count></gray>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("item_name", BukkitConfigyml.itemStackName(item)), Placeholder.unparsed("item_type", item.getType().name()), Placeholder.unparsed("old_item_count", String.valueOf(item.getAmount())), Placeholder.unparsed("new_item_count", String.valueOf(Math.min(item.getAmount() * 2, 64))));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    @NotNull
    public static Component getPrefix() {
        return MiniMessage.miniMessage().deserialize(config.getString("dupe.prefix", "<green>DupePlus</green>"));
    }

    public static boolean DupeNoPermission(@NotNull Player player, Audience p) {
        Component a = BukkitConfigyml.format(player, config.getString("dupe.permission-message", "<prefix> <dark_gray>|</dark_gray> <red>You are not allowed to use this command</red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean blockedmessage(@NotNull Player player, Audience p) {
        ItemStack item = BukkitConfigyml.getDupedItem(player);
        Component a = BukkitConfigyml.format(player, config.getString("dupe.blacklist.blocked-message", "<prefix> <dark_gray>|</dark_gray> <red>The item is blocked from being duped!</red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("item_name", BukkitConfigyml.itemStackName(item)), Placeholder.unparsed("item_type", item.getType().name()), Placeholder.unparsed("item_count", String.valueOf(item.getAmount())));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean isCheckUpdateAllowed() {
        return config.getBoolean("updates.checkupdate", true);
    }

    public static boolean isCustomNBTAllowed() {
        return config.getBoolean("dupe.custom-nbt-item.enabled", true);
    }

    public static boolean isSpigotMC() {
        return config.getString("updates.api", "modrinth").equalsIgnoreCase("spigotmc");
    }

    public static boolean isPlayerNotifyAllowed() {
        return config.getBoolean("updates.notify.player-notify", true);
    }

    public static boolean isConsoleNotifyAllowed() {
        return config.getBoolean("updates.notify.console-notify", true);
    }

    public static void updatePlayerMessage(@NotNull Player player, @NotNull String newversion, Audience p) {
        String link = BukkitConfigyml.isSpigotMC() ? "https://www.spigotmc.org/resources/dupeplus.110621/" : "https://modrinth.com/plugin/dupeplus";
        Component a = BukkitConfigyml.format(player, config.getString("updates.notify.notify-message", "<prefix> <dark_gray>|</dark_gray> <white><green>DupePlus</green> is outdated, please update at: <blue><link></blue>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("link", link), Placeholder.unparsed("currentversion", BukkitDupePlus.version), Placeholder.unparsed("newversion", newversion));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
    }

    public static void updateConsoleMessage(@NotNull JavaPlugin plugin, @NotNull String newversion) {
        String link = BukkitConfigyml.isSpigotMC() ? "https://www.spigotmc.org/resources/dupeplus.110621/" : "https://modrinth.com/plugin/dupeplus";
        String b = config.getString("updates.notify.console-notify-message", "%prefix% | Update DupePlus at %link%").replaceAll("%prefix%", (String)MiniMessage.miniMessage().serialize(BukkitConfigyml.getPrefix())).replaceAll("%link%", link).replaceAll("%currentversion%", BukkitDupePlus.version).replaceAll("%newversion%", newversion);
        if (!b.isEmpty()) {
            plugin.getLogger().info(b);
        }
    }

    public static boolean isCooldownEnabled() {
        return config.getBoolean("dupe.cooldown.enabled", false);
    }

    public static long cooldownSeconds() {
        return config.getLong("dupe.cooldown.seconds", 3L);
    }

    public static boolean Cooldownmessage(Audience p, Player player, String timeleft) {
        Component a = BukkitConfigyml.format(player, config.getString("dupe.cooldown.wait-message", "<prefix> <dark_gray>|</dark_gray> <red>Please wait <duration>s.</red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("duration", timeleft));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean customNBTItem(Player player, ItemStack item) {
        if (NBTEditor.contains(item, new Object[]{NBTEditor.CUSTOM_DATA, "dupenotallowed"})) {
            return NBTEditor.getBoolean(BukkitConfigyml.getDupedItem(player), new Object[]{NBTEditor.CUSTOM_DATA, "dupenotallowed"});
        }
        return false;
    }

    private static String itemStackName(ItemStack itemStack) {
        if (itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        return BukkitConfigyml.formatItemStackName(itemStack.getType().name());
    }

    private static String formatItemStackName(String dupeTypeName) {
        String[] words = dupeTypeName.toLowerCase().split("_");
        StringBuilder dupeItem = new StringBuilder();
        for (String word : words) {
            dupeItem.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return dupeItem.toString().trim();
    }

    public static boolean customNBTItemMessage(Player player, Audience p) {
        ItemStack item = BukkitConfigyml.getDupedItem(player);
        Component a = BukkitConfigyml.format(player, config.getString("dupe.custom-nbt-item.blocked-message", "<prefix> <dark_gray>|</dark_gray> <red>The item is blocked from being duped!</red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("item_name", BukkitConfigyml.itemStackName(item)), Placeholder.unparsed("item_type", item.getType().name()), Placeholder.unparsed("item_count", String.valueOf(item.getAmount())));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static boolean isLoreEnabled() {
        return config.getBoolean("dupe.lore.enabled", true);
    }

    public static String getLoreMode() {
        return config.getString("dupe.lore.mode", "set");
    }

    public static List<String> itemsadderNamespaces() {
        return config.getStringList("dupe.list.itemsadder-namespaces");
    }

    public static String getTextLore() {
        return PlainTextComponentSerializer.plainText().serialize(BukkitConfigyml.format(config.getString("dupe.lore.text", "<dark_red>*</dark_red> <red>Duplicated Item</red>")));
    }

    public static ItemStack addLore(ItemStack itemStack) {
        ItemStack newItem = itemStack.clone();
        ItemMeta meta = newItem.getItemMeta();
        if (meta == null) {
            return newItem;
        }
        String loreMode = BukkitConfigyml.getLoreMode();
        String textLore = BukkitConfigyml.getTextLore();
        if (textLore == null || textLore.trim().isEmpty()) {
            return newItem;
        }
        ArrayList<String> newLore = new ArrayList<String>(Arrays.asList(textLore.split("\n", -1)));
        if (loreMode.equalsIgnoreCase("set")) {
            if (!meta.hasLore() || !meta.getLore().equals(newLore)) {
                meta.setLore(newLore);
            }
        } else if (loreMode.equalsIgnoreCase("append")) {
            List existingLore = meta.hasLore() ? meta.getLore() : new ArrayList();
            for (String line : newLore) {
                if (existingLore.contains(line)) continue;
                existingLore.add(line);
            }
            meta.setLore(existingLore);
        }
        newItem.setItemMeta(meta);
        return newItem;
    }

    public static boolean isCustomCommandEnabled() {
        return config.getBoolean("dupe.custom-command.enabled", false);
    }

    public static String customCommandName() {
        return config.getString("dupe.custom-command.name", "dupe");
    }

    public static List<String> dupeAliases() {
        return config.getStringList("dupe.aliases");
    }

    public static boolean isWorldsEnabled() {
        return config.getBoolean("dupe.worlds.enabled", false);
    }

    public static String getWorldsMode() {
        return config.getString("dupe.worlds.mode", "blacklist");
    }

    public static List<String> getWorlds() {
        return config.getStringList("dupe.worlds.worlds");
    }

    public static boolean WorldBlockedMessage(Player player, Audience p) {
        ItemStack item = BukkitConfigyml.getDupedItem(player);
        Component a = BukkitConfigyml.format(player, config.getString("dupe.custom-nbt-item.blocked-message", "<prefix> <dark_gray>|</dark_gray> <red>The item is blocked from being duped!</red>"), Placeholder.component("prefix", BukkitConfigyml.getPrefix()), Placeholder.unparsed("item_name", BukkitConfigyml.itemStackName(item)), Placeholder.unparsed("item_type", item.getType().name()), Placeholder.unparsed("item_count", String.valueOf(item.getAmount())), Placeholder.unparsed("world", player.getWorld().getName()));
        if (!PlainTextComponentSerializer.plainText().serialize(a).isEmpty()) {
            p.sendMessage(a);
        }
        return true;
    }

    public static Component format(Player player, String text, TagResolver ... resolvers) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        if (BukkitDupePlus.isPlaceholderAPIInstalled) {
            text = PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return BukkitConfigyml.parseText(text, resolvers);
    }

    public static Component format(String text) {
        if (text == null || text.isEmpty()) {
            return Component.empty();
        }
        return BukkitConfigyml.parseText(text, new TagResolver[0]);
    }

    private static Component parseText(String text, TagResolver ... resolvers) {
        if (BukkitConfigyml.looksLikeMiniMessage(text)) {
            try {
                return MiniMessage.miniMessage().deserialize(text, resolvers);
            }
            catch (Exception e) {
                return LegacyComponentSerializer.legacyAmpersand().deserialize(text);
            }
        }
        return LegacyComponentSerializer.legacyAmpersand().deserialize(text);
    }

    private static boolean looksLikeMiniMessage(String text) {
        return text.contains("<") && text.contains(">");
    }
}

