/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.Bukkit.Utilities;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private final Map<UUID, Instant> map = new HashMap<UUID, Instant>();

    public void setCooldown(UUID key, Duration duration) {
        this.map.put(key, Instant.now().plus(duration));
    }

    public boolean hasCooldown(UUID key) {
        Instant cooldown = this.map.get(key);
        return cooldown != null && Instant.now().isBefore(cooldown);
    }

    public Instant removeCooldown(UUID key) {
        return this.map.remove(key);
    }

    public Duration getRemainingCooldown(UUID key) {
        Instant cooldown = this.map.get(key);
        Instant now = Instant.now();
        if (cooldown != null && now.isBefore(cooldown)) {
            return Duration.between(now, cooldown);
        }
        return Duration.ZERO;
    }
}

