/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.Bukkit.Utilities;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateChecker {
    private final JavaPlugin plugin;
    private final boolean isSpigot;

    public UpdateChecker(JavaPlugin plugin, boolean isSpigot) {
        this.plugin = plugin;
        this.isSpigot = isSpigot;
    }

    public void SpigotVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream is = new URL("https://api.spigotmc.org/legacy/update.php?resource=110621/~").openStream();
                 Scanner scann = new Scanner(is);){
                if (scann.hasNext()) {
                    consumer.accept(scann.next());
                } else {
                    this.plugin.getLogger().info("No version information available from Spigot.");
                    consumer.accept(null);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().info("Unable to check for updates (Spigot): " + e.getMessage());
                consumer.accept(null);
            }
        });
    }

    public void ModrinthVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (InputStream is = new URL("https://api.modrinth.com/v2/project/pyRTWAFM/version").openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                StringBuilder response = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                }
                JSONArray jsonResponse = new JSONArray(response.toString());
                if (!jsonResponse.isEmpty()) {
                    JSONObject latestVersion = jsonResponse.getJSONObject(0);
                    String versionNumber = latestVersion.getString("version_number");
                    consumer.accept(versionNumber);
                } else {
                    this.plugin.getLogger().info("No version information available from Modrinth.");
                    consumer.accept(null);
                }
            }
            catch (IOException e) {
                this.plugin.getLogger().info("Unable to check for updates (Modrinth): " + e.getMessage());
                consumer.accept(null);
            }
        });
    }

    public void getVersion(Consumer<String> consumer) {
        if (this.isSpigot) {
            this.SpigotVersion(consumer);
        } else {
            this.ModrinthVersion(consumer);
        }
    }
}

