/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.commandapi.arguments;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.meme20200.commandapi.IStringTooltip;
import net.meme20200.commandapi.SuggestionInfo;

@FunctionalInterface
public interface ArgumentSuggestions<CommandSender> {
    public CompletableFuture<Suggestions> suggest(SuggestionInfo<CommandSender> var1, SuggestionsBuilder var2) throws CommandSyntaxException;

    public static <CommandSender> ArgumentSuggestions<CommandSender> empty() {
        return (info, builder) -> builder.buildFuture();
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> strings(String ... suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, suggestions));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> strings(Collection<String> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, suggestions));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> strings(Function<SuggestionInfo<CommandSender>, String[]> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, (String[])suggestions.apply(info)));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringCollection(Function<SuggestionInfo<CommandSender>, Collection<String>> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromStrings(builder, (Collection)suggestions.apply(info)));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<String[]>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(strings -> ArgumentSuggestions.suggestionsFromStrings(builder, strings));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringCollectionAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<Collection<String>>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(strings -> ArgumentSuggestions.suggestionsFromStrings(builder, strings));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsWithTooltips(IStringTooltip ... suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, suggestions));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsWithTooltips(Collection<IStringTooltip> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, suggestions));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsWithTooltips(Function<SuggestionInfo<CommandSender>, IStringTooltip[]> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, (IStringTooltip[])suggestions.apply(info)));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsWithTooltipsCollection(Function<SuggestionInfo<CommandSender>, Collection<IStringTooltip>> suggestions) {
        return (info, builder) -> ArgumentSuggestions.future(ArgumentSuggestions.suggestionsFromTooltips(builder, (Collection)suggestions.apply(info)));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsWithTooltipsAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<IStringTooltip[]>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(stringsWithTooltips -> ArgumentSuggestions.suggestionsFromTooltips(builder, stringsWithTooltips));
    }

    public static <CommandSender> ArgumentSuggestions<CommandSender> stringsWithTooltipsCollectionAsync(Function<SuggestionInfo<CommandSender>, CompletableFuture<Collection<IStringTooltip>>> suggestions) {
        return (info, builder) -> ((CompletableFuture)suggestions.apply(info)).thenApply(stringsWithTooltips -> ArgumentSuggestions.suggestionsFromTooltips(builder, stringsWithTooltips));
    }

    @SafeVarargs
    public static <CommandSender> ArgumentSuggestions<CommandSender> merge(ArgumentSuggestions<CommandSender> ... suggestions) {
        return (info, builder) -> {
            for (ArgumentSuggestions suggestion : suggestions) {
                suggestion.suggest(info, builder);
            }
            return builder.buildFuture();
        };
    }

    private static Suggestions suggestionsFromStrings(SuggestionsBuilder builder, String ... suggestions) {
        for (String suggestion : suggestions) {
            if (!ArgumentSuggestions.shouldSuggest(builder, suggestion)) continue;
            builder.suggest(suggestion);
        }
        return builder.build();
    }

    private static Suggestions suggestionsFromStrings(SuggestionsBuilder builder, Collection<String> suggestions) {
        for (String suggestion : suggestions) {
            if (!ArgumentSuggestions.shouldSuggest(builder, suggestion)) continue;
            builder.suggest(suggestion);
        }
        return builder.build();
    }

    private static Suggestions suggestionsFromTooltips(SuggestionsBuilder builder, IStringTooltip ... suggestions) {
        for (IStringTooltip suggestion : suggestions) {
            ArgumentSuggestions.processSuggestion(builder, suggestion);
        }
        return builder.build();
    }

    private static Suggestions suggestionsFromTooltips(SuggestionsBuilder builder, Collection<IStringTooltip> suggestions) {
        for (IStringTooltip suggestion : suggestions) {
            ArgumentSuggestions.processSuggestion(builder, suggestion);
        }
        return builder.build();
    }

    private static void processSuggestion(SuggestionsBuilder builder, IStringTooltip suggestion) {
        if (!ArgumentSuggestions.shouldSuggest(builder, suggestion.getSuggestion())) {
            return;
        }
        if (suggestion.getTooltip() == null) {
            builder.suggest(suggestion.getSuggestion());
        } else {
            builder.suggest(suggestion.getSuggestion(), suggestion.getTooltip());
        }
    }

    private static boolean shouldSuggest(SuggestionsBuilder builder, String suggestion) {
        return suggestion.toLowerCase(Locale.ROOT).startsWith(builder.getRemaining().toLowerCase(Locale.ROOT));
    }

    private static <T> CompletableFuture<T> future(T value) {
        return CompletableFuture.completedFuture(value);
    }
}

