/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.concurrent.CompletableFuture;
import net.meme20200.commandapi.CommandAPIBukkit;
import net.meme20200.commandapi.arguments.CommandAPIArgumentType;
import net.meme20200.commandapi.arguments.SafeOverrideableArgument;
import net.meme20200.commandapi.executors.CommandArguments;
import org.bukkit.OfflinePlayer;

public class AsyncOfflinePlayerArgument
extends SafeOverrideableArgument<CompletableFuture<OfflinePlayer>, OfflinePlayer> {
    public AsyncOfflinePlayerArgument(String nodeName) {
        super(nodeName, CommandAPIBukkit.get()._ArgumentProfile(), OfflinePlayer::getName);
    }

    @Override
    public Class<CompletableFuture<OfflinePlayer>> getPrimitiveType() {
        return CompletableFuture.class;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.ASYNC_OFFLINE_PLAYER;
    }

    @Override
    public <CommandSourceStack> CompletableFuture<OfflinePlayer> parseArgument(CommandContext<CommandSourceStack> cmdCtx, String key, CommandArguments previousArgs) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return CommandAPIBukkit.get().getOfflinePlayer(cmdCtx, key);
            }
            catch (CommandSyntaxException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

