/*
 * Decompiled with CFR 0.152.
 */
package net.meme20200.commandapi.arguments;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.meme20200.commandapi.arguments.Argument;
import net.meme20200.commandapi.arguments.CommandAPIArgumentType;
import net.meme20200.commandapi.arguments.Literal;
import net.meme20200.commandapi.exceptions.BadLiteralException;
import net.meme20200.commandapi.executors.CommandArguments;

public class LiteralArgument
extends Argument<String>
implements Literal<Argument<String>> {
    private final String literal;

    public LiteralArgument(String literal) {
        this(literal, literal);
    }

    public LiteralArgument(String nodeName, String literal) {
        super(nodeName, null);
        if (literal == null) {
            throw new BadLiteralException(true);
        }
        if (literal.isEmpty()) {
            throw new BadLiteralException(false);
        }
        this.literal = literal;
        this.setListed(false);
    }

    @Override
    public Class<String> getPrimitiveType() {
        return String.class;
    }

    public static LiteralArgument of(String literal) {
        return new LiteralArgument(literal);
    }

    public static LiteralArgument literal(String literal) {
        return new LiteralArgument(literal);
    }

    public static LiteralArgument of(String nodeName, String literal) {
        return new LiteralArgument(nodeName, literal);
    }

    public static LiteralArgument literal(String nodeName, String literal) {
        return new LiteralArgument(nodeName, literal);
    }

    @Override
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public CommandAPIArgumentType getArgumentType() {
        return CommandAPIArgumentType.LITERAL;
    }

    @Override
    public String getHelpString() {
        return this.literal;
    }

    @Override
    public <Source> String parseArgument(CommandContext<Source> cmdCtx, String key, CommandArguments previousArgs) throws CommandSyntaxException {
        return this.literal;
    }
}

